/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.Utils;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinInstanceAutocomplete {
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinInstanceAutocomplete.class);
    @Nullable
    public static LiteralCommandNode<FabricClientCommandSource> joinInstanceCommand;
    @Nullable
    public static LiteralCommandNode<FabricClientCommandSource> dungeonCommand;
    @Nullable
    public static LiteralCommandNode<FabricClientCommandSource> kuudraCommand;
    private static Map<String, String> instanceMap;

    @Init
    public static void init() {
        CompletableFuture.runAsync(() -> {
            try {
                String json = Http.sendGetRequest("https://hysky.de/api/joininstances");
                JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
                instanceMap = obj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsString()));
                joinInstanceCommand = JoinInstanceAutocomplete.buildCommand("joininstance", s -> true);
                dungeonCommand = JoinInstanceAutocomplete.buildCommand("joindungeon", s -> instanceMap.get(s).equalsIgnoreCase("Catacombs"));
                kuudraCommand = JoinInstanceAutocomplete.buildCommand("joinkuudra", s -> instanceMap.get(s).equalsIgnoreCase("Kuudra"));
            }
            catch (Exception e2) {
                LOGGER.error("[Skyblocker] Failed to load joininstance list", (Throwable)e2);
            }
        });
    }

    private static LiteralCommandNode<FabricClientCommandSource> buildCommand(String command, Predicate<String> filter) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)command).requires(source -> Utils.isOnSkyblock())).then((ArgumentBuilder)ClientCommandManager.argument((String)"instance", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9264(instanceMap.keySet().stream().filter(filter).sorted(), (SuggestionsBuilder)builder)))).build();
    }
}

