/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.Utils;
import io.github.moulberry.repo.data.NEUItem;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SackItemAutocomplete {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern BAD_CHARACTERS = Pattern.compile("[\u2602\u2618\u2620\u270e\u2727\u2741\u2742\u2748\u2764\u2e15]");
    @Nullable
    public static LiteralCommandNode<FabricClientCommandSource> longCommandNode;
    @Nullable
    public static LiteralCommandNode<FabricClientCommandSource> shortCommandNode;

    @Init
    public static void init() {
        NEURepoManager.runAsyncAfterLoad(SackItemAutocomplete::loadSackItems);
    }

    private static void loadSackItems() {
        try (InputStream stream = NEURepoManager.file("constants/sacks.json").stream();){
            JsonObject sacks = JsonParser.parseString((String)new String(stream.readAllBytes())).getAsJsonObject().getAsJsonObject("sacks");
            Set sackItemIds = sacks.entrySet().stream().map(entry -> ((JsonElement)entry.getValue()).getAsJsonObject()).map(sack -> sack.getAsJsonArray("contents")).map(JsonArray::asList).flatMap(Collection::stream).map(JsonElement::getAsString).collect(Collectors.toUnmodifiableSet());
            Set<String> sackItems = sackItemIds.stream().map(neuId -> {
                NEUItem stack = NEURepoManager.getItemByNeuId(neuId);
                return stack != null ? class_124.method_539((String)stack.getDisplayName()) : neuId;
            }).map(name -> BAD_CHARACTERS.matcher((CharSequence)name).replaceAll("").trim()).collect(Collectors.toUnmodifiableSet());
            longCommandNode = SackItemAutocomplete.createCommandNode("getfromsacks", sackItems);
            shortCommandNode = SackItemAutocomplete.createCommandNode("gfs", sackItems);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Sack Item Autocomplete] Failed to load sacks data from the NEU Repo.", (Throwable)e);
        }
    }

    private static LiteralCommandNode<FabricClientCommandSource> createCommandNode(String command, Set<String> sackItems) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)command).requires(fccs -> Utils.isOnSkyblock())).then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265((Iterable)sackItems, (SuggestionsBuilder)builder)).then((ArgumentBuilder)ClientCommandManager.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0))))).build();
    }
}

