/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.utils.CollectionUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ChatRule {
    @VisibleForTesting
    static final Codec<EnumSet<Location>> LOCATION_FIXING_CODEC = Codec.either(Location.SET_CODEC, (Codec)Codec.STRING).xmap(either -> (EnumSet)either.map(Function.identity(), ChatRule::encodeString), Either::left);
    private static final Codec<ChatRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ChatRule::getName), (App)Codec.BOOL.fieldOf("enabled").forGetter(ChatRule::getEnabled), (App)Codec.BOOL.fieldOf("isPartialMatch").forGetter(ChatRule::getPartialMatch), (App)Codec.BOOL.fieldOf("isRegex").forGetter(ChatRule::getRegex), (App)Codec.BOOL.fieldOf("isIgnoreCase").forGetter(ChatRule::getIgnoreCase), (App)Codec.STRING.fieldOf("filter").forGetter(ChatRule::getFilter), (App)LOCATION_FIXING_CODEC.fieldOf("validLocations").forGetter(ChatRule::getValidLocations), (App)Codec.BOOL.fieldOf("hideMessage").forGetter(ChatRule::getHideMessage), (App)Codec.BOOL.fieldOf("showActionBar").forGetter(ChatRule::getShowActionBar), (App)Codec.BOOL.fieldOf("showAnnouncement").forGetter(ChatRule::getShowAnnouncement), (App)Codec.STRING.optionalFieldOf("replaceMessage").forGetter(ChatRule::getReplaceMessageOpt), (App)class_3414.field_41698.optionalFieldOf("customSound").forGetter(ChatRule::getCustomSoundOpt)).apply((Applicative)instance, ChatRule::new));
    public static final Codec<List<ChatRule>> LIST_CODEC = CODEC.listOf();
    private String name;
    private Pattern pattern;
    private boolean enabled;
    private boolean isPartialMatch;
    private boolean isRegex;
    private boolean isIgnoreCase;
    private String filter;
    private EnumSet<Location> validLocations;
    private boolean hideMessage;
    private boolean showActionBar;
    private boolean showAnnouncement;
    private String replaceMessage;
    private class_3414 customSound;

    protected ChatRule() {
        this.name = "New Rule";
        this.enabled = true;
        this.isPartialMatch = false;
        this.isRegex = false;
        this.isIgnoreCase = true;
        this.filter = "";
        this.validLocations = EnumSet.noneOf(Location.class);
        this.hideMessage = true;
        this.showActionBar = false;
        this.showAnnouncement = false;
        this.replaceMessage = null;
        this.customSound = null;
    }

    public ChatRule(String name, boolean enabled, boolean isPartialMatch, boolean isRegex, boolean isIgnoreCase, String filter, EnumSet<Location> validLocations, boolean hideMessage, boolean showActionBar, boolean showAnnouncement, @Nullable String replaceMessage, @Nullable class_3414 customSound) {
        this.name = name;
        this.enabled = enabled;
        this.isPartialMatch = isPartialMatch;
        this.isRegex = isRegex;
        this.isIgnoreCase = isIgnoreCase;
        this.filter = filter;
        this.validLocations = validLocations;
        this.hideMessage = hideMessage;
        this.showActionBar = showActionBar;
        this.showAnnouncement = showAnnouncement;
        this.replaceMessage = replaceMessage;
        this.customSound = customSound;
    }

    private ChatRule(String name, boolean enabled, boolean isPartialMatch, boolean isRegex, boolean isIgnoreCase, String filter, EnumSet<Location> validLocations, boolean hideMessage, boolean showActionBar, boolean showAnnouncement, Optional<String> replaceMessage, Optional<class_3414> customSound) {
        this(name, enabled, isPartialMatch, isRegex, isIgnoreCase, filter, validLocations, hideMessage, showActionBar, showAnnouncement, (String)replaceMessage.orElse(null), (class_3414)customSound.orElse(null));
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected boolean getEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected boolean getPartialMatch() {
        return this.isPartialMatch;
    }

    protected void setPartialMatch(boolean partialMatch) {
        this.isPartialMatch = partialMatch;
    }

    protected boolean getRegex() {
        return this.isRegex;
    }

    protected void setRegex(boolean regex) {
        this.isRegex = regex;
        this.pattern = null;
    }

    protected boolean getIgnoreCase() {
        return this.isIgnoreCase;
    }

    protected void setIgnoreCase(boolean ignoreCase) {
        this.isIgnoreCase = ignoreCase;
        this.pattern = null;
    }

    protected String getFilter() {
        return this.filter;
    }

    protected void setFilter(String filter) {
        this.filter = filter;
        this.pattern = null;
    }

    protected boolean getHideMessage() {
        return this.hideMessage;
    }

    protected void setHideMessage(boolean hideMessage) {
        this.hideMessage = hideMessage;
    }

    protected boolean getShowActionBar() {
        return this.showActionBar;
    }

    protected void setShowActionBar(boolean showActionBar) {
        this.showActionBar = showActionBar;
    }

    protected boolean getShowAnnouncement() {
        return this.showAnnouncement;
    }

    protected void setShowAnnouncement(boolean showAnnouncement) {
        this.showAnnouncement = showAnnouncement;
    }

    protected String getReplaceMessage() {
        return this.replaceMessage;
    }

    private Optional<String> getReplaceMessageOpt() {
        return Optional.ofNullable(this.replaceMessage);
    }

    protected void setReplaceMessage(String replaceMessage) {
        this.replaceMessage = replaceMessage;
    }

    protected class_3414 getCustomSound() {
        return this.customSound;
    }

    private Optional<class_3414> getCustomSoundOpt() {
        return Optional.ofNullable(this.customSound);
    }

    protected void setCustomSound(class_3414 customSound) {
        this.customSound = customSound;
    }

    protected EnumSet<Location> getValidLocations() {
        return this.validLocations;
    }

    protected void setValidLocations(EnumSet<Location> validLocations) {
        this.validLocations = validLocations;
    }

    private void compilePattern(String filterText) {
        if (this.pattern != null) {
            return;
        }
        try {
            this.pattern = Pattern.compile(filterText);
        }
        catch (PatternSyntaxException ex) {
            this.enabled = false;
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) {
                return;
            }
            client.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.config.chat.chatRules.invalidRegex", (Object[])new Object[]{this.name})), false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Match isMatch(String inputString) {
        Match match;
        String testFilter;
        if (!this.enabled) {
            return Match.noMatch();
        }
        String testString = this.isIgnoreCase ? inputString.toLowerCase(Locale.ENGLISH) : inputString;
        String string = testFilter = this.isIgnoreCase ? this.filter.toLowerCase(Locale.ENGLISH) : this.filter;
        if (testFilter.isBlank()) {
            return Match.noMatch();
        }
        if (this.isRegex) {
            this.compilePattern(testFilter);
            if (this.pattern == null) {
                return Match.noMatch();
            }
            Matcher matcher = this.pattern.matcher(testString);
            if (this.isPartialMatch) {
                if (!matcher.find()) return Match.noMatch();
                match = Match.ofRegex(matcher);
            } else {
                if (!matcher.matches()) return Match.noMatch();
                match = Match.ofRegex(matcher);
            }
        } else if (this.isPartialMatch) {
            if (!testString.contains(testFilter)) return Match.noMatch();
            match = Match.ofString();
        } else {
            if (!testFilter.equals(testString)) return Match.noMatch();
            match = Match.ofString();
        }
        if (this.validLocations.isEmpty()) {
            return match;
        }
        if (this.validLocations.size() != 1 || !this.validLocations.contains((Object)Location.UNKNOWN)) return this.validLocations.contains((Object)Utils.getLocation()) ? match : Match.noMatch();
        return match;
    }

    private static EnumSet<Location> encodeString(String string) {
        if (string.isEmpty()) {
            return EnumSet.noneOf(Location.class);
        }
        if (string.contains("!")) {
            return EnumSet.complementOf(Arrays.stream(string.split(", ?")).filter(s1 -> s1.startsWith("!")).map(s -> s.substring(1)).map(Location::fromFriendlyName).collect(CollectionUtils.enumSetCollector(Location.class)));
        }
        return Arrays.stream(string.split(", ?")).map(Location::fromFriendlyName).collect(CollectionUtils.enumSetCollector(Location.class));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChatRule)) {
            return false;
        }
        ChatRule chatRule = (ChatRule)o;
        return Objects.equals(this.getName(), chatRule.getName()) && this.getEnabled() == chatRule.getEnabled() && this.getPartialMatch() == chatRule.getPartialMatch() && this.getRegex() == chatRule.getRegex() && this.getIgnoreCase() == chatRule.getIgnoreCase() && Objects.equals(this.getFilter(), chatRule.getFilter()) && Objects.equals(this.getValidLocations(), chatRule.getValidLocations()) && this.getHideMessage() == chatRule.getHideMessage() && this.getShowActionBar() == chatRule.getShowActionBar() && this.getShowAnnouncement() == chatRule.getShowAnnouncement() && Objects.equals(this.getReplaceMessage(), chatRule.getReplaceMessage()) && Objects.equals(this.getCustomSound(), chatRule.getCustomSound());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getEnabled(), this.getPartialMatch(), this.getRegex(), this.getIgnoreCase(), this.getFilter(), this.getValidLocations(), this.getHideMessage(), this.getShowActionBar(), this.getShowAnnouncement(), this.getReplaceMessage(), this.getCustomSound());
    }

    protected record Match(boolean matches, Optional<Matcher> matcher) {
        protected static Match noMatch() {
            return new Match(false, Optional.empty());
        }

        protected static Match ofString() {
            return new Match(true, Optional.empty());
        }

        protected static Match ofRegex(Matcher matcher) {
            return new Match(true, Optional.of(matcher));
        }

        protected String insertCaptureGroups(String replaceMessage) {
            if (!this.matches || this.matcher.isEmpty()) {
                return replaceMessage;
            }
            StringBuilder sb = new StringBuilder();
            this.matcher.get().appendReplacement(sb, replaceMessage);
            return sb.substring(this.matcher.get().start());
        }
    }
}

