/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import de.hysky.skyblocker.skyblock.chat.ChatRule;
import de.hysky.skyblocker.skyblock.chat.ChatRuleLocationConfigScreen;
import de.hysky.skyblocker.skyblock.chat.ChatRulesHandler;
import de.hysky.skyblocker.utils.WidgetUtils;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class ChatRuleConfigScreen
extends class_437 {
    private static final int SPACER_X = 5;
    private static final int SPACER_Y = 5;
    private final Map<class_5250, class_3414> soundsLookup = Map.ofEntries(Map.entry(class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.pling"), (class_3414)class_3417.field_14622.comp_349()), Map.entry(class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.cave"), (class_3414)class_3417.field_14564.comp_349()), Map.entry(class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.zombie"), class_3417.field_15174), Map.entry(class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.crit"), class_3417.field_15016), Map.entry(class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.arrowHit"), class_3417.field_15224), Map.entry(class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.amethyst"), class_3417.field_26982), Map.entry(class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.anvil"), class_3417.field_14833));
    private static final int MAX_WIDTH = 360;
    private static final int BUTTON_WIDTH = 75;
    private static final int ROW_HEIGHT = 20;
    private static final int Y_OFFSET;
    private final int chatRuleIndex;
    private final ChatRule chatRule;
    private final class_342 nameInput;
    private final class_342 filterInput;
    private class_4185 partialMatchToggle;
    private class_4185 regexToggle;
    private class_4185 ignoreCaseToggle;
    private final class_4185 locationsConfigButton;
    private class_4185 hideMessageToggle;
    private class_4185 actionBarToggle;
    private class_4185 announcementToggle;
    private class_4185 soundsToggle;
    private final class_4185 finishButton;
    private final class_342 replaceMessageInput;
    private final class_7842 nameLabel;
    private final class_7842 inputsLabel;
    private final class_7842 filterLabel;
    private final class_7842 partialMatchLabel;
    private final class_7842 regexLabel;
    private final class_7842 ignoreCaseLabel;
    private final class_7842 locationLabel;
    private final class_7842 outputsLabel;
    private final class_7842 hideMessageLabel;
    private final class_7842 actionBarLabel;
    private final class_7842 announcementLabel;
    private final class_7842 soundsLabel;
    private final class_7842 replaceMessageLabel;
    private final class_7842 titleWidget;
    private int currentSoundIndex;
    private final class_437 parent;

    public ChatRuleConfigScreen(class_437 parent, int chatRuleIndex) {
        super((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen"));
        this.chatRuleIndex = chatRuleIndex;
        this.chatRule = ChatRulesHandler.chatRuleList.getData().get(chatRuleIndex);
        this.parent = parent;
        this.currentSoundIndex = this.getCurrentSoundIndex();
        this.field_22787 = class_310.method_1551();
        this.field_22789 = this.field_22787.method_22683().method_4486();
        this.field_22790 = this.field_22787.method_22683().method_4502();
        Objects.requireNonNull(this.field_22787.field_1772);
        this.titleWidget = new class_7842(0, 16, this.field_22789, 9, this.method_25440(), this.field_22787.field_1772).method_48597();
        IntIntImmutablePair rootPos = this.getRootPos();
        IntIntMutablePair currentPos = IntIntMutablePair.of((int)0, (int)0);
        Objects.requireNonNull(this.field_22787.field_1772);
        int yOffset = (20 - 9) / 2;
        class_5250 nameText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.name");
        this.nameLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)nameText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)nameText));
        int textFieldWidth = 200;
        this.nameInput = new class_342(this.field_22787.field_1772, rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt(), textFieldWidth, 20, class_2561.method_30163((String)""));
        this.nameInput.method_1852(this.chatRule.getName());
        this.nameInput.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.name.@Tooltip")));
        ChatRuleConfigScreen.nextRow(currentPos);
        this.inputsLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.inputs").method_27692(class_124.field_1067));
        ChatRuleConfigScreen.nextRow(currentPos);
        class_5250 filterText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.filter");
        this.filterLabel = ChatRuleConfigScreen.textWidget((IntIntPair)currentPos, (IntIntPair)rootPos, yOffset, (class_2561)filterText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)filterText));
        this.filterInput = new class_342(this.field_22787.field_1772, rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt(), textFieldWidth, 20, class_2561.method_30163((String)""));
        this.filterInput.method_1880(256);
        this.filterInput.method_1852(this.chatRule.getFilter());
        this.filterInput.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.filter.@Tooltip")));
        ChatRuleConfigScreen.nextRow(currentPos);
        class_5250 partialMatchText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.partialMatch");
        this.partialMatchLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)partialMatchText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)partialMatchText));
        this.partialMatchToggle = class_4185.method_46430((class_2561)this.enabledButtonText(this.chatRule.getPartialMatch()), a -> {
            this.chatRule.setPartialMatch(!this.chatRule.getPartialMatch());
            this.partialMatchToggle.method_25355(this.enabledButtonText(this.chatRule.getPartialMatch()));
        }).method_46433(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt()).method_46437(75, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.partialMatch.@Tooltip"))).method_46431();
        ChatRuleConfigScreen.nextColumn(currentPos, 75);
        class_5250 regexLabelText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.regex");
        this.regexLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)regexLabelText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)regexLabelText));
        this.regexToggle = class_4185.method_46430((class_2561)this.enabledButtonText(this.chatRule.getRegex()), a -> {
            this.chatRule.setRegex(!this.chatRule.getRegex());
            this.regexToggle.method_25355(this.enabledButtonText(this.chatRule.getRegex()));
        }).method_46433(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt()).method_46437(75, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.regex.@Tooltip"))).method_46431();
        ChatRuleConfigScreen.nextRow(currentPos);
        class_5250 ignoreCaseText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.ignoreCase");
        this.ignoreCaseLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)ignoreCaseText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)ignoreCaseText));
        this.ignoreCaseToggle = class_4185.method_46430((class_2561)this.enabledButtonText(this.chatRule.getIgnoreCase()), a -> {
            this.chatRule.setIgnoreCase(!this.chatRule.getIgnoreCase());
            this.ignoreCaseToggle.method_25355(this.enabledButtonText(this.chatRule.getIgnoreCase()));
        }).method_46433(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt()).method_46437(75, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.ignoreCase.@Tooltip"))).method_46431();
        ChatRuleConfigScreen.nextColumn(currentPos, 75);
        class_5250 locationsText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.locations");
        this.locationLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)locationsText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)locationsText));
        this.locationsConfigButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"text.skyblocker.open"), widget -> this.field_22787.method_1507((class_437)new ChatRuleLocationConfigScreen(this, this.chatRule))).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.locations.@Tooltip"))).method_46434(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt(), 75, 20).method_46431();
        ChatRuleConfigScreen.nextRow(currentPos);
        this.outputsLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.outputs").method_27692(class_124.field_1067));
        ChatRuleConfigScreen.nextRow(currentPos);
        class_5250 hideMessageText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.hideMessage");
        this.hideMessageLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)hideMessageText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)hideMessageText));
        this.hideMessageToggle = class_4185.method_46430((class_2561)this.enabledButtonText(this.chatRule.getHideMessage()), a -> {
            this.chatRule.setHideMessage(!this.chatRule.getHideMessage());
            this.hideMessageToggle.method_25355(this.enabledButtonText(this.chatRule.getHideMessage()));
        }).method_46433(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt()).method_46437(75, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.hideMessage.@Tooltip"))).method_46431();
        ChatRuleConfigScreen.nextColumn(currentPos, 75);
        class_5250 actionBarText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.actionBar");
        this.actionBarLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)actionBarText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)actionBarText));
        this.actionBarToggle = class_4185.method_46430((class_2561)this.enabledButtonText(this.chatRule.getShowActionBar()), a -> {
            this.chatRule.setShowActionBar(!this.chatRule.getShowActionBar());
            this.actionBarToggle.method_25355(this.enabledButtonText(this.chatRule.getShowActionBar()));
        }).method_46433(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt()).method_46437(75, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.actionBar.@Tooltip"))).method_46431();
        ChatRuleConfigScreen.nextRow(currentPos);
        class_5250 announcementText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.announcement");
        this.announcementLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)announcementText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)announcementText));
        this.announcementToggle = class_4185.method_46430((class_2561)this.enabledButtonText(this.chatRule.getShowAnnouncement()), a -> {
            this.chatRule.setShowAnnouncement(!this.chatRule.getShowAnnouncement());
            this.announcementToggle.method_25355(this.enabledButtonText(this.chatRule.getShowAnnouncement()));
        }).method_46433(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt()).method_46437(75, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.announcement.@Tooltip"))).method_46431();
        ChatRuleConfigScreen.nextColumn(currentPos, 75);
        class_5250 soundsText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds");
        this.soundsLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)soundsText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)soundsText));
        this.soundsToggle = class_4185.method_46430((class_2561)this.getSoundName(), a -> {
            ++this.currentSoundIndex;
            if (this.currentSoundIndex == this.soundsLookup.size()) {
                this.currentSoundIndex = -1;
            }
            class_5250 newText = this.getSoundName();
            this.soundsToggle.method_25355((class_2561)newText);
            class_3414 sound = this.soundsLookup.get(newText);
            this.chatRule.setCustomSound(sound);
            if (this.field_22787.field_1724 != null && sound != null) {
                this.field_22787.field_1724.method_5783(sound, 100.0f, 0.1f);
            }
        }).method_46433(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt()).method_46437(75, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.@Tooltip"))).method_46431();
        ChatRuleConfigScreen.nextRow(currentPos);
        class_5250 replaceMessageText = class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.replace");
        this.replaceMessageLabel = ChatRuleConfigScreen.textWidget((IntIntPair)rootPos, (IntIntPair)currentPos, yOffset, (class_2561)replaceMessageText);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)replaceMessageText));
        this.replaceMessageInput = new class_342(this.field_22787.field_1772, rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt(), textFieldWidth, 20, class_2561.method_30163((String)""));
        this.replaceMessageInput.method_1880(96);
        this.replaceMessageInput.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.replace.@Tooltip")));
        this.replaceMessageInput.method_1852(this.chatRule.getReplaceMessage());
        this.finishButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.finish"), a -> this.method_25419()).method_46433(this.field_22789 - 75 - 5, this.field_22790 - 5).method_46437(75, 20).method_46431();
        this.calculateTextFieldWidths();
        this.calculateButtonWidths();
    }

    private int getCurrentSoundIndex() {
        if (this.chatRule.getCustomSound() == null) {
            return -1;
        }
        List<class_3414> soundOptions = this.soundsLookup.values().stream().toList();
        class_2960 ruleSoundId = this.chatRule.getCustomSound().comp_3319();
        for (int i = 0; i < soundOptions.size(); ++i) {
            if (soundOptions.get(i).comp_3319().method_12833(ruleSoundId) != 0) continue;
            return i;
        }
        return -1;
    }

    protected void method_25426() {
        this.recalculateWidgetPositions();
        this.method_37063((class_364)this.titleWidget);
        this.method_37063((class_364)this.nameInput);
        this.method_37063((class_364)this.nameLabel);
        this.method_37063((class_364)this.inputsLabel);
        this.method_37063((class_364)this.filterInput);
        this.method_37063((class_364)this.filterLabel);
        this.method_37063((class_364)this.partialMatchToggle);
        this.method_37063((class_364)this.partialMatchLabel);
        this.method_37063((class_364)this.regexToggle);
        this.method_37063((class_364)this.regexLabel);
        this.method_37063((class_364)this.ignoreCaseToggle);
        this.method_37063((class_364)this.ignoreCaseLabel);
        this.method_37063((class_364)this.locationsConfigButton);
        this.method_37063((class_364)this.locationLabel);
        this.method_37063((class_364)this.outputsLabel);
        this.method_37063((class_364)this.hideMessageToggle);
        this.method_37063((class_364)this.hideMessageLabel);
        this.method_37063((class_364)this.actionBarToggle);
        this.method_37063((class_364)this.actionBarLabel);
        this.method_37063((class_364)this.announcementToggle);
        this.method_37063((class_364)this.announcementLabel);
        this.method_37063((class_364)this.soundsToggle);
        this.method_37063((class_364)this.soundsLabel);
        this.method_37063((class_364)this.replaceMessageInput);
        this.method_37063((class_364)this.replaceMessageLabel);
        this.method_37063((class_364)this.finishButton);
        this.calculateTextFieldWidths();
        this.calculateButtonWidths();
    }

    private void recalculateWidgetPositions() {
        IntIntImmutablePair rootPos = this.getRootPos();
        IntIntMutablePair currentPos = IntIntMutablePair.of((int)0, (int)0);
        assert (this.field_22787 != null);
        this.titleWidget.method_25358(this.field_22789);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.nameLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.nameLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.nameInput, (IntIntPair)rootPos, (IntIntPair)currentPos);
        ChatRuleConfigScreen.nextRow(currentPos);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.inputsLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextRow(currentPos);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.filterLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.filterLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.filterInput, (IntIntPair)rootPos, (IntIntPair)currentPos);
        ChatRuleConfigScreen.nextRow(currentPos);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.partialMatchLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.partialMatchLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.partialMatchToggle, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.partialMatchToggle.method_25358(75);
        ChatRuleConfigScreen.nextColumn(currentPos, 75);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.regexLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.regexLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.regexToggle, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.regexToggle.method_25358(75);
        ChatRuleConfigScreen.nextRow(currentPos);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.ignoreCaseLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.ignoreCaseLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.ignoreCaseToggle, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.ignoreCaseToggle.method_25358(75);
        ChatRuleConfigScreen.nextColumn(currentPos, 75);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.locationLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.locationLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.locationsConfigButton, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.locationsConfigButton.method_25358(75);
        ChatRuleConfigScreen.nextRow(currentPos);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.outputsLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextRow(currentPos);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.hideMessageLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.hideMessageLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.hideMessageToggle, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.hideMessageToggle.method_25358(75);
        ChatRuleConfigScreen.nextColumn(currentPos, 75);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.actionBarLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.actionBarLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.actionBarToggle, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.actionBarToggle.method_25358(75);
        ChatRuleConfigScreen.nextRow(currentPos);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.announcementLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.announcementLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.announcementToggle, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.announcementToggle.method_25358(75);
        ChatRuleConfigScreen.nextColumn(currentPos, 75);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.soundsLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.soundsLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.soundsToggle, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.soundsToggle.method_25358(75);
        ChatRuleConfigScreen.nextRow(currentPos);
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.replaceMessageLabel, (IntIntPair)rootPos, (IntIntPair)currentPos, Y_OFFSET);
        ChatRuleConfigScreen.nextColumn(currentPos, this.field_22787.field_1772.method_27525((class_5348)this.replaceMessageLabel.method_25369()));
        ChatRuleConfigScreen.setWidgetPosition((class_8021)this.replaceMessageInput, (IntIntPair)rootPos, (IntIntPair)currentPos);
        this.finishButton.method_48229(this.field_22789 - 75 - 5, this.field_22790 - 5 - 20);
    }

    private static class_7842 textWidget(IntIntPair rootPos, IntIntPair offset, int yCenterOffset, class_2561 text) {
        return WidgetUtils.textWidget(rootPos.leftInt() + offset.leftInt(), rootPos.rightInt() + offset.rightInt() + yCenterOffset, text);
    }

    private static void setWidgetPosition(class_8021 widget, IntIntPair rootPos, IntIntPair currentPos) {
        widget.method_48229(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt());
    }

    private static void setWidgetPosition(class_8021 widget, IntIntPair rootPos, IntIntPair currentPos, int yOffset) {
        widget.method_48229(rootPos.leftInt() + currentPos.leftInt(), rootPos.rightInt() + currentPos.rightInt() + yOffset);
    }

    private static void nextColumn(IntIntMutablePair pos, int offset) {
        pos.left(pos.leftInt() + offset + 5);
    }

    private static void nextRow(IntIntMutablePair pos) {
        pos.right(pos.rightInt() + 5 + 20);
        pos.left(0);
    }

    private void calculateTextFieldWidths() {
        this.calculateTextFieldWidth(this.nameLabel, this.nameInput);
        this.calculateTextFieldWidth(this.filterLabel, this.filterInput);
        this.calculateTextFieldWidth(this.replaceMessageLabel, this.replaceMessageInput);
    }

    private IntIntImmutablePair getRootPos() {
        return IntIntImmutablePair.of((int)((this.field_22789 - this.getMaxWidth()) / 2 + 5), (int)((this.field_22790 - this.getMaxUsedHeight()) / 2));
    }

    private int getMaxWidth() {
        return Math.min(this.field_22789, 360);
    }

    private void calculateTextFieldWidth(class_7842 textWidget, class_342 textFieldWidget) {
        assert (this.field_22787 != null);
        int textWidth = this.field_22787.field_1772.method_27525((class_5348)textWidget.method_25369());
        textFieldWidget.method_25358(this.getMaxWidth() - textWidth - 15);
    }

    private void calculateButtonWidths() {
        this.calculateButtonWidth(this.partialMatchLabel, this.partialMatchToggle, this.regexLabel, this.regexToggle);
        this.calculateButtonWidth(this.ignoreCaseLabel, this.ignoreCaseToggle, this.locationLabel, this.locationsConfigButton);
        this.calculateButtonWidth(this.hideMessageLabel, this.hideMessageToggle, this.actionBarLabel, this.actionBarToggle);
        this.calculateButtonWidth(this.announcementLabel, this.announcementToggle, this.soundsLabel, this.soundsToggle);
    }

    private void calculateButtonWidth(class_7842 label1, class_4185 button1, class_7842 label2, class_4185 button2) {
        assert (this.field_22787 != null);
        int label1Width = this.field_22787.field_1772.method_27525((class_5348)label1.method_25369());
        int label2Width = this.field_22787.field_1772.method_27525((class_5348)label2.method_25369());
        int remainingWidth = this.getMaxWidth() - label1Width - label2Width - 25;
        int buttonWidth = remainingWidth / 2;
        button1.method_25358(buttonWidth);
        button2.method_25358(buttonWidth + remainingWidth % 2);
        int label2x = (this.field_22789 - this.getMaxWidth()) / 2 + 5 + label1Width + 5 + buttonWidth + 5;
        label2.method_46421(label2x);
        button2.method_46421(label2x + label2Width + 5);
    }

    private int getMaxUsedHeight() {
        return 220;
    }

    private class_2561 enabledButtonText(boolean enabled) {
        if (enabled) {
            return class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.true").method_54663(Color.GREEN.getRGB());
        }
        return class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.false").method_54663(Color.RED.getRGB());
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.save();
            this.field_22787.method_1507(this.parent);
        }
    }

    private void save() {
        this.chatRule.setName(this.nameInput.method_1882());
        this.chatRule.setFilter(this.filterInput.method_1882());
        this.chatRule.setReplaceMessage(this.replaceMessageInput.method_1882());
        ChatRulesHandler.chatRuleList.getData().set(this.chatRuleIndex, this.chatRule);
    }

    private class_5250 getSoundName() {
        if (this.currentSoundIndex == -1) {
            return class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.sounds.none");
        }
        return (class_5250)this.soundsLookup.keySet().stream().toList().get(this.currentSoundIndex);
    }

    static {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        Y_OFFSET = (20 - 9) / 2;
    }
}

