/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.DungeonScoreHUD;
import de.hysky.skyblocker.utils.render.HudHelper;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class DungeonMapConfigScreen
extends class_437 {
    private int mapX;
    private int mapY;
    private int scoreX;
    private int scoreY;
    private static final class_2960 MAP_BACKGROUND = class_2960.method_60656((String)"textures/map/map_background.png");
    private final class_437 parent;

    protected DungeonMapConfigScreen() {
        this(null);
    }

    public DungeonMapConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Dungeon Map Config"));
        this.mapX = SkyblockerConfigManager.get().dungeons.dungeonMap.mapX;
        this.mapY = SkyblockerConfigManager.get().dungeons.dungeonMap.mapY;
        this.scoreX = SkyblockerConfigManager.get().dungeons.dungeonScore.scoreX;
        this.scoreY = SkyblockerConfigManager.get().dungeons.dungeonScore.scoreY;
        this.parent = parent;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderHUDMap(context, this.mapX, this.mapY);
        this.renderHUDScore(context, this.scoreX, this.scoreY);
        context.method_25300(this.field_22793, "Right Click To Reset Position", this.field_22789 >> 1, this.field_22790 >> 1, Color.GRAY.getRGB());
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int mapSize = (int)(128.0f * SkyblockerConfigManager.get().dungeons.dungeonMap.mapScaling);
        float scoreScaling = SkyblockerConfigManager.get().dungeons.dungeonScore.scoreScaling;
        int scoreWidth = (int)((float)this.field_22793.method_27525((class_5348)DungeonScoreHUD.getFormattedScoreText()) * scoreScaling);
        Objects.requireNonNull(this.field_22793);
        int scoreHeight = (int)(9.0f * scoreScaling);
        if (HudHelper.pointIsInArea(mouseX, mouseY, this.mapX, this.mapY, this.mapX + mapSize, this.mapY + mapSize) && button == 0) {
            this.mapX = (int)Math.max(Math.min(mouseX - (double)(mapSize >> 1), (double)(this.field_22789 - mapSize)), 0.0);
            this.mapY = (int)Math.max(Math.min(mouseY - (double)(mapSize >> 1), (double)(this.field_22790 - mapSize)), 0.0);
        } else if (HudHelper.pointIsInArea(mouseX, mouseY, this.scoreX, this.scoreY, this.scoreX + scoreWidth, this.scoreY + scoreHeight) && button == 0) {
            this.scoreX = (int)Math.max(Math.min(mouseX - (double)(scoreWidth >> 1), (double)(this.field_22789 - scoreWidth)), 0.0);
            this.scoreY = (int)Math.max(Math.min(mouseY - (double)(scoreHeight >> 1), (double)(this.field_22790 - scoreHeight)), 0.0);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.mapX = 2;
            this.mapY = 2;
            this.scoreX = Math.max((int)((float)this.mapX + 64.0f * SkyblockerConfigManager.get().dungeons.dungeonMap.mapScaling - (float)this.field_22793.method_27525((class_5348)DungeonScoreHUD.getFormattedScoreText()) * SkyblockerConfigManager.get().dungeons.dungeonScore.scoreScaling / 2.0f), 0);
            this.scoreY = (int)((float)this.mapY + 128.0f * SkyblockerConfigManager.get().dungeons.dungeonMap.mapScaling + 4.0f);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        SkyblockerConfigManager.update(config -> {
            config.dungeons.dungeonMap.mapX = this.mapX;
            config.dungeons.dungeonMap.mapY = this.mapY;
            config.dungeons.dungeonScore.scoreX = this.scoreX;
            config.dungeons.dungeonScore.scoreY = this.scoreY;
        });
        this.field_22787.method_1507(this.parent);
    }

    public void renderHUDMap(class_332 context, int x, int y) {
        float scaling = SkyblockerConfigManager.get().dungeons.dungeonMap.mapScaling;
        int size = (int)(128.0f * scaling);
        context.method_25290(class_10799.field_56883, MAP_BACKGROUND, x, y, 0.0f, 0.0f, size, size, size, size);
    }

    public void renderHUDScore(class_332 context, int x, int y) {
        DungeonScoreHUD.render(context, x, y);
    }
}

