/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.ProfileUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.mayor.MayorUtils;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1642;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DungeonScore {
    private static final Supplier<DungeonsConfig.DungeonScore> SCORE_CONFIG = () -> SkyblockerConfigManager.get().dungeons.dungeonScore;
    private static final Supplier<DungeonsConfig.MimicMessage> MIMIC_MESSAGE_CONFIG = () -> SkyblockerConfigManager.get().dungeons.mimicMessage;
    private static final Supplier<DungeonsConfig.PrinceMessage> PRINCE_MESSAGE_CONFIG = () -> SkyblockerConfigManager.get().dungeons.princeMessage;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Dungeon Score");
    private static final Pattern CLEARED_PATTERN = Pattern.compile("Cleared: (?<cleared>\\d+)%.*");
    private static final Pattern FLOOR_PATTERN = Pattern.compile(".*?(?=T)The Catacombs \\((?<floor>[EFM]\\D*\\d*)\\)");
    private static final Pattern SECRETS_PATTERN = Pattern.compile("Secrets Found: (?<secper>\\d+\\.?\\d*)%");
    private static final Pattern PUZZLES_PATTERN = Pattern.compile(".+?(?=:): \\[(?<state>.)](?: \\(\\w*\\))?");
    private static final Pattern PUZZLE_COUNT_PATTERN = Pattern.compile("Puzzles: \\((?<count>\\d+)\\)");
    private static final Pattern CRYPTS_PATTERN = Pattern.compile("Crypts: (?<crypts>\\d+)");
    private static final Pattern COMPLETED_ROOMS_PATTERN = Pattern.compile(" *Completed Rooms: (?<rooms>\\d+)");
    private static final Pattern DEATHS_PATTERN = Pattern.compile(" \\u2620 (?<whodied>\\S+) .*");
    private static final Pattern MIMIC_PATTERN = Pattern.compile(".*?(?:Mimic dead!?|Mimic Killed!|\\$SKYTILS-DUNGEON-SCORE-MIMIC\\$)$");
    private static final String PRINCE_KILL_MESSAGE = "A Prince falls. +1 Bonus Score";
    private static final Pattern PRINCE_PATTERN = Pattern.compile(".*?(?:Prince dead!?|Prince Killed!)$");
    private static final Pattern MIMIC_FLOORS_PATTERN = Pattern.compile("[FM][67]");
    private static final String MIMIC_MESSAGE = "Mimic dead!";
    private static final String PRINCE_MESSAGE = "Prince dead!";
    private static FloorRequirement floorRequirement;
    private static String currentFloor;
    private static boolean isCurrentFloorEntrance;
    private static boolean floorHasMimics;
    private static boolean sentCrypts;
    private static boolean sent270;
    private static boolean sent300;
    private static boolean mimicKilled;
    private static boolean princeKilled;
    private static boolean dungeonStarted;
    private static boolean isMayorPaul;
    private static boolean firstDeathHasSpiritPet;
    private static boolean bloodRoomCompleted;
    private static long startingTime;
    private static int puzzleCount;
    private static int deathCount;
    private static int score;

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(DungeonScore::tick, 20);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> DungeonScore.reset());
        DungeonEvents.DUNGEON_STARTED.register(DungeonScore::onDungeonStart);
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            if (overlay || !Utils.isInDungeons()) {
                return true;
            }
            String str = message.getString();
            if (dungeonStarted) {
                DungeonScore.checkMessageForDeaths(str);
                DungeonScore.checkMessageForWatcher(str);
                if (floorHasMimics) {
                    DungeonScore.checkMessageForMimic(str);
                }
                DungeonScore.checkMessageForPrince(str);
            }
            return true;
        });
    }

    public static void tick() {
        class_310 client = class_310.method_1551();
        if (!Utils.isInDungeons() || client.field_1724 == null) {
            DungeonScore.reset();
            return;
        }
        if (!dungeonStarted) {
            return;
        }
        score = DungeonScore.calculateScore();
        if (!sent270 && !sent300 && score >= 270 && score < 300) {
            if (DungeonScore.SCORE_CONFIG.get().enableDungeonScore270Message) {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("/pc " + Constants.PREFIX.get().getString() + DungeonScore.SCORE_CONFIG.get().dungeonScore270Message.replaceAll("\\[score]", "270"), false);
            }
            if (DungeonScore.SCORE_CONFIG.get().enableDungeonScore270Title) {
                client.field_1705.method_1742();
                client.field_1705.method_34004(class_2561.method_30163((String)DungeonScore.SCORE_CONFIG.get().dungeonScore270Message.replaceAll("\\[score]", "270")));
            }
            if (DungeonScore.SCORE_CONFIG.get().enableDungeonScore270Sound) {
                client.field_1724.method_5783((class_3414)class_3417.field_14622.comp_349(), 100.0f, 0.1f);
            }
            sent270 = true;
        }
        int crypts = DungeonScore.getCrypts();
        if (!sentCrypts && score >= DungeonScore.SCORE_CONFIG.get().dungeonCryptsMessageThreshold && crypts < 5) {
            if (DungeonScore.SCORE_CONFIG.get().enableDungeonCryptsMessage) {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("/pc " + Constants.PREFIX.get().getString() + DungeonScore.SCORE_CONFIG.get().dungeonCryptsMessage.replaceAll("\\[crypts]", String.valueOf(crypts)), false);
            }
            sentCrypts = true;
        }
        if (!sent300 && score >= 300) {
            if (DungeonScore.SCORE_CONFIG.get().enableDungeonScore300Message) {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("/pc " + Constants.PREFIX.get().getString() + DungeonScore.SCORE_CONFIG.get().dungeonScore300Message.replaceAll("\\[score]", "300"), false);
            }
            if (DungeonScore.SCORE_CONFIG.get().enableDungeonScore300Title) {
                client.field_1705.method_1742();
                client.field_1705.method_34004(class_2561.method_30163((String)DungeonScore.SCORE_CONFIG.get().dungeonScore300Message.replaceAll("\\[score]", "300")));
            }
            if (DungeonScore.SCORE_CONFIG.get().enableDungeonScore300Sound) {
                client.field_1724.method_5783((class_3414)class_3417.field_14622.comp_349(), 100.0f, 0.1f);
            }
            sent300 = true;
        }
    }

    private static void reset() {
        floorRequirement = null;
        currentFloor = "";
        isCurrentFloorEntrance = false;
        floorHasMimics = false;
        sentCrypts = false;
        sent270 = false;
        sent300 = false;
        mimicKilled = false;
        princeKilled = false;
        dungeonStarted = false;
        isMayorPaul = false;
        firstDeathHasSpiritPet = false;
        bloodRoomCompleted = false;
        startingTime = 0L;
        puzzleCount = 0;
        deathCount = 0;
        score = 0;
    }

    private static void onDungeonStart() {
        DungeonScore.reset();
        DungeonScore.setCurrentFloor();
        dungeonStarted = true;
        puzzleCount = DungeonScore.getPuzzleCount();
        isMayorPaul = MayorUtils.getMayor().perks().stream().anyMatch(perk -> perk.name().equals("EZPZ")) || MayorUtils.getMinister().perk().name().equals("EZPZ");
        startingTime = System.currentTimeMillis();
        floorRequirement = FloorRequirement.valueOf(currentFloor);
        floorHasMimics = MIMIC_FLOORS_PATTERN.matcher(currentFloor).matches();
        if (currentFloor.equals("E")) {
            isCurrentFloorEntrance = true;
        }
    }

    private static int calculateScore() {
        if (isCurrentFloorEntrance) {
            return Math.round((float)DungeonScore.calculateTimeScore() * 0.7f) + Math.round((float)DungeonScore.calculateExploreScore() * 0.7f) + Math.round((float)DungeonScore.calculateSkillScore() * 0.7f) + Math.round((float)DungeonScore.calculateBonusScore() * 0.7f);
        }
        return DungeonScore.calculateTimeScore() + DungeonScore.calculateExploreScore() + DungeonScore.calculateSkillScore() + DungeonScore.calculateBonusScore();
    }

    private static int calculateSkillScore() {
        int totalRooms = DungeonScore.getTotalRooms();
        int completedRoomScore = Math.clamp((long)(totalRooms != 0 ? (int)(80.0 * (double)(DungeonScore.getCompletedRooms() + DungeonScore.getExtraCompletedRooms()) / (double)totalRooms) : 0), 0, 80);
        return 20 + Math.clamp((long)(completedRoomScore - DungeonScore.getPuzzlePenalty() - DungeonScore.getDeathScorePenalty()), 0, 80);
    }

    private static int calculateExploreScore() {
        int totalRooms = DungeonScore.getTotalRooms();
        int completedRoomScore = Math.clamp(totalRooms != 0 ? (long)((int)(60.0 * (double)(DungeonScore.getCompletedRooms() + DungeonScore.getExtraCompletedRooms()) / (double)totalRooms)) : 0L, 0, 60);
        int secretsScore = Math.clamp((long)((int)(40.0 * Math.min((double)DungeonScore.floorRequirement.percentage, DungeonScore.getSecretsPercentage()) / (double)DungeonScore.floorRequirement.percentage)), 0, 40);
        return completedRoomScore + secretsScore;
    }

    private static int calculateTimeScore() {
        int score = 100;
        int timeSpent = (int)(System.currentTimeMillis() - startingTime) / 1000;
        if (timeSpent < DungeonScore.floorRequirement.timeLimit) {
            return score;
        }
        double timePastRequirement = (double)(timeSpent - DungeonScore.floorRequirement.timeLimit) / (double)DungeonScore.floorRequirement.timeLimit * 100.0;
        if (timePastRequirement < 20.0) {
            return score - (int)timePastRequirement / 2;
        }
        if (timePastRequirement < 40.0) {
            return score - (int)(10.0 + (timePastRequirement - 20.0) / 4.0);
        }
        if (timePastRequirement < 50.0) {
            return score - (int)(15.0 + (timePastRequirement - 40.0) / 5.0);
        }
        if (timePastRequirement < 60.0) {
            return score - (int)(17.0 + (timePastRequirement - 50.0) / 6.0);
        }
        return Math.clamp((long)(score - (int)(18.666666666666668 + (timePastRequirement - 60.0) / 7.0)), 0, 100);
    }

    private static int calculateBonusScore() {
        int mimicScore;
        int paulScore = isMayorPaul ? 10 : 0;
        int cryptsScore = Math.clamp((long)DungeonScore.getCrypts(), 0, 5);
        int n = mimicScore = mimicKilled ? 2 : 0;
        if (DungeonScore.getSecretsPercentage() >= 100.0 && floorHasMimics) {
            mimicScore = 2;
        }
        int princeScore = princeKilled ? 1 : 0;
        return paulScore + cryptsScore + mimicScore + princeScore;
    }

    public static boolean isEntityMimic(class_1297 entity) {
        class_1642 zombie;
        if (!(Utils.isInDungeons() && floorHasMimics && entity instanceof class_1642 && (zombie = (class_1642)entity).method_6109())) {
            return false;
        }
        try {
            List<class_1799> armor = ItemUtils.getArmor((class_1309)zombie);
            return armor.stream().allMatch(class_1799::method_7960);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to check if entity is a mimic!", (Throwable)e);
            return false;
        }
    }

    public static void handleEntityDeath(class_1297 entity) {
        if (mimicKilled) {
            return;
        }
        if (!DungeonScore.isEntityMimic(entity)) {
            return;
        }
        if (DungeonScore.MIMIC_MESSAGE_CONFIG.get().sendMimicMessage) {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("/pc Mimic dead!", false);
        }
        mimicKilled = true;
    }

    public static void onMimicKill() {
        mimicKilled = true;
    }

    private static void onPrinceKill(boolean fromHypixel) {
        if (princeKilled) {
            return;
        }
        if (DungeonScore.PRINCE_MESSAGE_CONFIG.get().sendPrinceMessage && fromHypixel) {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("/pc Prince dead!", false);
        }
        princeKilled = true;
    }

    public static boolean wasPrinceKilled() {
        return princeKilled;
    }

    private static int getTotalRooms() {
        return (int)Math.round((double)DungeonScore.getCompletedRooms() / DungeonScore.getClearPercentage());
    }

    private static int getCompletedRooms() {
        Matcher matcher = PlayerListManager.regexAt(43, COMPLETED_ROOMS_PATTERN);
        return matcher != null ? Integer.parseInt(matcher.group("rooms")) : 0;
    }

    private static int getExtraCompletedRooms() {
        if (!bloodRoomCompleted) {
            return isCurrentFloorEntrance ? 1 : 2;
        }
        if (!DungeonManager.isInBoss() && !isCurrentFloorEntrance) {
            return 1;
        }
        return 0;
    }

    private static double getClearPercentage() {
        for (String sidebarLine : Utils.STRING_SCOREBOARD) {
            Matcher clearMatcher = CLEARED_PATTERN.matcher(sidebarLine);
            if (!clearMatcher.matches()) continue;
            return Double.parseDouble(clearMatcher.group("cleared")) / 100.0;
        }
        LOGGER.error("[Skyblocker] Clear pattern doesn't match!");
        return 0.0;
    }

    private static int getDeathScorePenalty() {
        return deathCount * 2 - (firstDeathHasSpiritPet ? 1 : 0);
    }

    private static int getPuzzleCount() {
        Matcher matcher = PlayerListManager.regexAt(47, PUZZLE_COUNT_PATTERN);
        return matcher != null ? Integer.parseInt(matcher.group("count")) : 0;
    }

    private static int getPuzzlePenalty() {
        Matcher puzzleMatcher;
        int incompletePuzzles = 0;
        for (int index = 0; index < puzzleCount && (puzzleMatcher = PlayerListManager.regexAt(48 + index, PUZZLES_PATTERN)) != null; ++index) {
            if (!puzzleMatcher.group("state").matches("[\u2716\u2726]")) continue;
            ++incompletePuzzles;
        }
        return incompletePuzzles * 10;
    }

    private static double getSecretsPercentage() {
        Matcher matcher = PlayerListManager.regexAt(44, SECRETS_PATTERN);
        return matcher != null ? Double.parseDouble(matcher.group("secper")) : 0.0;
    }

    private static int getCrypts() {
        Matcher matcher = PlayerListManager.regexAt(33, CRYPTS_PATTERN);
        if (matcher == null) {
            matcher = PlayerListManager.regexAt(32, CRYPTS_PATTERN);
        }
        return matcher != null ? Integer.parseInt(matcher.group("crypts")) : 0;
    }

    private static boolean hasSpiritPet(JsonObject player, String name) {
        if (player == null) {
            LOGGER.error("[Skyblocker] Spirit pet lookup by name failed! (likely due to an earlier error!) Name: {}", (Object)name);
            return false;
        }
        try {
            for (JsonElement pet : player.getAsJsonObject("pets_data").getAsJsonArray("pets")) {
                if (!pet.getAsJsonObject().get("type").getAsString().equals("SPIRIT") || !pet.getAsJsonObject().get("tier").getAsString().equals("LEGENDARY")) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Spirit pet lookup by name failed! Name: {}", (Object)name, (Object)e);
        }
        return false;
    }

    private static void checkMessageForDeaths(String message) {
        if (!message.startsWith("\u2620", 1)) {
            return;
        }
        Matcher matcher = DEATHS_PATTERN.matcher(message);
        if (!matcher.matches()) {
            return;
        }
        if (++deathCount > 1) {
            return;
        }
        String whoDied = matcher.group("whodied").transform(s -> {
            if (s.equals("You")) {
                return class_310.method_1551().method_1548().method_1676();
            }
            return s;
        });
        ProfileUtils.fetchProfileMember(whoDied).thenAccept(player -> {
            firstDeathHasSpiritPet = DungeonScore.hasSpiritPet(player, whoDied);
        });
    }

    private static void checkMessageForWatcher(String message) {
        if (message.equals("[BOSS] The Watcher: You have proven yourself. You may pass.")) {
            bloodRoomCompleted = true;
        }
    }

    private static void checkMessageForMimic(String message) {
        if (!MIMIC_PATTERN.matcher(message).matches()) {
            return;
        }
        DungeonScore.onMimicKill();
    }

    private static void checkMessageForPrince(String message) {
        if (!PRINCE_PATTERN.matcher(message).matches() && !message.equals(PRINCE_KILL_MESSAGE)) {
            return;
        }
        DungeonScore.onPrinceKill(message.equals(PRINCE_KILL_MESSAGE));
    }

    public static void setCurrentFloor() {
        for (String sidebarLine : Utils.STRING_SCOREBOARD) {
            Matcher floorMatcher = FLOOR_PATTERN.matcher(sidebarLine);
            if (!floorMatcher.matches()) continue;
            currentFloor = floorMatcher.group("floor");
            return;
        }
        LOGGER.error("[Skyblocker] Floor pattern doesn't match!");
    }

    public static int getScore() {
        return score;
    }

    public static boolean isDungeonStarted() {
        return dungeonStarted;
    }

    public static boolean isMimicOnCurrentFloor() {
        return floorHasMimics;
    }

    static enum FloorRequirement {
        E(30, 1200),
        F1(30, 600),
        F2(40, 600),
        F3(50, 600),
        F4(60, 720),
        F5(70, 600),
        F6(85, 720),
        F7(100, 840),
        M1(100, 480),
        M2(100, 480),
        M3(100, 480),
        M4(100, 480),
        M5(100, 480),
        M6(100, 600),
        M7(100, 840);

        private final int percentage;
        private final int timeLimit;

        private FloorRequirement(int percentage, int timeLimit) {
            this.percentage = percentage;
            this.timeLimit = timeLimit;
        }
    }
}

