/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_8824;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldorWaypointsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoldorWaypointsManager.class);
    private static final ObjectArrayList<GoldorWaypoint> TERMINALS = new ObjectArrayList();
    private static final ObjectArrayList<GoldorWaypoint> DEVICES = new ObjectArrayList();
    private static final ObjectArrayList<GoldorWaypoint> LEVERS = new ObjectArrayList();
    private static final String TERMINALS_START = "[BOSS] Storm: I should have known that I stood no chance.";
    private static final Pattern TERMINAL_ACTIVATED = Pattern.compile("^(?<name>\\w+) activated a terminal! \\(\\d/\\d\\)$");
    private static final Pattern DEVICE_ACTIVATED = Pattern.compile("^(?<name>\\w+) completed a device! \\(\\d/\\d\\)$");
    private static final Pattern LEVER_ACTIVATED = Pattern.compile("^(?<name>\\w+) activated a lever! \\(\\d/\\d\\)$");
    private static final Pattern PHASE_COMPLETE = Pattern.compile("^(?<name>\\w+) (?:activated a (?:terminal|lever)|completed a device)! (?:\\(7/7\\)|\\(8/8\\))$");
    private static final String CORE_ENTRANCE = "The Core entrance is opening!";
    private static final Codec<List<GoldorWaypoint>> CODEC = GoldorWaypoint.CODEC.listOf();
    private static boolean loaded = false;
    private static boolean active = false;
    private static short currentPhase = 0;

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(GoldorWaypointsManager::extractRendering);
        ClientLifecycleEvents.CLIENT_STARTED.register(GoldorWaypointsManager::load);
        ClientReceiveMessageEvents.ALLOW_GAME.register(GoldorWaypointsManager::onChatMessage);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> GoldorWaypointsManager.reset());
    }

    private static void load(class_310 client) {
        CompletableFuture<Void> terminals = GoldorWaypointsManager.loadWaypoints(client, SkyblockerMod.id("dungeons/goldorwaypoints.json"));
        terminals.whenComplete((_result, _throwable) -> {
            loaded = true;
        });
    }

    private static CompletableFuture<Void> loadWaypoints(class_310 client, class_2960 file) {
        return CompletableFuture.supplyAsync(() -> {
            List list;
            block8: {
                BufferedReader reader = client.method_1478().openAsReader(file);
                try {
                    JsonArray arr = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                    list = (List)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)arr).getOrThrow();
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error("[Skyblocker Goldor Waypoints] Failed to load waypoints from: {}", (Object)file, (Object)e);
                        return List.of();
                    }
                }
                reader.close();
            }
            return list;
        }).thenAccept(list -> list.forEach(waypoint -> {
            switch (waypoint.kind.ordinal()) {
                case 0: {
                    TERMINALS.add(waypoint);
                    break;
                }
                case 1: {
                    DEVICES.add(waypoint);
                    break;
                }
                case 2: {
                    LEVERS.add(waypoint);
                }
            }
        }));
    }

    private static boolean shouldProcessMsgs() {
        return loaded && SkyblockerConfigManager.get().dungeons.goldor.enableGoldorWaypoints && Utils.isInDungeons() && DungeonManager.isInBoss() && DungeonManager.getBoss().isFloor(7);
    }

    private static void removeNearestWaypoint(List<GoldorWaypoint> waypoints, String playerName) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        Optional<class_243> posOptional = client.field_1687.method_18456().stream().filter(player -> player.method_7334().getName().equals(playerName)).findAny().map(class_1297::method_19538);
        posOptional.flatMap(pos -> waypoints.stream().filter(Waypoint::shouldRender).min(Comparator.comparingDouble(waypoint -> waypoint.centerPos.method_1025(pos)))).ifPresent(Waypoint::setFound);
    }

    private static void reset() {
        active = false;
        currentPhase = 0;
        GoldorWaypointsManager.enableAll(TERMINALS);
        GoldorWaypointsManager.enableAll(DEVICES);
        GoldorWaypointsManager.enableAll(LEVERS);
    }

    private static void enableAll(ObjectArrayList<GoldorWaypoint> waypoints) {
        waypoints.forEach(Waypoint::setMissing);
    }

    @Nullable
    private static String getPlayerName(Matcher matcher) {
        return matcher.matches() ? matcher.group("name") : null;
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        if (overlay || !GoldorWaypointsManager.shouldProcessMsgs()) {
            return true;
        }
        String message = text.getString();
        if (active) {
            if (PHASE_COMPLETE.matcher(message).matches()) {
                currentPhase = (short)(currentPhase + 1);
            } else {
                String playerName = GoldorWaypointsManager.getPlayerName(TERMINAL_ACTIVATED.matcher(message));
                if (playerName != null) {
                    GoldorWaypointsManager.removeNearestWaypoint(TERMINALS, playerName);
                } else {
                    playerName = GoldorWaypointsManager.getPlayerName(DEVICE_ACTIVATED.matcher(message));
                    if (playerName != null) {
                        GoldorWaypointsManager.removeNearestWaypoint(DEVICES, playerName);
                    } else {
                        playerName = GoldorWaypointsManager.getPlayerName(LEVER_ACTIVATED.matcher(message));
                        if (playerName != null) {
                            GoldorWaypointsManager.removeNearestWaypoint(LEVERS, playerName);
                        } else if (message.equals(CORE_ENTRANCE)) {
                            active = false;
                        }
                    }
                }
            }
        } else if (message.equals(TERMINALS_START)) {
            GoldorWaypointsManager.enableAll(TERMINALS);
            GoldorWaypointsManager.enableAll(DEVICES);
            GoldorWaypointsManager.enableAll(LEVERS);
            active = true;
        }
        return true;
    }

    private static void extractRenderingForWaypoints(PrimitiveCollector collector, ObjectArrayList<GoldorWaypoint> waypoints) {
        for (GoldorWaypoint waypoint : waypoints) {
            if (waypoint.phase != currentPhase || !waypoint.shouldRender()) continue;
            waypoint.extractRendering(collector);
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (active) {
            GoldorWaypointsManager.extractRenderingForWaypoints(collector, TERMINALS);
            GoldorWaypointsManager.extractRenderingForWaypoints(collector, DEVICES);
            GoldorWaypointsManager.extractRenderingForWaypoints(collector, LEVERS);
        }
    }

    private static class GoldorWaypoint
    extends NamedWaypoint {
        public static final Codec<GoldorWaypoint> CODEC = RecordCodecBuilder.create(i -> i.group((App)WaypointTargetKind.CODEC.fieldOf("kind").forGetter(w -> w.kind), (App)Codec.INT.fieldOf("phase").forGetter(customWaypoint -> customWaypoint.phase), (App)class_8824.field_46597.fieldOf("name").forGetter(NamedWaypoint::getName), (App)class_2338.field_25064.fieldOf("pos").forGetter(customWaypoint -> customWaypoint.pos)).apply((Applicative)i, GoldorWaypoint::new));
        private static final Supplier<Waypoint.Type> TYPE_SUPPLIER = () -> SkyblockerConfigManager.get().dungeons.goldor.waypointType;
        final WaypointTargetKind kind;
        final int phase;

        GoldorWaypoint(WaypointTargetKind kind, int phase, class_2561 name, class_2338 pos) {
            super(pos, name, TYPE_SUPPLIER, kind.colorComponents, 0.25f, true);
            this.kind = kind;
            this.phase = phase;
        }

        static enum WaypointTargetKind implements class_3542
        {
            TERMINAL(0, 255, 0),
            DEVICE(0, 0, 255),
            LEVER(255, 255, 0);

            private static final Codec<WaypointTargetKind> CODEC;
            private final float[] colorComponents;

            private WaypointTargetKind(int r, int g, int b) {
                this.colorComponents = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
            }

            public String method_15434() {
                return this.name().toLowerCase(Locale.ENGLISH);
            }

            static {
                CODEC = class_3542.method_53955(WaypointTargetKind::values);
            }
        }
    }
}

