/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class LividColor {
    private static final Map<class_2248, class_124> WOOL_TO_FORMATTING = Map.of(class_2246.field_10314, class_124.field_1061, class_2246.field_10490, class_124.field_1054, class_2246.field_10028, class_124.field_1060, class_2246.field_10170, class_124.field_1077, class_2246.field_10514, class_124.field_1078, class_2246.field_10215, class_124.field_1076, class_2246.field_10259, class_124.field_1064, class_2246.field_10423, class_124.field_1080, class_2246.field_10446, class_124.field_1068);
    private static final Map<String, class_124> LIVID_TO_FORMATTING = Map.of("Hockey Livid", class_124.field_1061, "Arcade Livid", class_124.field_1054, "Smile Livid", class_124.field_1060, "Frog Livid", class_124.field_1077, "Scream Livid", class_124.field_1078, "Crossed Livid", class_124.field_1076, "Purple Livid", class_124.field_1064, "Doctor Livid", class_124.field_1080, "Vendetta Livid", class_124.field_1068);
    private static final Supplier<DungeonsConfig.Livid> CONFIG = () -> SkyblockerConfigManager.get().dungeons.livid;
    private static class_124 color = class_124.field_1075;
    private static class_2248 lastColor = class_2246.field_10124;
    private static boolean isInitialized = false;
    private static boolean correctLividIdFound = false;
    private static int correctLividId = 0;
    private static final long OFFSET_DURATION = 2000L;
    private static long toggleTime = 0L;

    @Init
    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> LividColor.reset());
        WorldRenderExtractionCallback.EVENT.register(LividColor::update);
    }

    private static void update(PrimitiveCollector collector) {
        DungeonsConfig.Livid config = SkyblockerConfigManager.get().dungeons.livid;
        if (!(config.enableLividColorText || config.enableLividColorTitle || config.enableLividColorGlow || config.enableLividColorBoundingBox)) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (!Utils.isInDungeons() || !DungeonManager.isInBoss() || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_2248 currentColor = client.field_1687.method_8320(new class_2338(5, 110, 42)).method_26204();
        if (!WOOL_TO_FORMATTING.containsKey(currentColor) || currentColor.equals(lastColor)) {
            return;
        }
        if (!isInitialized && client.field_1724.method_6059(class_1294.field_5919)) {
            toggleTime = System.currentTimeMillis();
            isInitialized = true;
        } else if (isInitialized && System.currentTimeMillis() - toggleTime >= 2000L) {
            LividColor.onLividColorFound(client, currentColor);
            if (!correctLividIdFound) {
                String lividName = LIVID_TO_FORMATTING.entrySet().stream().filter(entry -> entry.getValue() == color).map(Map.Entry::getKey).findFirst().orElse("unknown");
                client.field_1687.method_18456().stream().filter(entity -> entity.method_5477().getString().equals(lividName)).findFirst().ifPresent(entity -> {
                    correctLividId = entity.method_5628();
                });
                correctLividIdFound = true;
            }
            lastColor = currentColor;
        }
    }

    private static void onLividColorFound(class_310 client, class_2248 color) {
        LividColor.color = WOOL_TO_FORMATTING.get(color);
        String colorString = class_7923.field_41175.method_10221((Object)color).method_12832();
        colorString = colorString.substring(0, colorString.length() - 5).toUpperCase(Locale.ENGLISH);
        class_5250 message = class_2561.method_43470((String)LividColor.CONFIG.get().lividColorText.replaceAll("\\[color]", colorString)).method_27692(LividColor.color);
        if (LividColor.CONFIG.get().enableLividColorText) {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("/pc " + Constants.PREFIX.get().method_10852((class_2561)message).getString(), false);
        }
        if (LividColor.CONFIG.get().enableLividColorTitle) {
            client.field_1705.method_1742();
            client.field_1705.method_34004((class_2561)message);
        }
    }

    public static boolean allowGlow() {
        return !SkyblockerConfigManager.get().dungeons.livid.enableLividColorGlow || !DungeonManager.getBoss().isFloor(5);
    }

    public static boolean shouldGlow(String name) {
        return SkyblockerConfigManager.get().dungeons.livid.enableLividColorGlow && color == LIVID_TO_FORMATTING.get(name);
    }

    public static boolean shouldDrawBoundingBox(String name) {
        return SkyblockerConfigManager.get().dungeons.livid.enableLividColorBoundingBox && color == LIVID_TO_FORMATTING.get(name);
    }

    public static int getGlowColor(String name) {
        if (SkyblockerConfigManager.get().dungeons.livid.enableSolidColor) {
            return SkyblockerConfigManager.get().dungeons.livid.customColor.getRGB();
        }
        if (LIVID_TO_FORMATTING.containsKey(name)) {
            return LIVID_TO_FORMATTING.get(name).method_532();
        }
        return class_124.field_1068.method_532();
    }

    public static int getCorrectLividId() {
        return correctLividId;
    }

    private static void reset() {
        lastColor = class_2246.field_10124;
        toggleTime = 0L;
        isInitialized = false;
        correctLividIdFound = false;
        correctLividId = 0;
        color = class_124.field_1075;
    }
}

