/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.chat.ChatFilterResult;
import de.hysky.skyblocker.utils.chat.ChatPatternListener;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import net.azureaaron.hmapi.data.party.PartyRole;
import net.azureaaron.hmapi.events.HypixelPacketEvents;
import net.azureaaron.hmapi.network.HypixelNetworking;
import net.azureaaron.hmapi.network.packet.s2c.ErrorS2CPacket;
import net.azureaaron.hmapi.network.packet.s2c.HypixelS2CPacket;
import net.azureaaron.hmapi.network.packet.v2.s2c.PartyInfoS2CPacket;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.slf4j.Logger;

public class Reparty
extends ChatPatternListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int BASE_DELAY = 10;
    private boolean repartying = false;
    private String partyLeader;

    public Reparty() {
        super("^(?:([\\[A-z+\\]]* )?(?<disband>.*) has disbanded .*|.*\n([\\[A-z+\\]]* )?(?<invite>.*) has invited you to join their party!\nYou have 60 seconds to accept. Click here to join!\n.*)$");
        HypixelPacketEvents.PARTY_INFO.register(this::onPacket);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reparty").executes(this::executeCommand));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rp").executes(this::executeCommand));
        });
    }

    private int executeCommand(CommandContext<FabricClientCommandSource> source) {
        if (!Utils.isOnSkyblock() || this.repartying || Reparty.CLIENT.field_1724 == null) {
            return 0;
        }
        this.repartying = true;
        HypixelNetworking.sendPartyInfoC2SPacket((int)2);
        return 1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onPacket(HypixelS2CPacket packet) {
        HypixelS2CPacket hypixelS2CPacket = packet;
        Objects.requireNonNull(hypixelS2CPacket);
        HypixelS2CPacket hypixelS2CPacket2 = hypixelS2CPacket;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PartyInfoS2CPacket.class, ErrorS2CPacket.class}, (Object)hypixelS2CPacket2, n)) {
                case 0: {
                    Object members;
                    Object object;
                    boolean inParty;
                    PartyInfoS2CPacket partyInfoS2CPacket = (PartyInfoS2CPacket)hypixelS2CPacket2;
                    try {
                        boolean bl;
                        inParty = bl = partyInfoS2CPacket.inParty();
                        members = object = partyInfoS2CPacket.members();
                        if (!this.repartying) {
                            n = 1;
                            continue block7;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    UUID ourUuid = Objects.requireNonNull(CLIENT.method_1548().method_44717());
                    if (inParty && members.get(ourUuid) == PartyRole.LEADER) {
                        this.sendCommand("/p disband", 1);
                        int count = 0;
                        Iterator iterator = members.entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                Scheduler.INSTANCE.schedule(() -> {
                                    this.repartying = false;
                                }, count * 10);
                                return;
                            }
                            Map.Entry entry = iterator.next();
                            UUID uuid = (UUID)entry.getKey();
                            PartyRole role = (PartyRole)entry.getValue();
                            if (role == PartyRole.LEADER) continue;
                            this.sendCommand("/p " + uuid.toString(), ++count + 2);
                        }
                    }
                    Reparty.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.reparty.notInPartyOrNotLeader")), false);
                    this.repartying = false;
                    return;
                }
                case 1: {
                    class_8710.class_9154 error;
                    class_8710.class_9154 id;
                    Object object = (ErrorS2CPacket)hypixelS2CPacket2;
                    {
                        class_8710.class_9154 class_91542;
                        id = class_91542 = object.id();
                        error = class_91542 = object.reason();
                    }
                    if (id.equals((Object)PartyInfoS2CPacket.ID) && this.repartying) {
                        Reparty.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.reparty.error")), false);
                        LOGGER.error("[Skyblocker Reparty] The party info packet returned an unexpected error! {}", (Object)error);
                        this.repartying = false;
                        return;
                    }
                    n = 2;
                    continue block7;
                }
            }
            break;
        }
    }

    @Override
    public ChatFilterResult state() {
        return SkyblockerConfigManager.get().general.acceptReparty ? ChatFilterResult.FILTER : ChatFilterResult.PASS;
    }

    @Override
    public boolean onMatch(class_2561 message, Matcher matcher) {
        if (matcher.group("disband") != null && !matcher.group("disband").equals(CLIENT.method_1548().method_1676())) {
            this.partyLeader = matcher.group("disband");
            Scheduler.INSTANCE.schedule(() -> {
                this.partyLeader = null;
            }, 61);
        } else if (matcher.group("invite") != null && matcher.group("invite").equals(this.partyLeader)) {
            String command = "/party accept " + this.partyLeader;
            this.sendCommand(command, 0);
        }
        return false;
    }

    private void sendCommand(String command, int delay) {
        MessageScheduler.INSTANCE.queueMessage(command, true, delay * 10);
    }
}

