/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.container.ContainerAndInventorySolver;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.networth.NetworthCalculator;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.regex.Pattern;
import net.azureaaron.networth.NetworthResult;
import net.minecraft.class_1799;

public class SalvageHelper
extends SimpleContainerSolver
implements ContainerAndInventorySolver {
    private static final Pattern DUNGEON_SALVAGABLE = Pattern.compile("DUNGEON(?! ITEM)");

    public SalvageHelper() {
        super("^Salvage Items");
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        return slots.int2ObjectEntrySet().stream().filter(entry -> ItemUtils.getLoreLineIfContainsMatch((class_1799)entry.getValue(), DUNGEON_SALVAGABLE) != null).filter(entry -> this.isPriceWithinRange((class_1799)entry.getValue())).map(entry -> ColorHighlight.yellow(entry.getIntKey())).toList();
    }

    private boolean isPriceWithinRange(class_1799 stack) {
        NetworthResult result = NetworthCalculator.getItemNetworth(stack);
        return result.price() > 0.0 && result.price() < 100000.0;
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().dungeons.salvageHelper;
    }
}

