/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3620;
import net.minecraft.class_9428;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class DungeonMapUtils {
    public static final byte BLACK_COLOR = class_3620.field_16009.method_38481(class_3620.class_6594.field_34762);
    public static final byte WHITE_COLOR = class_3620.field_16022.method_38481(class_3620.class_6594.field_34761);
    public static final byte GREEN_COLOR = 30;

    public static byte getColor(class_22 map, @Nullable Vector2ic pos) {
        return pos == null ? (byte)-1 : DungeonMapUtils.getColor(map, pos.x(), pos.y());
    }

    public static byte getColor(class_22 map, int x, int z) {
        if (x < 0 || z < 0 || x >= 128 || z >= 128) {
            return -1;
        }
        return map.field_122[x + (z << 7)];
    }

    public static boolean isEntranceColor(class_22 map, int x, int z) {
        return DungeonMapUtils.getColor(map, x, z) == Room.Type.ENTRANCE.color;
    }

    public static boolean isEntranceColor(class_22 map, @Nullable Vector2ic pos) {
        return DungeonMapUtils.getColor(map, pos) == Room.Type.ENTRANCE.color;
    }

    @Nullable
    private static Vector2i getMapPlayerPos(class_22 map) {
        for (class_20 decoration : map.method_32373()) {
            if (!((class_9428)decoration.comp_1842().comp_349()).equals(class_21.field_95.comp_349())) continue;
            return new Vector2i((decoration.comp_1843() >> 1) + 64, (decoration.comp_1844() >> 1) + 64);
        }
        return null;
    }

    @Nullable
    public static ObjectIntPair<Vector2ic> getMapEntrancePosAndRoomSize(@NotNull class_22 map) {
        Vector2i mapPos = DungeonMapUtils.getMapPlayerPos(map);
        if (mapPos == null) {
            return null;
        }
        ArrayDeque<Vector2i> posToCheck = new ArrayDeque<Vector2i>();
        HashSet<Vector2i> checked = new HashSet<Vector2i>();
        posToCheck.add(mapPos);
        checked.add(mapPos);
        while ((mapPos = (Vector2ic)posToCheck.poll()) != null) {
            ObjectIntPair<Vector2ic> mapEntranceAndRoomSizePos;
            if (DungeonMapUtils.isEntranceColor(map, (Vector2ic)mapPos) && (mapEntranceAndRoomSizePos = DungeonMapUtils.getMapEntrancePosAndRoomSizeAt(map, (Vector2ic)mapPos)).rightInt() > 0) {
                return mapEntranceAndRoomSizePos;
            }
            Vector2i pos = new Vector2i((Vector2ic)mapPos).sub(10, 0);
            if (checked.add(pos)) {
                posToCheck.add(pos);
            }
            if (checked.add(pos = new Vector2i((Vector2ic)mapPos).sub(0, 10))) {
                posToCheck.add(pos);
            }
            if (checked.add(pos = new Vector2i((Vector2ic)mapPos).add(10, 0))) {
                posToCheck.add(pos);
            }
            if (!checked.add(pos = new Vector2i((Vector2ic)mapPos).add(0, 10))) continue;
            posToCheck.add(pos);
        }
        return null;
    }

    private static ObjectIntPair<Vector2ic> getMapEntrancePosAndRoomSizeAt(class_22 map, Vector2ic mapPosImmutable) {
        Vector2i mapPos = new Vector2i(mapPosImmutable);
        while (DungeonMapUtils.isEntranceColor(map, (Vector2ic)mapPos.sub(1, 0))) {
        }
        mapPos.add(1, 0);
        while (DungeonMapUtils.isEntranceColor(map, (Vector2ic)mapPos.sub(0, 1))) {
        }
        return ObjectIntPair.of((Object)mapPos.add(0, 1), (int)DungeonMapUtils.getMapRoomSize(map, (Vector2ic)mapPos));
    }

    public static int getMapRoomSize(class_22 map, Vector2ic mapEntrancePos) {
        int i = -1;
        while (DungeonMapUtils.isEntranceColor(map, mapEntrancePos.x() + ++i, mapEntrancePos.y())) {
        }
        return i > 5 ? i : 0;
    }

    @Nullable
    public static Vector2ic getMapRoomPos(class_22 map, Vector2ic mapEntrancePos, int mapRoomSize) {
        int mapRoomSizeWithGap = mapRoomSize + 4;
        Vector2i mapPos = DungeonMapUtils.getMapPlayerPos(map);
        if (mapPos == null) {
            return null;
        }
        Vector2i offset = new Vector2i(mapEntrancePos.x() % mapRoomSizeWithGap, mapEntrancePos.y() % mapRoomSizeWithGap);
        return mapPos.add(2, 2).sub((Vector2ic)offset).sub(Math.floorMod(mapPos.x(), mapRoomSizeWithGap), Math.floorMod(mapPos.y(), mapRoomSizeWithGap)).add((Vector2ic)offset);
    }

    public static Vector2ic getMapPosFromPhysical(Vector2ic physicalEntrancePos, Vector2ic mapEntrancePos, int mapRoomSize, Vector2ic physicalPos) {
        return new Vector2i(physicalPos).sub(physicalEntrancePos).div(32).mul(mapRoomSize + 4).add(mapEntrancePos);
    }

    public static Vector2dc getMapPosFromPhysical(Vector2ic physicalEntrancePos, Vector2ic mapEntrancePos, int mapRoomSize, class_2374 physicalPos) {
        return new Vector2d(physicalPos.method_10216(), physicalPos.method_10215()).sub((double)physicalEntrancePos.x(), (double)physicalEntrancePos.y()).div(32.0).mul((double)(mapRoomSize + 4)).add((double)mapEntrancePos.x(), (double)mapEntrancePos.y());
    }

    public static Vector2i getMapPosForNWMostRoom(Vector2ic mapEntrancePos, int mapRoomSize) {
        return new Vector2i(Math.floorMod(mapEntrancePos.x(), mapRoomSize + 4), Math.floorMod(mapEntrancePos.y(), mapRoomSize + 4));
    }

    @NotNull
    public static Vector2ic getPhysicalRoomPos(@NotNull class_243 pos) {
        return DungeonMapUtils.getPhysicalRoomPos(pos.method_10216(), pos.method_10215());
    }

    @NotNull
    public static Vector2ic getPhysicalRoomPos(@NotNull class_2382 pos) {
        return DungeonMapUtils.getPhysicalRoomPos(pos.method_10263(), pos.method_10260());
    }

    @NotNull
    public static Vector2ic getPhysicalRoomPos(double x, double z) {
        Vector2i physicalPos = new Vector2i(x + 8.5, z + 8.5, 0);
        return physicalPos.sub(Math.floorMod(physicalPos.x(), 32), Math.floorMod(physicalPos.y(), 32)).sub(8, 8);
    }

    public static Vector2ic[] getPhysicalPosFromMap(Vector2ic mapEntrancePos, int mapRoomSize, Vector2ic physicalEntrancePos, Vector2ic ... mapPositions) {
        for (int i = 0; i < mapPositions.length; ++i) {
            mapPositions[i] = DungeonMapUtils.getPhysicalPosFromMap(mapEntrancePos, mapRoomSize, physicalEntrancePos, mapPositions[i]);
        }
        return mapPositions;
    }

    public static Vector2ic getPhysicalPosFromMap(Vector2ic mapEntrancePos, int mapRoomSize, Vector2ic physicalEntrancePos, Vector2ic mapPos) {
        return new Vector2i(mapPos).sub(mapEntrancePos).div(mapRoomSize + 4).mul(32).add(physicalEntrancePos);
    }

    public static Vector2ic getPhysicalCornerPos(Room.Direction direction, IntSortedSet segmentsX, IntSortedSet segmentsY) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Room.Direction.NW -> new Vector2i(segmentsX.firstInt(), segmentsY.firstInt());
            case Room.Direction.NE -> new Vector2i(segmentsX.lastInt() + 30, segmentsY.firstInt());
            case Room.Direction.SW -> new Vector2i(segmentsX.firstInt(), segmentsY.lastInt() + 30);
            case Room.Direction.SE -> new Vector2i(segmentsX.lastInt() + 30, segmentsY.lastInt() + 30);
        };
    }

    public static class_2338 actualToRelative(Room.Direction direction, Vector2ic physicalCornerPos, class_2338 pos) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Room.Direction.NW -> new class_2338(pos.method_10263() - physicalCornerPos.x(), pos.method_10264(), pos.method_10260() - physicalCornerPos.y());
            case Room.Direction.NE -> new class_2338(pos.method_10260() - physicalCornerPos.y(), pos.method_10264(), -pos.method_10263() + physicalCornerPos.x());
            case Room.Direction.SW -> new class_2338(-pos.method_10260() + physicalCornerPos.y(), pos.method_10264(), pos.method_10263() - physicalCornerPos.x());
            case Room.Direction.SE -> new class_2338(-pos.method_10263() + physicalCornerPos.x(), pos.method_10264(), -pos.method_10260() + physicalCornerPos.y());
        };
    }

    public static class_243 actualToRelative(Room.Direction direction, Vector2ic physicalCornerPos, class_243 pos) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Room.Direction.NW -> new class_243(pos.method_10216() - (double)physicalCornerPos.x(), pos.method_10214(), pos.method_10215() - (double)physicalCornerPos.y());
            case Room.Direction.NE -> new class_243(pos.method_10215() - (double)physicalCornerPos.y(), pos.method_10214(), -pos.method_10216() + (double)physicalCornerPos.x());
            case Room.Direction.SW -> new class_243(-pos.method_10215() + (double)physicalCornerPos.y(), pos.method_10214(), pos.method_10216() - (double)physicalCornerPos.x());
            case Room.Direction.SE -> new class_243(-pos.method_10216() + (double)physicalCornerPos.x(), pos.method_10214(), -pos.method_10215() + (double)physicalCornerPos.y());
        };
    }

    public static class_2338 relativeToActual(Room.Direction direction, Vector2ic physicalCornerPos, JsonObject posJson) {
        return DungeonMapUtils.relativeToActual(direction, physicalCornerPos, new class_2338(posJson.get("x").getAsInt(), posJson.get("y").getAsInt(), posJson.get("z").getAsInt()));
    }

    public static class_2338 relativeToActual(Room.Direction direction, Vector2ic physicalCornerPos, class_2338 pos) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Room.Direction.NW -> new class_2338(pos.method_10263() + physicalCornerPos.x(), pos.method_10264(), pos.method_10260() + physicalCornerPos.y());
            case Room.Direction.NE -> new class_2338(-pos.method_10260() + physicalCornerPos.x(), pos.method_10264(), pos.method_10263() + physicalCornerPos.y());
            case Room.Direction.SW -> new class_2338(pos.method_10260() + physicalCornerPos.x(), pos.method_10264(), -pos.method_10263() + physicalCornerPos.y());
            case Room.Direction.SE -> new class_2338(-pos.method_10263() + physicalCornerPos.x(), pos.method_10264(), -pos.method_10260() + physicalCornerPos.y());
        };
    }

    public static class_243 relativeToActual(Room.Direction direction, Vector2ic physicalCornerPos, class_243 pos) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Room.Direction.NW -> new class_243(pos.method_10216() + (double)physicalCornerPos.x(), pos.method_10214(), pos.method_10215() + (double)physicalCornerPos.y());
            case Room.Direction.NE -> new class_243(-pos.method_10215() + (double)physicalCornerPos.x(), pos.method_10214(), pos.method_10216() + (double)physicalCornerPos.y());
            case Room.Direction.SW -> new class_243(pos.method_10215() + (double)physicalCornerPos.x(), pos.method_10214(), -pos.method_10216() + (double)physicalCornerPos.y());
            case Room.Direction.SE -> new class_243(-pos.method_10216() + (double)physicalCornerPos.x(), pos.method_10214(), -pos.method_10215() + (double)physicalCornerPos.y());
        };
    }

    public static Room.Type getRoomType(class_22 map, Vector2ic mapPos) {
        return switch (DungeonMapUtils.getColor(map, mapPos)) {
            case 30 -> Room.Type.ENTRANCE;
            case 63 -> Room.Type.ROOM;
            case 66 -> Room.Type.PUZZLE;
            case 62 -> Room.Type.TRAP;
            case 74 -> Room.Type.MINIBOSS;
            case 82 -> Room.Type.FAIRY;
            case 18 -> Room.Type.BLOOD;
            case 85 -> Room.Type.UNKNOWN;
            default -> null;
        };
    }

    public static Vector2ic[] getRoomSegments(class_22 map, Vector2ic mapPos, int mapRoomSize, byte color) {
        HashSet<Object> segments = new HashSet<Object>();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        segments.add(mapPos);
        queue.add(mapPos);
        while (!queue.isEmpty()) {
            Vector2i newMapPos = new Vector2i();
            Vector2ic curMapPos = (Vector2ic)queue.poll();
            if (DungeonMapUtils.getColor(map, (Vector2ic)newMapPos.set(curMapPos).sub(1, 0)) == color && !segments.contains(newMapPos.sub(mapRoomSize + 3, 0))) {
                segments.add(newMapPos);
                queue.add(newMapPos);
                newMapPos = new Vector2i();
            }
            if (DungeonMapUtils.getColor(map, (Vector2ic)newMapPos.set(curMapPos).sub(0, 1)) == color && !segments.contains(newMapPos.sub(0, mapRoomSize + 3))) {
                segments.add(newMapPos);
                queue.add(newMapPos);
                newMapPos = new Vector2i();
            }
            if (DungeonMapUtils.getColor(map, (Vector2ic)newMapPos.set(curMapPos).add(mapRoomSize, 0)) == color && !segments.contains(newMapPos.add(4, 0))) {
                segments.add(newMapPos);
                queue.add(newMapPos);
                newMapPos = new Vector2i();
            }
            if (DungeonMapUtils.getColor(map, (Vector2ic)newMapPos.set(curMapPos).add(0, mapRoomSize)) != color || segments.contains(newMapPos.add(0, 4))) continue;
            segments.add(newMapPos);
            queue.add(newMapPos);
        }
        DungeonManager.LOGGER.debug("[Skyblocker] Found dungeon room segments: {}", (Object)Arrays.toString(segments.toArray()));
        return (Vector2ic[])segments.toArray(Vector2ic[]::new);
    }
}

