/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonMapUtils;
import de.hysky.skyblocker.skyblock.dungeon.secrets.SecretWaypoint;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Tickable;
import de.hysky.skyblocker.utils.render.Renderable;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1421;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7485;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class Room
implements Tickable,
Renderable {
    private static final Pattern SECRET_INDEX = Pattern.compile("^(\\d+)");
    private static final Pattern SECRETS = Pattern.compile("\u00a77(\\d{1,2})/(\\d{1,2}) Secrets");
    private static final String LOCKED_CHEST = "That chest is locked!";
    protected static final float[] RED_COLOR_COMPONENTS = new float[]{1.0f, 0.0f, 0.0f};
    protected static final float[] GREEN_COLOR_COMPONENTS = new float[]{0.0f, 1.0f, 0.0f};
    @NotNull
    private final Type type;
    @NotNull
    final Set<Vector2ic> segments;
    protected boolean greenChecked = false;
    @NotNull
    private final Shape shape;
    protected Map<String, int[]> roomsData;
    protected List<MutableTriple<Direction, Vector2ic, List<String>>> possibleRooms;
    private Set<class_2338> checkedBlocks = new HashSet<class_2338>();
    protected CompletableFuture<Void> findRoom;
    private int doubleCheckBlocks;
    protected MatchState matchState = MatchState.MATCHING;
    private Table<Integer, class_2338, SecretWaypoint> secretWaypoints;
    private String name;
    private Direction direction;
    private Vector2ic physicalCornerPos;
    protected List<Tickable> tickables = new ArrayList<Tickable>();
    protected List<Renderable> renderables = new ArrayList<Renderable>();
    private class_2338 lastChestSecret;
    private long lastChestSecretTime;

    public Room(@NotNull Type type, Vector2ic ... physicalPositions) {
        this.type = type;
        this.segments = Set.of(physicalPositions);
        IntSortedSet segmentsX = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(this.segments.stream().mapToInt(Vector2ic::x).toArray()));
        IntSortedSet segmentsY = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(this.segments.stream().mapToInt(Vector2ic::y).toArray()));
        this.shape = this.getShape(segmentsX, segmentsY);
        this.roomsData = DungeonManager.ROOMS_DATA.getOrDefault("catacombs", Collections.emptyMap()).getOrDefault(this.shape.shape.toLowerCase(Locale.ENGLISH), Collections.emptyMap());
        this.possibleRooms = this.getPossibleRooms(segmentsX, segmentsY);
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public boolean isMatched() {
        return this.matchState == MatchState.DOUBLE_CHECKING || this.matchState == MatchState.MATCHED;
    }

    public String getName() {
        return this.name;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String toString() {
        return "Room{type=%s, segments=%s, shape=%s, matchState=%s, name=%s, direction=%s, physicalCornerPos=%s}".formatted(new Object[]{this.type, Arrays.toString(this.segments.toArray()), this.shape, this.matchState, this.name, this.direction, this.physicalCornerPos});
    }

    @NotNull
    private Shape getShape(IntSortedSet segmentsX, IntSortedSet segmentsY) {
        return switch (this.type.ordinal()) {
            case 2 -> Shape.PUZZLE;
            case 3 -> Shape.TRAP;
            default -> {
                switch (this.segments.size()) {
                    case 1: {
                        yield Shape.ONE_BY_ONE;
                    }
                    case 2: {
                        yield Shape.ONE_BY_TWO;
                    }
                    case 3: {
                        if (segmentsX.size() == 2 && segmentsY.size() == 2) {
                            yield Shape.L_SHAPE;
                        }
                        yield Shape.ONE_BY_THREE;
                    }
                    case 4: {
                        if (segmentsX.size() == 2 && segmentsY.size() == 2) {
                            yield Shape.TWO_BY_TWO;
                        }
                        yield Shape.ONE_BY_FOUR;
                    }
                }
                throw new IllegalArgumentException("There are no matching room shapes with this set of physical positions: " + Arrays.toString(this.segments.toArray()));
            }
        };
    }

    private List<MutableTriple<Direction, Vector2ic, List<String>>> getPossibleRooms(IntSortedSet segmentsX, IntSortedSet segmentsY) {
        ArrayList<String> possibleDirectionRooms = new ArrayList<String>(this.roomsData.keySet());
        ArrayList<MutableTriple<Direction, Vector2ic, List<String>>> possibleRooms = new ArrayList<MutableTriple<Direction, Vector2ic, List<String>>>();
        for (Direction direction : this.getPossibleDirections(segmentsX, segmentsY)) {
            possibleRooms.add((MutableTriple<Direction, Vector2ic, List<String>>)MutableTriple.of((Object)((Object)direction), (Object)DungeonMapUtils.getPhysicalCornerPos(direction, segmentsX, segmentsY), possibleDirectionRooms));
        }
        return possibleRooms;
    }

    @NotNull
    private Direction[] getPossibleDirections(IntSortedSet segmentsX, IntSortedSet segmentsY) {
        Direction[] directionArray;
        switch (this.shape.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                directionArray = Direction.values();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (segmentsX.size() > 1 && segmentsY.size() == 1) {
                    Direction[] directionArray2 = new Direction[2];
                    directionArray2[0] = Direction.NW;
                    directionArray = directionArray2;
                    directionArray2[1] = Direction.SE;
                    break;
                }
                if (segmentsX.size() == 1 && segmentsY.size() > 1) {
                    Direction[] directionArray3 = new Direction[2];
                    directionArray3[0] = Direction.NE;
                    directionArray = directionArray3;
                    directionArray3[1] = Direction.SW;
                    break;
                }
                throw new IllegalArgumentException("Shape " + this.shape.shape + " does not match segments: " + Arrays.toString(this.segments.toArray()));
            }
            case 4: {
                if (!this.segments.contains(new Vector2i(segmentsX.firstInt(), segmentsY.firstInt()))) {
                    Direction[] directionArray4 = new Direction[1];
                    directionArray = directionArray4;
                    directionArray4[0] = Direction.SW;
                    break;
                }
                if (!this.segments.contains(new Vector2i(segmentsX.firstInt(), segmentsY.lastInt()))) {
                    Direction[] directionArray5 = new Direction[1];
                    directionArray = directionArray5;
                    directionArray5[0] = Direction.SE;
                    break;
                }
                if (!this.segments.contains(new Vector2i(segmentsX.lastInt(), segmentsY.firstInt()))) {
                    Direction[] directionArray6 = new Direction[1];
                    directionArray = directionArray6;
                    directionArray6[0] = Direction.NW;
                    break;
                }
                if (!this.segments.contains(new Vector2i(segmentsX.lastInt(), segmentsY.lastInt()))) {
                    Direction[] directionArray7 = new Direction[1];
                    directionArray = directionArray7;
                    directionArray7[0] = Direction.NE;
                    break;
                }
                throw new IllegalArgumentException("Shape " + this.shape.shape + " does not match segments: " + Arrays.toString(this.segments.toArray()));
            }
        }
        return directionArray;
    }

    protected void addCustomWaypoint(CommandContext<FabricClientCommandSource> context, class_2338 pos) {
        int secretIndex = IntegerArgumentType.getInteger(context, (String)"secretIndex");
        SecretWaypoint.Category category = SecretWaypoint.Category.CategoryArgumentType.getCategory(context, "category");
        class_2561 waypointName = (class_2561)context.getArgument("name", class_2561.class);
        this.addCustomWaypoint(secretIndex, category, waypointName, pos);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_54159((String)"skyblocker.dungeons.secrets.customWaypointAdded", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), this.name, secretIndex, category, waypointName})));
    }

    private void addCustomWaypoint(int secretIndex, SecretWaypoint.Category category, class_2561 waypointName, class_2338 pos) {
        SecretWaypoint waypoint = new SecretWaypoint(secretIndex, category, waypointName, pos);
        DungeonManager.addCustomWaypoint(this.name, waypoint);
        DungeonManager.getRoomsStream().filter(r -> this.name.equals(r.getName())).forEach(r -> r.addCustomWaypoint(waypoint));
    }

    private void addCustomWaypoint(SecretWaypoint relativeWaypoint) {
        SecretWaypoint actualWaypoint = relativeWaypoint.relativeToActual(this);
        this.secretWaypoints.put((Object)actualWaypoint.secretIndex, (Object)actualWaypoint.pos, (Object)actualWaypoint);
    }

    protected void removeCustomWaypoint(CommandContext<FabricClientCommandSource> context, class_2338 pos) {
        SecretWaypoint waypoint = this.removeCustomWaypoint(pos);
        if (waypoint != null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.dungeons.secrets.customWaypointRemoved", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), this.name, waypoint.secretIndex, waypoint.category.method_15434(), waypoint.getName()})));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.dungeons.secrets.customWaypointNotFound", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), this.name})));
        }
    }

    @Nullable
    private SecretWaypoint removeCustomWaypoint(class_2338 pos) {
        SecretWaypoint waypoint = DungeonManager.removeCustomWaypoint(this.name, pos);
        if (waypoint != null) {
            DungeonManager.getRoomsStream().filter(r -> this.name.equals(r.getName())).forEach(r -> r.removeCustomWaypoint(waypoint.secretIndex, pos));
        }
        return waypoint;
    }

    private void removeCustomWaypoint(int secretIndex, class_2338 relativePos) {
        class_2338 actualPos = this.relativeToActual(relativePos);
        this.secretWaypoints.remove((Object)secretIndex, (Object)actualPos);
    }

    public <T extends Tickable & Renderable> void addSubProcess(T process) {
        this.tickables.add(process);
        this.renderables.add(process);
    }

    @Override
    public void tick(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        for (Tickable tickable : this.tickables) {
            tickable.tick(client);
        }
        if (!this.type.needsScanning() || this.matchState != MatchState.MATCHING && this.matchState != MatchState.DOUBLE_CHECKING || !DungeonManager.isRoomsLoaded() || this.findRoom != null && !this.findRoom.isDone()) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        this.findRoom = CompletableFuture.runAsync(() -> {
            class_2338 pos;
            Iterator iterator = class_2338.method_10097((class_2338)player.method_24515().method_10069(-5, -5, -5), (class_2338)player.method_24515().method_10069(5, 5, 5)).iterator();
            while (!(!iterator.hasNext() || this.segments.contains(DungeonMapUtils.getPhysicalRoomPos((class_2382)(pos = (class_2338)iterator.next()))) && Room.notInDoorway(pos) && this.checkedBlocks.add(pos) && this.checkBlock(client.field_1687, pos))) {
            }
        }).exceptionally(e -> {
            DungeonManager.LOGGER.error("[Skyblocker Dungeon Secrets] Encountered an unknown exception while matching room {}", (Object)this, e);
            return null;
        });
    }

    private static boolean notInDoorway(class_2338 pos) {
        if (pos.method_10264() < 66 || pos.method_10264() > 73) {
            return true;
        }
        int x = Math.floorMod(pos.method_10263() - 8, 32);
        int z = Math.floorMod(pos.method_10260() - 8, 32);
        return (x < 13 || x > 17 || z > 2 && z < 28) && (z < 13 || z > 17 || x > 2 && x < 28);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkBlock(class_638 world, class_2338 pos) {
        byte id = DungeonManager.NUMERIC_ID.getByte((Object)class_7923.field_41175.method_10221((Object)world.method_8320(pos).method_26204()).toString());
        if (id == 0) {
            return false;
        }
        for (Object directionRooms2 : this.possibleRooms) {
            int block = this.posIdToInt(DungeonMapUtils.actualToRelative((Direction)((Object)directionRooms2.getLeft()), (Vector2ic)directionRooms2.getMiddle(), pos), id);
            ArrayList<String> possibleDirectionRooms = new ArrayList<String>();
            for (String room : (List)directionRooms2.getRight()) {
                if (Arrays.binarySearch(this.roomsData.get(room), block) < 0) continue;
                possibleDirectionRooms.add(room);
            }
            directionRooms2.setRight(possibleDirectionRooms);
        }
        int matchingRoomsSize = this.possibleRooms.stream().map(Triple::getRight).mapToInt(Collection::size).sum();
        if (matchingRoomsSize == 0) {
            Object directionRooms2;
            directionRooms2 = this;
            synchronized (directionRooms2) {
                this.matchState = MatchState.FAILED;
                DungeonManager.LOGGER.warn("[Skyblocker Dungeon Secrets] No dungeon room matched after checking {} block(s) including double checking {} block(s)", (Object)this.checkedBlocks.size(), (Object)this.doubleCheckBlocks);
                Scheduler.INSTANCE.schedule(() -> {
                    this.matchState = MatchState.MATCHING;
                }, 50);
                this.reset();
                return true;
            }
        }
        if (matchingRoomsSize == 1) {
            if (this.matchState == MatchState.MATCHING) {
                Triple directionRoom = (Triple)this.possibleRooms.stream().filter(directionRooms -> ((List)directionRooms.getRight()).size() == 1).findAny().orElseThrow();
                this.name = (String)((List)directionRoom.getRight()).getFirst();
                this.direction = (Direction)((Object)directionRoom.getLeft());
                this.physicalCornerPos = (Vector2ic)directionRoom.getMiddle();
                DungeonManager.LOGGER.info("[Skyblocker Dungeon Secrets] Room {} matched after checking {} block(s), starting double checking", (Object)this.name, (Object)this.checkedBlocks.size());
                this.roomMatched();
                return false;
            }
            if (this.matchState == MatchState.DOUBLE_CHECKING && ++this.doubleCheckBlocks >= 10) {
                this.matchState = MatchState.MATCHED;
                ((DungeonEvents.RoomMatched)DungeonEvents.ROOM_MATCHED.invoker()).onRoomMatched(this);
                DungeonManager.LOGGER.info("[Skyblocker Dungeon Secrets] Room {} confirmed after checking {} block(s) including double checking {} block(s)", new Object[]{this.name, this.checkedBlocks.size(), this.doubleCheckBlocks});
                this.discard();
                return true;
            }
            return false;
        }
        DungeonManager.LOGGER.debug("[Skyblocker Dungeon Secrets] {} room(s) remaining after checking {} block(s)", (Object)matchingRoomsSize, (Object)this.checkedBlocks.size());
        return false;
    }

    protected int posIdToInt(class_2338 pos, byte id) {
        return pos.method_10263() << 24 | pos.method_10264() << 16 | pos.method_10260() << 8 | id;
    }

    private void roomMatched() {
        this.secretWaypoints = HashBasedTable.create();
        JsonArray secretWaypointsJson = DungeonManager.getRoomWaypoints(this.name);
        if (secretWaypointsJson != null) {
            for (JsonElement waypointElement : secretWaypointsJson) {
                JsonObject waypoint = waypointElement.getAsJsonObject();
                String secretName = waypoint.get("secretName").getAsString();
                Matcher secretIndexMatcher = SECRET_INDEX.matcher(secretName);
                int secretIndex = secretIndexMatcher.find() ? Integer.parseInt(secretIndexMatcher.group(1)) : 0;
                class_2338 pos = DungeonMapUtils.relativeToActual(this.direction, this.physicalCornerPos, waypoint);
                this.secretWaypoints.put((Object)secretIndex, (Object)pos, (Object)new SecretWaypoint(secretIndex, waypoint, secretName, pos));
            }
        }
        DungeonManager.getCustomWaypoints(this.name).values().forEach(this::addCustomWaypoint);
        this.matchState = MatchState.DOUBLE_CHECKING;
    }

    protected void reset() {
        IntSortedSet segmentsX = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(this.segments.stream().mapToInt(Vector2ic::x).toArray()));
        IntSortedSet segmentsY = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(this.segments.stream().mapToInt(Vector2ic::y).toArray()));
        this.possibleRooms = this.getPossibleRooms(segmentsX, segmentsY);
        this.checkedBlocks = new HashSet<class_2338>();
        this.doubleCheckBlocks = 0;
        this.secretWaypoints = null;
        this.name = null;
        this.direction = null;
        this.physicalCornerPos = null;
    }

    private void discard() {
        this.roomsData = null;
        this.possibleRooms = null;
        this.checkedBlocks = null;
        this.doubleCheckBlocks = 0;
    }

    public class_2338 actualToRelative(class_2338 pos) {
        return DungeonMapUtils.actualToRelative(this.direction, this.physicalCornerPos, pos);
    }

    public class_243 actualToRelative(class_243 pos) {
        return DungeonMapUtils.actualToRelative(this.direction, this.physicalCornerPos, pos);
    }

    public class_2338 relativeToActual(class_2338 pos) {
        return DungeonMapUtils.relativeToActual(this.direction, this.physicalCornerPos, pos);
    }

    public class_243 relativeToActual(class_243 pos) {
        return DungeonMapUtils.relativeToActual(this.direction, this.physicalCornerPos, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractRendering(PrimitiveCollector collector) {
        for (Renderable renderable : this.renderables) {
            renderable.extractRendering(collector);
        }
        Room room = this;
        synchronized (room) {
            if (SkyblockerConfigManager.get().dungeons.secretWaypoints.enableSecretWaypoints && this.isMatched()) {
                for (SecretWaypoint secretWaypoint : this.secretWaypoints.values()) {
                    if (!secretWaypoint.shouldRender()) continue;
                    secretWaypoint.extractRendering(collector);
                }
            }
        }
    }

    protected void onChatMessage(String message) {
        if (LOCKED_CHEST.equals(message) && this.lastChestSecretTime + 1000L > System.currentTimeMillis() && this.lastChestSecret != null) {
            this.secretWaypoints.column((Object)this.lastChestSecret).values().stream().filter(SecretWaypoint::needsInteraction).findAny().ifPresent(secretWaypoint -> this.markSecretsAndLogInfo((SecretWaypoint)secretWaypoint, false, "[Skyblocker Dungeon Secrets] Detected locked chest interaction, setting secret #{} as missing", secretWaypoint.secretIndex));
        }
    }

    protected static boolean isAllSecretsFound(String message) {
        Matcher matcher = SECRETS.matcher(message);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1)) >= Integer.parseInt(matcher.group(2));
        }
        return false;
    }

    protected void onUseBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if ((state.method_27852(class_2246.field_10034) || state.method_27852(class_2246.field_10380)) && this.lastChestSecretTime + 1000L < System.currentTimeMillis() || state.method_27852(class_2246.field_10432) || state.method_27852(class_2246.field_10208)) {
            this.secretWaypoints.column((Object)pos).values().stream().filter(SecretWaypoint::needsInteraction).filter(Waypoint::isEnabled).findAny().ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected {} interaction, setting secret #{} as found", new Object[]{secretWaypoint.category, secretWaypoint.secretIndex}));
            if (state.method_27852(class_2246.field_10034) || state.method_27852(class_2246.field_10380)) {
                this.lastChestSecret = pos;
                this.lastChestSecretTime = System.currentTimeMillis();
            }
        } else if (state.method_27852(class_2246.field_10363)) {
            this.secretWaypoints.column((Object)pos).values().stream().filter(SecretWaypoint::isLever).forEach(Waypoint::setFound);
        }
    }

    protected void onItemPickup(class_1542 itemEntity) {
        if (SecretWaypoint.SECRET_ITEMS.stream().noneMatch(itemEntity.method_6983().method_7964().getString()::contains)) {
            return;
        }
        this.secretWaypoints.values().stream().filter(SecretWaypoint::needsItemPickup).min(Comparator.comparingDouble(SecretWaypoint.getSquaredDistanceToFunction((class_1297)itemEntity))).filter(SecretWaypoint.getRangePredicate((class_1297)itemEntity)).ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected item {} removed from a {} secret, setting secret #{} as found", new Object[]{itemEntity.method_5477().getString(), secretWaypoint.category, secretWaypoint.secretIndex}));
    }

    protected void onBatRemoved(class_1421 bat) {
        this.secretWaypoints.values().stream().filter(SecretWaypoint::isBat).min(Comparator.comparingDouble(SecretWaypoint.getSquaredDistanceToFunction((class_1297)bat))).filter(SecretWaypoint.getRangePredicate((class_1297)bat)).ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected {} killed for a {} secret, setting secret #{} as found", new Object[]{bat.method_5477().getString(), secretWaypoint.category, secretWaypoint.secretIndex}));
    }

    private void markSecretsFoundAndLogInfo(SecretWaypoint secretWaypoint, String msg, Object ... args) {
        this.markSecretsAndLogInfo(secretWaypoint, true, msg, args);
    }

    private void markSecretsAndLogInfo(SecretWaypoint secretWaypoint, boolean found, String msg, Object ... args) {
        this.markSecrets(secretWaypoint.secretIndex, found);
        DungeonManager.LOGGER.info(msg, args);
    }

    protected boolean markSecrets(int secretIndex, boolean found) {
        Map secret = this.secretWaypoints.row((Object)secretIndex);
        if (secret.isEmpty()) {
            return false;
        }
        secret.values().forEach(found ? Waypoint::setFound : Waypoint::setMissing);
        return true;
    }

    protected void markAllSecrets(boolean found) {
        if (this.secretWaypoints == null) {
            return;
        }
        this.secretWaypoints.values().forEach(found ? Waypoint::setFound : Waypoint::setMissing);
    }

    protected int getSecretCount() {
        return this.secretWaypoints.rowMap().size();
    }

    protected static enum MatchState {
        MATCHING,
        DOUBLE_CHECKING,
        MATCHED,
        FAILED;

    }

    public static enum Type {
        ENTRANCE(class_3620.field_16004.method_38481(class_3620.class_6594.field_34761)),
        ROOM(class_3620.field_15987.method_38481(class_3620.class_6594.field_34762)),
        PUZZLE(class_3620.field_15998.method_38481(class_3620.class_6594.field_34761)),
        TRAP(class_3620.field_15987.method_38481(class_3620.class_6594.field_34761)),
        MINIBOSS(class_3620.field_16010.method_38481(class_3620.class_6594.field_34761)),
        FAIRY(class_3620.field_16030.method_38481(class_3620.class_6594.field_34761)),
        BLOOD(class_3620.field_16002.method_38481(class_3620.class_6594.field_34761)),
        UNKNOWN(class_3620.field_15978.method_38481(class_3620.class_6594.field_34760));

        final byte color;

        private Type(byte color) {
            this.color = color;
        }

        private boolean needsScanning() {
            return switch (this.ordinal()) {
                case 1, 2, 3 -> true;
                default -> false;
            };
        }
    }

    protected static enum Shape {
        ONE_BY_ONE("1x1"),
        ONE_BY_TWO("1x2"),
        ONE_BY_THREE("1x3"),
        ONE_BY_FOUR("1x4"),
        L_SHAPE("L-shape"),
        TWO_BY_TWO("2x2"),
        PUZZLE("puzzle"),
        TRAP("trap");

        final String shape;

        private Shape(String shape) {
            this.shape = shape;
        }

        public String toString() {
            return this.shape;
        }
    }

    public static enum Direction implements class_3542
    {
        NW("northwest"),
        NE("northeast"),
        SW("southwest"),
        SE("southeast");

        private static final Codec<Direction> CODEC;
        private final String name;

        private Direction(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Direction::values);
        }

        static class DirectionArgumentType
        extends class_7485<Direction> {
            DirectionArgumentType() {
                super(CODEC, Direction::values);
            }

            static DirectionArgumentType direction() {
                return new DirectionArgumentType();
            }

            static <S> Direction getDirection(CommandContext<S> context, String name) {
                return (Direction)((Object)context.getArgument(name, Direction.class));
            }
        }
    }
}

