/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonPlayerManager;
import de.hysky.skyblocker.utils.ApiUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretsTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretsTracker.class);
    private static final Pattern TEAM_SCORE_PATTERN = Pattern.compile(" +Team Score: [0-9]+ \\([A-z+]+\\)");
    private static volatile TrackedRun currentRun = null;
    private static volatile TrackedRun lastRun = null;
    private static volatile long lastRunEnded = 0L;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(SecretsTracker::onMessage);
        DungeonEvents.DUNGEON_STARTED.register(() -> SecretsTracker.calculate(RunPhase.START));
    }

    private static void calculate(RunPhase phase) {
        switch (phase.ordinal()) {
            case 0: {
                CompletableFuture.runAsync(() -> {
                    TrackedRun newlyStartedRun = new TrackedRun();
                    for (int i = 0; i < 5; ++i) {
                        String playerName = SecretsTracker.getPlayerNameAt(i + 1);
                        if (playerName.isEmpty()) continue;
                        if (lastRun != null && System.currentTimeMillis() <= lastRunEnded + 300000L && lastRun.playersSecretData().getOrDefault((Object)playerName, (Object)SecretData.EMPTY) != SecretData.EMPTY) {
                            newlyStartedRun.playersSecretData().put((Object)playerName, (Object)((SecretData)lastRun.playersSecretData().get((Object)playerName)));
                            continue;
                        }
                        newlyStartedRun.playersSecretData().put((Object)playerName, (Object)SecretsTracker.getPlayerSecrets(playerName));
                    }
                    currentRun = newlyStartedRun;
                });
                break;
            }
            case 1: {
                CompletableFuture.runAsync(() -> {
                    if (currentRun != null) {
                        Object2ObjectOpenHashMap secretsFound = new Object2ObjectOpenHashMap();
                        for (Map.Entry entry : currentRun.playersSecretData().entrySet()) {
                            String playerName = (String)entry.getKey();
                            SecretData startingSecrets = (SecretData)entry.getValue();
                            SecretData secretsNow = SecretsTracker.getPlayerSecrets(playerName);
                            int secretsPlayerFound = secretsNow.secrets() - startingSecrets.secrets();
                            secretsFound.put((Object)playerName, (Object)secretsNow.updated(secretsPlayerFound, startingSecrets.cached() || secretsNow.cached()));
                            entry.setValue(secretsNow);
                        }
                        for (Map.Entry entry : secretsFound.entrySet()) {
                            SecretsTracker.sendResultMessage((String)entry.getKey(), (SecretData)entry.getValue(), true);
                        }
                        lastRunEnded = System.currentTimeMillis();
                        lastRun = currentRun;
                        currentRun = null;
                    } else {
                        SecretsTracker.sendResultMessage(null, null, false);
                    }
                });
            }
        }
    }

    private static void sendResultMessage(String player, SecretData secretData, boolean success) {
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity != null) {
            if (success) {
                playerEntity.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.dungeons.secretsTracker.feedback", (Object[])new Object[]{class_2561.method_43470((String)player).method_27693(" (" + DungeonPlayerManager.getClassFromPlayer(player).displayName() + ")").method_54663(16086338), "\u00a77" + secretData.secrets(), SecretsTracker.getCacheText(secretData.cached(), secretData.cacheAge())})), false);
            } else {
                playerEntity.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.secretsTracker.failFeedback")), false);
            }
        }
    }

    private static class_2561 getCacheText(boolean cached, int cacheAge) {
        return class_2561.method_43470((String)"\u2139").method_27694(style -> style.method_36139(cached ? 15386724 : 2198527).method_10949((class_2568)new class_2568.class_10613((class_2561)(cached ? class_2561.method_43469((String)"skyblocker.api.cache.HIT", (Object[])new Object[]{cacheAge}) : class_2561.method_43471((String)"skyblocker.api.cache.MISS")))));
    }

    private static boolean onMessage(class_2561 text, boolean overlay) {
        if (Utils.isInDungeons() && SkyblockerConfigManager.get().dungeons.playerSecretsTracker && !overlay) {
            String message = class_124.method_539((String)text.getString());
            try {
                if (TEAM_SCORE_PATTERN.matcher(message).matches()) {
                    SecretsTracker.calculate(RunPhase.END);
                }
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Encountered an unknown error while trying to track player secrets!", (Throwable)e);
            }
        }
        return true;
    }

    private static String getPlayerNameAt(int index) {
        Matcher matcher = DungeonPlayerManager.getPlayerFromTab(index);
        return matcher != null ? matcher.group("name") : "";
    }

    private static SecretData getPlayerSecrets(String name) {
        String uuid = ApiUtils.name2Uuid(name);
        if (!uuid.isEmpty()) {
            Http.ApiResponse response = Http.sendHypixelRequest("player", "?uuid=" + uuid);
            try {
                SecretData secretData = new SecretData(SecretsTracker.getSecretCountFromAchievements(JsonParser.parseString((String)response.content()).getAsJsonObject()), response.cached(), response.age());
                if (response != null) {
                    response.close();
                }
                return secretData;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("[Skyblocker] Encountered an error while trying to fetch {} secret count!", (Object)(name + "'s"), (Object)e);
                }
            }
        }
        return SecretData.EMPTY;
    }

    private static int getSecretCountFromAchievements(JsonObject playerJson) {
        JsonObject player = playerJson.getAsJsonObject("player");
        JsonObject achievements = player.has("achievements") ? player.getAsJsonObject("achievements") : null;
        return achievements != null && achievements.has("skyblock_treasure_hunter") ? achievements.get("skyblock_treasure_hunter").getAsInt() : 0;
    }

    private static enum RunPhase {
        START,
        END;

    }

    private record SecretData(int secrets, boolean cached, int cacheAge) {
        private static final SecretData EMPTY = new SecretData(0, false, 0);

        private SecretData updated(int secrets, boolean cached) {
            return new SecretData(secrets, cached, this.cacheAge);
        }
    }

    private record TrackedRun(Object2ObjectOpenHashMap<String, SecretData> playersSecretData) {
        private TrackedRun() {
            this((Object2ObjectOpenHashMap<String, SecretData>)new Object2ObjectOpenHashMap());
        }
    }
}

