/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Boxes;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Resettable;
import de.hysky.skyblocker.utils.render.Renderable;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.awt.Color;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2577;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public final class CarpetHighlighter
implements Renderable,
Resettable {
    public static final CarpetHighlighter INSTANCE = new CarpetHighlighter();
    private static final class_243 CARPET_BOUNDING_BOX = Boxes.getLengthVec(class_2577.field_11783.method_1107());
    private static final int SEARCH_RADIUS = 15;
    private static final int TICK_INTERVAL = 15;
    private static final ObjectAVLTreeSet<class_2338> CARPET_LOCATIONS = new ObjectAVLTreeSet();
    private static float[] colorComponents;
    private static boolean isLocationValid;

    @Init
    public static void init() {
        INSTANCE.configCallback(SkyblockerConfigManager.get().mining.dwarvenMines.carpetHighlightColor);
        WorldRenderExtractionCallback.EVENT.register(INSTANCE::extractRendering);
        SkyblockEvents.LOCATION_CHANGE.register(INSTANCE::onLocationChange);
        Scheduler.INSTANCE.scheduleCyclic(INSTANCE::tick, 15);
        ClientPlayConnectionEvents.JOIN.register((Object)INSTANCE);
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (!isLocationValid || !SkyblockerConfigManager.get().mining.dwarvenMines.enableCarpetHighlighter) {
            return;
        }
        for (class_2338 carpetLocation : CARPET_LOCATIONS) {
            collector.submitFilledBox(class_243.method_24954((class_2382)carpetLocation), CARPET_BOUNDING_BOX, colorComponents, colorComponents[3], false);
        }
    }

    public void onLocationChange(Location location) {
        isLocationValid = location == Location.DWARVEN_MINES;
    }

    public void tick() {
        if (!isLocationValid || !SkyblockerConfigManager.get().mining.dwarvenMines.enableCarpetHighlighter || class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null) {
            return;
        }
        Iterable iterable = class_2338.method_25996((class_2338)class_310.method_1551().field_1724.method_24515(), (int)15, (int)15, (int)15);
        for (class_2338 blockPos : iterable) {
            if (!this.checkForCarpet(blockPos)) continue;
            CARPET_LOCATIONS.add((Object)blockPos.method_10062());
        }
    }

    private boolean checkForCarpet(class_2338 blockPos) {
        class_2680 actualBlock = class_310.method_1551().field_1687.method_8320(blockPos);
        if (!(actualBlock.method_27852(class_2246.field_10591) || actualBlock.method_27852(class_2246.field_10290) || actualBlock.method_27852(class_2246.field_10209))) {
            return false;
        }
        class_2680 blockBelow = class_310.method_1551().field_1687.method_8320(blockPos.method_10074());
        return blockBelow.method_27852(class_2246.field_10174);
    }

    public void configCallback(Color color) {
        colorComponents = color.getRGBComponents(null);
    }

    @Override
    public void reset() {
        isLocationValid = false;
        CARPET_LOCATIONS.clear();
    }

    static {
        isLocationValid = false;
    }
}

