/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.dwarven.MiningLocationLabel;
import de.hysky.skyblocker.skyblock.dwarven.NucleusWaypoints;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientBlockPosArgumentType;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientPosArgument;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import de.hysky.skyblocker.utils.ws.Service;
import de.hysky.skyblocker.utils.ws.WsMessageHandler;
import de.hysky.skyblocker.utils.ws.WsStateManager;
import de.hysky.skyblocker.utils.ws.message.CrystalsWaypointMessage;
import de.hysky.skyblocker.utils.ws.message.CrystalsWaypointSubscribeMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.slf4j.Logger;

public class CrystalsLocationsManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Map<String, MiningLocationLabel.CrystalHollowsLocationsCategory> WAYPOINT_LOCATIONS = Arrays.stream(MiningLocationLabel.CrystalHollowsLocationsCategory.values()).collect(Collectors.toMap(MiningLocationLabel.CrystalHollowsLocationsCategory::getName, Function.identity()));
    static final Pattern TEXT_CWORDS_PATTERN = Pattern.compile("\\Dx?(\\d{3})(?=[, ]),? ?y?(\\d{2,3})(?=[, ]),? ?z?(\\d{3})\\D?(?!\\d)");
    private static final int REMOVE_UNKNOWN_DISTANCE = 50;
    protected static Map<String, MiningLocationLabel> activeWaypoints = new HashMap<String, MiningLocationLabel>();
    protected static List<String> verifiedWaypoints = new ArrayList<String>();
    private static final List<MiningLocationLabel.CrystalHollowsLocationsCategory> waypointsSent2Socket = new ArrayList<MiningLocationLabel.CrystalHollowsLocationsCategory>();

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(CrystalsLocationsManager::update, 40);
        WorldRenderExtractionCallback.EVENT.register(CrystalsLocationsManager::extractRendering);
        ClientReceiveMessageEvents.ALLOW_GAME.register(CrystalsLocationsManager::extractLocationFromMessage);
        ClientCommandRegistrationCallback.EVENT.register(CrystalsLocationsManager::registerWaypointLocationCommands);
        SkyblockEvents.LOCATION_CHANGE.register(CrystalsLocationsManager::onLocationChange);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> CrystalsLocationsManager.reset());
        WorldRenderExtractionCallback.EVENT.register(NucleusWaypoints::extractRendering);
    }

    private static boolean extractLocationFromMessage(class_2561 message, Boolean overlay) {
        if (!SkyblockerConfigManager.get().mining.crystalsWaypoints.findInChat || !Utils.isInCrystalHollows() || overlay.booleanValue()) {
            return true;
        }
        String text = class_124.method_539((String)message.getString());
        try {
            String userMessage;
            Matcher matcher;
            if (text.contains(":") && !text.startsWith(Constants.PREFIX.get().getString()) && (matcher = TEXT_CWORDS_PATTERN.matcher(userMessage = text.split(":", 2)[1])).find()) {
                class_2338 blockPos = new class_2338(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                String location = blockPos.method_10263() + " " + blockPos.method_10264() + " " + blockPos.method_10260();
                if (!CrystalsLocationsManager.checkInCrystals(blockPos)) {
                    return true;
                }
                for (String waypointLocation : WAYPOINT_LOCATIONS.keySet()) {
                    if (!Arrays.stream(waypointLocation.toLowerCase(Locale.ENGLISH).split(" ")).anyMatch(word -> userMessage.toLowerCase(Locale.ENGLISH).contains((CharSequence)word))) continue;
                    if (!activeWaypoints.containsKey(waypointLocation)) {
                        CrystalsLocationsManager.addCustomWaypoint(waypointLocation, blockPos);
                    }
                    return true;
                }
                if (CrystalsLocationsManager.CLIENT.field_1724 == null || CLIENT.method_1562() == null) {
                    return true;
                }
                CrystalsLocationsManager.CLIENT.field_1724.method_7353(CrystalsLocationsManager.getLocationMenu(location, false), false);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Crystals Locations Manager] Encountered an exception while extracing a location from a chat message!", (Throwable)e);
        }
        if (CrystalsLocationsManager.CLIENT.field_1724 != null && SkyblockerConfigManager.get().mining.crystalsWaypoints.enabled) {
            for (MiningLocationLabel.CrystalHollowsLocationsCategory waypointLocation : WAYPOINT_LOCATIONS.values()) {
                String waypointLinkedMessage = waypointLocation.getLinkedMessage();
                String waypointName = waypointLocation.getName();
                if (waypointLinkedMessage == null || !text.contains(waypointLinkedMessage) || verifiedWaypoints.contains(waypointName)) continue;
                CrystalsLocationsManager.addCustomWaypoint(waypointLocation.getName(), CrystalsLocationsManager.CLIENT.field_1724.method_24515());
                verifiedWaypoints.add(waypointName);
                CrystalsLocationsManager.trySendWaypoint2Socket(waypointLocation);
            }
        }
        return true;
    }

    protected static boolean checkInCrystals(class_2338 pos) {
        return pos.method_10263() >= 202 && pos.method_10263() <= 823 && pos.method_10260() >= 202 && pos.method_10260() <= 823 && pos.method_10264() >= 31 && pos.method_10264() <= 188;
    }

    private static void registerWaypointLocationCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"crystalWaypoints").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").executes(context -> {
            if (CrystalsLocationsManager.CLIENT.field_1724 == null) {
                return 0;
            }
            CrystalsLocationsManager.CLIENT.field_1724.method_7353(CrystalsLocationsManager.getLocationMenu((int)CrystalsLocationsManager.CLIENT.field_1724.method_23317() + " " + (int)CrystalsLocationsManager.CLIENT.field_1724.method_23318() + " " + (int)CrystalsLocationsManager.CLIENT.field_1724.method_23321(), true), false);
            return 1;
        })).then(ClientCommandManager.argument((String)"pos", (ArgumentType)ClientBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"place", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(WAYPOINT_LOCATIONS.keySet(), (SuggestionsBuilder)builder)).executes(context -> CrystalsLocationsManager.addWaypointFromCommand((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"place"), (ClientPosArgument)context.getArgument("pos", ClientPosArgument.class))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"share").executes(context -> {
            if (CrystalsLocationsManager.CLIENT.field_1724 == null) {
                return 0;
            }
            CrystalsLocationsManager.CLIENT.field_1724.method_7353(CrystalsLocationsManager.getPlacesMenu("share"), false);
            return 1;
        })).then(ClientCommandManager.argument((String)"place", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(WAYPOINT_LOCATIONS.keySet(), (SuggestionsBuilder)builder)).executes(context -> CrystalsLocationsManager.shareWaypoint(StringArgumentType.getString((CommandContext)context, (String)"place")))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").executes(context -> {
            if (CrystalsLocationsManager.CLIENT.field_1724 == null) {
                return 0;
            }
            CrystalsLocationsManager.CLIENT.field_1724.method_7353(CrystalsLocationsManager.getPlacesMenu("remove"), false);
            return 1;
        })).then(ClientCommandManager.argument((String)"place", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(WAYPOINT_LOCATIONS.keySet(), (SuggestionsBuilder)builder)).executes(context -> CrystalsLocationsManager.removeWaypoint(StringArgumentType.getString((CommandContext)context, (String)"place")))))));
    }

    protected static class_2561 getSetLocationMessage(String location, class_2338 blockPos) {
        int locationColor = WAYPOINT_LOCATIONS.get(location).getColor();
        return Constants.PREFIX.get().method_10852((class_2561)class_2561.method_48322((String)"skyblocker.config.mining.crystalsWaypoints.addedWaypoint", (String)"Added waypoint for '%s' at %s %s %s.", (Object[])new Object[]{class_2561.method_43470((String)location).method_54663(locationColor), blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()}));
    }

    private static class_2561 getLocationMenu(String location, boolean excludeUnknown) {
        if (activeWaypoints.size() == WAYPOINT_LOCATIONS.size() || excludeUnknown && WAYPOINT_LOCATIONS.size() - activeWaypoints.size() == 1 && !activeWaypoints.containsKey(MiningLocationLabel.CrystalHollowsLocationsCategory.UNKNOWN.getName())) {
            return Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.allActive").method_27692(class_124.field_1061));
        }
        class_5250 text = class_2561.method_43473();
        for (String waypointLocation : WAYPOINT_LOCATIONS.keySet()) {
            if (activeWaypoints.containsKey(waypointLocation) || excludeUnknown && Objects.equals(waypointLocation, MiningLocationLabel.CrystalHollowsLocationsCategory.UNKNOWN.getName())) continue;
            int locationColor = WAYPOINT_LOCATIONS.get(waypointLocation).getColor();
            text.method_10852((class_2561)class_2561.method_43470((String)("[" + waypointLocation + "]")).method_54663(locationColor).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker crystalWaypoints add " + location + " " + waypointLocation)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.getLocationHover.add").method_54663(locationColor)))));
        }
        return Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.config.mining.crystalsWaypoints.markLocation", (Object[])new Object[]{location, text}));
    }

    private static class_2561 getPlacesMenu(String action) {
        class_5250 hoverMessage;
        class_5250 text = Constants.PREFIX.get();
        if (activeWaypoints.isEmpty()) {
            return text.method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.noActive").method_27692(class_124.field_1061));
        }
        if (action.equals("remove")) {
            text.method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.getLocationHover.remove").method_10852((class_2561)class_2561.method_43470((String)": ")));
            hoverMessage = class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.getLocationHover.remove");
        } else {
            text.method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.getLocationHover.share").method_10852((class_2561)class_2561.method_43470((String)": ")));
            hoverMessage = class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.getLocationHover.share");
        }
        for (String waypointLocation : activeWaypoints.keySet()) {
            int locationColor = WAYPOINT_LOCATIONS.get(waypointLocation).getColor();
            text.method_10852((class_2561)class_2561.method_43470((String)("[" + waypointLocation + "]")).method_54663(locationColor).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker crystalWaypoints " + action + " " + waypointLocation)).method_10949((class_2568)new class_2568.class_10613((class_2561)hoverMessage.method_54663(locationColor)))));
        }
        return text;
    }

    public static int addWaypointFromCommand(FabricClientCommandSource source, String place, ClientPosArgument location) {
        class_2338 blockPos = location.toAbsoluteBlockPos(source);
        if (WAYPOINT_LOCATIONS.containsKey(place)) {
            CrystalsLocationsManager.addCustomWaypoint(place, blockPos);
            if (CrystalsLocationsManager.CLIENT.field_1724 == null || CLIENT.method_1562() == null) {
                return 0;
            }
            CrystalsLocationsManager.CLIENT.field_1724.method_7353(CrystalsLocationsManager.getSetLocationMessage(place, blockPos), false);
        }
        return 1;
    }

    public static int shareWaypoint(String place) {
        if (activeWaypoints.containsKey(place)) {
            class_2338 pos = CrystalsLocationsManager.activeWaypoints.get((Object)place).pos;
            MessageScheduler.INSTANCE.sendMessageAfterCooldown(Constants.PREFIX.get().getString() + " " + place + ": " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260(), false);
        } else {
            if (CrystalsLocationsManager.CLIENT.field_1724 == null || CLIENT.method_1562() == null) {
                return 0;
            }
            CrystalsLocationsManager.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.shareFail").method_27692(class_124.field_1061)), false);
        }
        return 1;
    }

    public static int removeWaypoint(String place) {
        if (CrystalsLocationsManager.CLIENT.field_1724 == null || CLIENT.method_1562() == null) {
            return 0;
        }
        if (activeWaypoints.containsKey(place)) {
            CrystalsLocationsManager.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.removeSuccess").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)place).method_54663(WAYPOINT_LOCATIONS.get(place).getColor())), false);
            activeWaypoints.remove(place);
            verifiedWaypoints.remove(place);
        } else {
            CrystalsLocationsManager.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.removeFail").method_27692(class_124.field_1061)), false);
        }
        return 1;
    }

    public static void addCustomWaypointFromSocket(CrystalsWaypointMessage ... messages) {
        class_5250 receivedWaypointNames = class_2561.method_43473();
        boolean shouldSend = false;
        for (CrystalsWaypointMessage message : messages) {
            MiningLocationLabel.CrystalHollowsLocationsCategory category = message.location();
            class_2338 pos = message.coordinates();
            if (activeWaypoints.containsKey(category.getName()) || category == MiningLocationLabel.CrystalHollowsLocationsCategory.FAIRY_GROTTO && !SkyblockerConfigManager.get().mining.crystalsWaypoints.shareFairyGrotto) continue;
            shouldSend = true;
            CrystalsLocationsManager.removeUnknownNear(pos);
            MiningLocationLabel waypoint = new MiningLocationLabel(category, pos);
            waypointsSent2Socket.add(category);
            activeWaypoints.put(category.getName(), waypoint);
            receivedWaypointNames.method_10852((class_2561)class_2561.method_43470((String)category.getName()).method_54663(category.getColor()));
            if (message == messages[messages.length - 1]) continue;
            receivedWaypointNames.method_27693(", ");
        }
        if (!shouldSend) {
            return;
        }
        assert (CrystalsLocationsManager.CLIENT.field_1724 != null);
        CrystalsLocationsManager.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.webSocket.receivedCrystalsWaypoint", (Object[])new Object[]{receivedWaypointNames})), false);
    }

    protected static void addCustomWaypoint(String waypointName, class_2338 pos) {
        CrystalsLocationsManager.removeUnknownNear(pos);
        MiningLocationLabel.CrystalHollowsLocationsCategory category = WAYPOINT_LOCATIONS.get(waypointName);
        MiningLocationLabel waypoint = new MiningLocationLabel(category, pos);
        activeWaypoints.put(waypointName, waypoint);
    }

    private static void removeUnknownNear(class_2338 location) {
        double distance;
        String name = MiningLocationLabel.CrystalHollowsLocationsCategory.UNKNOWN.getName();
        MiningLocationLabel unknownWaypoint = activeWaypoints.getOrDefault(name, null);
        if (unknownWaypoint != null && (distance = unknownWaypoint.centerPos.method_1022(location.method_46558())) < 50.0) {
            activeWaypoints.remove(name);
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (SkyblockerConfigManager.get().mining.crystalsWaypoints.enabled) {
            for (MiningLocationLabel crystalsWaypoint : activeWaypoints.values()) {
                crystalsWaypoint.extractRendering(collector);
            }
        }
    }

    private static void onLocationChange(Location newLocation) {
        if (newLocation == Location.CRYSTAL_HOLLOWS) {
            WsStateManager.subscribe(Service.CRYSTAL_WAYPOINTS, Optional.of(CrystalsWaypointSubscribeMessage.create(CrystalsLocationsManager.CLIENT.field_1687)));
        }
    }

    private static void reset() {
        activeWaypoints.clear();
        verifiedWaypoints.clear();
        waypointsSent2Socket.clear();
    }

    private static void update() {
        if (CrystalsLocationsManager.CLIENT.field_1724 == null || CLIENT.method_1562() == null || !SkyblockerConfigManager.get().mining.crystalsWaypoints.enabled || !Utils.isInCrystalHollows()) {
            return;
        }
        String location = Utils.getIslandArea().substring(2);
        if (!location.equals("Unknown") && WAYPOINT_LOCATIONS.containsKey(location)) {
            if (!activeWaypoints.containsKey(location)) {
                class_2338 playerLocation = CrystalsLocationsManager.CLIENT.field_1724.method_24515();
                CrystalsLocationsManager.addCustomWaypoint(location, playerLocation);
            }
            CrystalsLocationsManager.trySendWaypoint2Socket(WAYPOINT_LOCATIONS.get(location));
        }
    }

    private static void trySendWaypoint2Socket(MiningLocationLabel.CrystalHollowsLocationsCategory category) {
        if (waypointsSent2Socket.contains(category)) {
            return;
        }
        if (category == MiningLocationLabel.CrystalHollowsLocationsCategory.FAIRY_GROTTO && !SkyblockerConfigManager.get().mining.crystalsWaypoints.shareFairyGrotto) {
            return;
        }
        WsMessageHandler.sendMessage(Service.CRYSTAL_WAYPOINTS, new CrystalsWaypointMessage(category, CrystalsLocationsManager.CLIENT.field_1724.method_24515()));
        waypointsSent2Socket.add(category);
    }
}

