/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9848;

public class GlaciteColdOverlay {
    private static final class_2960 POWDER_SNOW_OUTLINE = class_2960.method_60656((String)"textures/misc/powder_snow_outline.png");
    private static final Pattern COLD_PATTERN = Pattern.compile("Cold: -(\\d+)\u2744");
    private static int cold = 0;
    private static long resetTime = System.currentTimeMillis();

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(GlaciteColdOverlay::update, 20);
        ClientReceiveMessageEvents.ALLOW_GAME.register(GlaciteColdOverlay::coldReset);
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.MISC_OVERLAYS, (class_2960)POWDER_SNOW_OUTLINE, (context, tickCounter) -> GlaciteColdOverlay.render(context));
    }

    private static boolean coldReset(class_2561 text, boolean b) {
        if (!Utils.isInDwarvenMines() || b) {
            return true;
        }
        String message = text.getString();
        if (message.equals("The warmth of the campfire reduced your \u2744 Cold to 0!")) {
            cold = 0;
            resetTime = System.currentTimeMillis();
        }
        return true;
    }

    private static void update() {
        if (!Utils.isInDwarvenMines() || System.currentTimeMillis() - resetTime < 3000L || !SkyblockerConfigManager.get().mining.glacite.coldOverlay) {
            cold = 0;
            return;
        }
        for (String line : Utils.STRING_SCOREBOARD) {
            Matcher coldMatcher = COLD_PATTERN.matcher(line);
            if (!coldMatcher.matches()) continue;
            String value = coldMatcher.group(1);
            cold = Integer.parseInt(value);
            return;
        }
        cold = 0;
    }

    private static void renderOverlay(class_332 context, class_2960 texture, float opacity) {
        int white = class_9848.method_61317((float)opacity);
        context.method_25291(class_10799.field_56883, texture, 0, 0, 0.0f, 0.0f, context.method_51421(), context.method_51443(), context.method_51421(), context.method_51443(), white);
    }

    public static void render(class_332 context) {
        if (Utils.isInDwarvenMines() && SkyblockerConfigManager.get().mining.glacite.coldOverlay) {
            GlaciteColdOverlay.renderOverlay(context, POWDER_SNOW_OUTLINE, (float)cold / 100.0f);
        }
    }
}

