/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.profittrackers;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.PowderMiningTracker;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.Location;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@RegisterWidget
public class PowderMiningWidget
extends HudWidget {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Set<Location> LOCATIONS = Set.of(Location.CRYSTAL_HOLLOWS);

    public PowderMiningWidget() {
        super("powder_mining_tracker");
    }

    @Override
    public void renderWidget(class_332 context, int mouseX, int mouseY, float delta) {
        ObjectSet set = PowderMiningTracker.getShownRewards().object2IntEntrySet();
        if (set.isEmpty()) {
            this.setDimensions(0, 0);
            return;
        }
        int tempY = this.y;
        int maxWidth = 0;
        for (Object2IntMap.Entry entry : set) {
            class_5250 price = class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(entry.getIntValue())).method_54663(-1);
            class_5250 text = ((class_2561)entry.getKey()).method_27661().method_27693(" ").method_10852((class_2561)price);
            context.method_27535(PowderMiningWidget.CLIENT.field_1772, (class_2561)text, this.x, tempY, -1);
            tempY += 10;
            int width = PowderMiningWidget.CLIENT.field_1772.method_27525((class_5348)text);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        context.method_27535(PowderMiningWidget.CLIENT.field_1772, (class_2561)class_2561.method_43469((String)"skyblocker.powderTracker.profit", (Object[])new Object[]{Formatters.DOUBLE_NUMBERS.format(PowderMiningTracker.getProfit())}).method_27692(class_124.field_1065), this.x, tempY += 10, -1);
        this.setDimensions(maxWidth, tempY - this.y + 10);
    }

    @Override
    public Set<Location> availableLocations() {
        return LOCATIONS;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!LOCATIONS.contains((Object)location)) {
            return;
        }
        SkyblockerConfigManager.get().mining.crystalHollows.enablePowderTracker = enabled;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        if (!LOCATIONS.contains((Object)location)) {
            return false;
        }
        return SkyblockerConfigManager.get().mining.crystalHollows.enablePowderTracker;
    }

    @Override
    public void update() {
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"skyblocker.powderTracker");
    }
}

