/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.fancybars;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.StatusBarTracker;
import de.hysky.skyblocker.skyblock.fancybars.BarPositioner;
import de.hysky.skyblocker.skyblock.fancybars.StatusBar;
import de.hysky.skyblocker.skyblock.fancybars.StatusBarType;
import de.hysky.skyblocker.skyblock.fancybars.StatusBarsConfigScreen;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_8029;
import org.jetbrains.annotations.VisibleForTesting;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FancyStatusBars {
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("status_bars.json");
    private static final Logger LOGGER = LoggerFactory.getLogger(FancyStatusBars.class);
    public static BarPositioner barPositioner = new BarPositioner();
    public static Map<StatusBarType, StatusBar> statusBars = new EnumMap<StatusBarType, StatusBar>(StatusBarType.class);
    private static boolean configLoaded = false;

    public static boolean isHealthFancyBarEnabled() {
        return FancyStatusBars.isBarEnabled(StatusBarType.HEALTH);
    }

    public static boolean isExperienceFancyBarEnabled() {
        return FancyStatusBars.isBarEnabled(StatusBarType.EXPERIENCE);
    }

    public static boolean isBarEnabled(StatusBarType type) {
        StatusBar statusBar = statusBars.get((Object)type);
        return Debug.isTestEnvironment() || statusBar.enabled || statusBar.inMouse;
    }

    @Init
    public static void init() {
        statusBars.put(StatusBarType.HEALTH, StatusBarType.HEALTH.newStatusBar());
        statusBars.put(StatusBarType.INTELLIGENCE, StatusBarType.INTELLIGENCE.newStatusBar());
        statusBars.put(StatusBarType.DEFENSE, StatusBarType.DEFENSE.newStatusBar());
        statusBars.put(StatusBarType.EXPERIENCE, StatusBarType.EXPERIENCE.newStatusBar());
        statusBars.put(StatusBarType.SPEED, StatusBarType.SPEED.newStatusBar());
        statusBars.put(StatusBarType.AIR, StatusBarType.AIR.newStatusBar());
        int[] counts = new int[3];
        UIAndVisualsConfig.LegacyBarPositions barPositions = SkyblockerConfigManager.get().uiAndVisuals.bars.barPositions;
        FancyStatusBars.initBarPosition(statusBars.get((Object)StatusBarType.HEALTH), counts, barPositions.healthBarPosition);
        FancyStatusBars.initBarPosition(statusBars.get((Object)StatusBarType.INTELLIGENCE), counts, barPositions.manaBarPosition);
        FancyStatusBars.initBarPosition(statusBars.get((Object)StatusBarType.DEFENSE), counts, barPositions.defenceBarPosition);
        FancyStatusBars.initBarPosition(statusBars.get((Object)StatusBarType.EXPERIENCE), counts, barPositions.experienceBarPosition);
        FancyStatusBars.initBarPosition(statusBars.get((Object)StatusBarType.SPEED), counts, UIAndVisualsConfig.LegacyBarPosition.RIGHT);
        FancyStatusBars.initBarPosition(statusBars.get((Object)StatusBarType.AIR), counts, UIAndVisualsConfig.LegacyBarPosition.RIGHT);
        ((CompletableFuture)CompletableFuture.supplyAsync(FancyStatusBars::loadBarConfig).thenAccept(object -> {
            if (object != null) {
                for (String s : object.keySet()) {
                    StatusBarType type = StatusBarType.from(s);
                    if (statusBars.containsKey((Object)type)) {
                        try {
                            statusBars.get((Object)type).loadFromJson(object.get(s).getAsJsonObject());
                        }
                        catch (Exception e) {
                            LOGGER.error("[Skyblocker] Failed to load {} status bar", (Object)s, (Object)e);
                        }
                        continue;
                    }
                    LOGGER.warn("[Skyblocker] Unknown status bar: {}", (Object)s);
                }
            }
            FancyStatusBars.placeBarsInPositioner();
            configLoaded = true;
        })).exceptionally(throwable -> {
            LOGGER.error("[Skyblocker] Failed reading status bars config", throwable);
            return null;
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            FancyStatusBars.saveBarConfig();
            GLFW.glfwDestroyCursor((long)StatusBarsConfigScreen.RESIZE_CURSOR);
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"bars").executes(Scheduler.queueOpenScreenCommand(StatusBarsConfigScreen::new)))));
    }

    private static void initBarPosition(StatusBar bar, int[] counts, UIAndVisualsConfig.LegacyBarPosition position) {
        switch (position) {
            case RIGHT: {
                bar.anchor = BarPositioner.BarAnchor.HOTBAR_RIGHT;
                bar.gridY = 0;
                int n = position.ordinal();
                int n2 = counts[n];
                counts[n] = n2 + 1;
                bar.gridX = n2;
                break;
            }
            case LAYER1: {
                bar.anchor = BarPositioner.BarAnchor.HOTBAR_TOP;
                bar.gridY = 0;
                int n = position.ordinal();
                int n3 = counts[n];
                counts[n] = n3 + 1;
                bar.gridX = n3;
                break;
            }
            case LAYER2: {
                bar.anchor = BarPositioner.BarAnchor.HOTBAR_TOP;
                bar.gridY = 1;
                int n = position.ordinal();
                int n4 = counts[n];
                counts[n] = n4 + 1;
                bar.gridX = n4;
            }
        }
    }

    @VisibleForTesting
    public static void placeBarsInPositioner() {
        barPositioner.clear();
        for (BarPositioner.BarAnchor barAnchor : BarPositioner.BarAnchor.allAnchors()) {
            List<StatusBar> barList = statusBars.values().stream().filter(bar -> bar.anchor == barAnchor).sorted(Comparator.comparingInt(bar -> bar.gridY).thenComparingInt(bar -> bar.gridX)).toList();
            if (barList.isEmpty()) continue;
            int y = -1;
            int rowNum = -1;
            for (StatusBar statusBar : barList) {
                if (statusBar.gridY > y) {
                    barPositioner.addRow(barAnchor);
                    ++rowNum;
                    y = statusBar.gridY;
                }
                barPositioner.addBar(barAnchor, rowNum, statusBar);
            }
        }
    }

    public static JsonObject loadBarConfig() {
        block10: {
            JsonObject jsonObject;
            block9: {
                BufferedReader reader = Files.newBufferedReader(FILE);
                try {
                    jsonObject = (JsonObject)SkyblockerMod.GSON.fromJson((Reader)reader, JsonObject.class);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException e) {
                        LOGGER.warn("[Skyblocker] No status bar config file found, using defaults");
                        break block10;
                    }
                    catch (Exception e) {
                        LOGGER.error("[Skyblocker] Failed to load status bars config", (Throwable)e);
                    }
                }
                reader.close();
            }
            return jsonObject;
        }
        return null;
    }

    public static void saveBarConfig() {
        JsonObject output = new JsonObject();
        statusBars.forEach((s, statusBar) -> output.add(s.method_15434(), (JsonElement)statusBar.toJson()));
        try (BufferedWriter writer = Files.newBufferedWriter(FILE, new OpenOption[0]);){
            SkyblockerMod.GSON.toJson((JsonElement)output, (Appendable)writer);
            LOGGER.info("[Skyblocker] Saved status bars config");
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker] Failed to save status bars config", (Throwable)e);
        }
    }

    public static void updatePositions(boolean ignoreVisibility) {
        if (!configLoaded) {
            return;
        }
        int width = class_310.method_1551().method_22683().method_4486();
        int height = class_310.method_1551().method_22683().method_4502();
        int offset = 0;
        for (StatusBar statusBar : statusBars.values()) {
            if (!statusBar.enabled) {
                statusBar.method_46421(5);
                statusBar.method_46419(50 + offset);
                statusBar.setWidth(30);
                offset += statusBar.method_25364();
                continue;
            }
            if (statusBar.anchor != null) continue;
            statusBar.width = Math.clamp(statusBar.width, 30.0f / (float)width, 1.0f);
            statusBar.x = Math.clamp(statusBar.x, 0.0f, 1.0f - statusBar.width);
            statusBar.y = Math.clamp(statusBar.y, 0.0f, 1.0f - (float)statusBar.method_25364() / (float)height);
            statusBar.method_46421((int)(statusBar.x * (float)width));
            statusBar.method_46419((int)(statusBar.y * (float)height));
            statusBar.setWidth((int)(statusBar.width * (float)width));
        }
        for (BarPositioner.BarAnchor barAnchor : BarPositioner.BarAnchor.allAnchors()) {
            int row;
            boolean visibleHealthMove;
            class_8029 anchorPosition = barAnchor.getAnchorPosition(width, height);
            BarPositioner.SizeRule sizeRule = barAnchor.getSizeRule();
            int targetSize = sizeRule.targetSize();
            boolean bl = visibleHealthMove = barAnchor == BarPositioner.BarAnchor.HOTBAR_TOP && !FancyStatusBars.isHealthFancyBarEnabled();
            if (visibleHealthMove) {
                targetSize /= 2;
            }
            if (sizeRule.isTargetSize()) {
                block2: for (row = 0; row < barPositioner.getRowCount(barAnchor); ++row) {
                    LinkedList<StatusBar> barRow = barPositioner.getRow(barAnchor, row);
                    if (barRow.isEmpty()) continue;
                    int totalSize = 0;
                    for (StatusBar statusBar : barRow) {
                        statusBar.size = Math.clamp((long)statusBar.size, sizeRule.minSize(), sizeRule.maxSize());
                        totalSize += statusBar.size;
                    }
                    while (totalSize != targetSize) {
                        if (totalSize > targetSize) {
                            for (StatusBar statusBar : barRow) {
                                if (statusBar.size <= sizeRule.minSize()) continue;
                                --statusBar.size;
                                if (--totalSize != targetSize) continue;
                                continue block2;
                            }
                            continue;
                        }
                        for (StatusBar statusBar : barRow) {
                            if (statusBar.size >= sizeRule.maxSize()) continue;
                            ++statusBar.size;
                            if (++totalSize != targetSize) continue;
                            continue block2;
                        }
                    }
                }
            }
            row = 0;
            for (int i = 0; i < barPositioner.getRowCount(barAnchor); ++i) {
                float widthPerSize;
                LinkedList<StatusBar> barRow = barPositioner.getRow(barAnchor, i);
                if (barRow.isEmpty()) continue;
                if (sizeRule.isTargetSize()) {
                    int size = 0;
                    for (StatusBar bar : barRow) {
                        if (!bar.visible && !ignoreVisibility) continue;
                        size += bar.size;
                    }
                    widthPerSize = (float)sizeRule.totalWidth() / (float)size;
                } else {
                    widthPerSize = sizeRule.widthPerSize();
                }
                if (visibleHealthMove) {
                    widthPerSize /= 2.0f;
                }
                int currSize = 0;
                int rowSize = barRow.size();
                for (int j = 0; j < rowSize; ++j) {
                    int offsetX = 0;
                    int lessWidth = 0;
                    if (rowSize > 1) {
                        if (j == 0) {
                            lessWidth = 1;
                        } else if (j == rowSize - 1) {
                            lessWidth = 1;
                            offsetX = 1;
                        } else {
                            lessWidth = 2;
                            offsetX = 1;
                        }
                    }
                    StatusBar statusBar = (StatusBar)barRow.get(j);
                    statusBar.size = Math.clamp((long)statusBar.size, sizeRule.minSize(), sizeRule.maxSize());
                    if (!statusBar.visible && !ignoreVisibility) continue;
                    float x = barAnchor.isRight() ? (float)anchorPosition.comp_1193() + (visibleHealthMove ? (float)sizeRule.totalWidth() / 2.0f : 0.0f) + (float)currSize * widthPerSize : (float)anchorPosition.comp_1193() - (float)currSize * widthPerSize - (float)statusBar.size * widthPerSize;
                    statusBar.method_46421(class_3532.method_15386((float)x) + offsetX);
                    int y = barAnchor.isUp() ? anchorPosition.comp_1194() - (row + 1) * (statusBar.method_25364() + 1) : anchorPosition.comp_1194() + row * (statusBar.method_25364() + 1);
                    statusBar.method_46419(y);
                    statusBar.setWidth(class_3532.method_15375((float)((float)statusBar.size * widthPerSize)) - lessWidth);
                    currSize += statusBar.size;
                }
                if (currSize <= 0) continue;
                ++row;
            }
        }
    }

    public static boolean isEnabled() {
        return SkyblockerConfigManager.get().uiAndVisuals.bars.enableBars && !Utils.isInTheRift();
    }

    public static boolean render(class_332 context, class_310 client) {
        class_746 player = client.field_1724;
        if (!FancyStatusBars.isEnabled() || player == null) {
            return false;
        }
        Collection<StatusBar> barCollection = statusBars.values();
        for (StatusBar statusBar : barCollection) {
            if (!statusBar.enabled || !statusBar.visible) continue;
            statusBar.renderBar(context);
        }
        for (StatusBar statusBar : barCollection) {
            if (!statusBar.enabled || !statusBar.visible) continue;
            statusBar.renderText(context);
        }
        StatusBarTracker.Resource health = StatusBarTracker.getHealth();
        statusBars.get((Object)StatusBarType.HEALTH).updateWithResource(health);
        StatusBarTracker.Resource intelligence = StatusBarTracker.getMana();
        if (SkyblockerConfigManager.get().uiAndVisuals.bars.intelligenceDisplay == UIAndVisualsConfig.IntelligenceDisplay.ACCURATE) {
            float totalIntelligence = (float)intelligence.max() + (float)intelligence.overflow();
            statusBars.get((Object)StatusBarType.INTELLIGENCE).updateValues((float)intelligence.value() / totalIntelligence + (float)intelligence.overflow() / totalIntelligence, (float)intelligence.overflow() / totalIntelligence, intelligence.value(), intelligence.max(), intelligence.overflow());
        } else {
            statusBars.get((Object)StatusBarType.INTELLIGENCE).updateWithResource(intelligence);
        }
        int defense = StatusBarTracker.getDefense();
        statusBars.get((Object)StatusBarType.DEFENSE).updateValues((float)defense / ((float)defense + 100.0f), 0.0f, defense, null, null);
        StatusBarTracker.Resource speed = StatusBarTracker.getSpeed();
        statusBars.get((Object)StatusBarType.SPEED).updateWithResource(speed);
        statusBars.get((Object)StatusBarType.EXPERIENCE).updateValues(player.field_7510, 0.0f, player.field_7520, null, null);
        StatusBarTracker.Resource air = StatusBarTracker.getAir();
        StatusBar airBar = statusBars.get((Object)StatusBarType.AIR);
        airBar.updateWithResource(air);
        if (player.method_5869() != airBar.visible) {
            airBar.visible = player.method_5869();
            FancyStatusBars.updatePositions(false);
        }
        return true;
    }
}

