/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.events.ItemPriceUpdateEvent;
import de.hysky.skyblocker.skyblock.item.tooltip.ItemTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.info.DataTooltipInfoType;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class ItemPrice {
    public static final class_304 ITEM_PRICE_LOOKUP = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.itemPriceLookup", 295, "key.categories.skyblocker"));

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"refreshPrices").executes(context -> {
            ItemPrice.refreshItemPrices(((FabricClientCommandSource)context.getSource()).getPlayer());
            return 1;
        }))));
    }

    public static void itemPriceLookup(class_746 player, @NotNull class_1735 slot) {
        class_1799 stack = slot.method_7677();
        ItemPrice.itemPriceLookup(player, stack);
    }

    public static void itemPriceLookup(class_746 player, class_1799 stack) {
        String skyblockApiId = stack.getSkyblockApiId();
        class_1799 neuStack = ItemRepository.getItemStack(stack.getNeuName());
        if (neuStack != null && !neuStack.method_7960()) {
            String itemName = class_124.method_539((String)neuStack.method_7964().getString());
            if (stack.getSkyblockId().equals("PET")) {
                itemName = itemName.replaceFirst("\\[Lvl \\d+ \u27a1 \\d+] ", "");
            }
            if (itemName.equals("Enchanted Book")) {
                itemName = ((class_2561)ItemUtils.getLore(stack).stream().findFirst().orElse(class_2561.method_43473())).getString();
            }
            if (TooltipInfoType.BAZAAR.hasOrNullWarning(skyblockApiId)) {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("/bz " + itemName, true);
                return;
            }
            if (TooltipInfoType.LOWEST_BINS.hasOrNullWarning(skyblockApiId)) {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("/ahsearch " + itemName, true);
                return;
            }
        }
        player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.helpers.itemPrice.itemPriceLookupFailed")), false);
    }

    private static void refreshItemPrices(class_746 player) {
        player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.helpers.itemPrice.refreshingItemPrices")), false);
        ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.of(TooltipInfoType.NPC, TooltipInfoType.BAZAAR, TooltipInfoType.LOWEST_BINS, TooltipInfoType.ONE_DAY_AVERAGE, TooltipInfoType.THREE_DAY_AVERAGE).map(DataTooltipInfoType::downloadIfEnabled).toArray(CompletableFuture[]::new)).thenRun(() -> {
            ((ItemPriceUpdateEvent)ItemPriceUpdateEvent.ON_PRICE_UPDATE.invoker()).onPriceUpdate();
            player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.helpers.itemPrice.refreshedItemPrices")), false);
        })).exceptionally(e -> {
            ItemTooltip.LOGGER.error("[Skyblocker Item Price] Failed to refresh item prices", e);
            player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.helpers.itemPrice.itemPriceRefreshFailed")), false);
            return null;
        });
    }
}

