/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.HotbarSlotLock;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ItemProtection {
    public static final class_2960 ITEM_PROTECTION_TEX = SkyblockerMod.id("textures/gui/item_protection.png");
    public static class_304 itemProtection;

    @Init
    public static void init() {
        itemProtection = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.itemProtection", 86, "key.categories.skyblocker"));
        ClientCommandRegistrationCallback.EVENT.register(ItemProtection::registerCommand);
        UseEntityCallback.EVENT.register(ItemProtection::onEntityInteract);
    }

    public static boolean isItemProtected(class_1799 stack) {
        if (stack == null) {
            return false;
        }
        String itemUuid = stack.getUuid();
        return SkyblockerConfigManager.get().general.protectedItems.contains((Object)itemUuid);
    }

    private static void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"protectItem").executes(context -> ItemProtection.protectMyItem((FabricClientCommandSource)context.getSource()))));
    }

    private static int protectMyItem(FabricClientCommandSource source) {
        class_1799 heldItem = source.getPlayer().method_6047();
        if (Utils.isOnSkyblock()) {
            String itemUuid = heldItem.getUuid();
            if (!itemUuid.isEmpty()) {
                ObjectOpenHashSet<String> protectedItems = SkyblockerConfigManager.get().general.protectedItems;
                if (!protectedItems.contains((Object)itemUuid)) {
                    protectedItems.add((Object)itemUuid);
                    SkyblockerConfigManager.save();
                    source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.itemProtection.added", (Object[])new Object[]{heldItem.method_7964()})));
                } else {
                    protectedItems.remove((Object)itemUuid);
                    SkyblockerConfigManager.save();
                    source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.itemProtection.removed", (Object[])new Object[]{heldItem.method_7964()})));
                }
            } else {
                source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.itemProtection.noItemUuid")));
            }
        } else {
            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.itemProtection.unableToProtect")));
        }
        return 1;
    }

    public static void handleKeyPressed(class_1799 heldItem) {
        boolean notifyConfiguration = SkyblockerConfigManager.get().general.itemProtection.displayChatNotification;
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity == null) {
            return;
        }
        if (!Utils.isOnSkyblock()) {
            playerEntity.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.itemProtection.unableToProtect")), false);
            return;
        }
        if (heldItem.method_7960()) {
            playerEntity.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.itemProtection.noItemUuid")), false);
            return;
        }
        String itemUuid = heldItem.getUuid();
        if (!itemUuid.isEmpty()) {
            ObjectOpenHashSet<String> protectedItems = SkyblockerConfigManager.get().general.protectedItems;
            if (!protectedItems.contains((Object)itemUuid)) {
                protectedItems.add((Object)itemUuid);
                SkyblockerConfigManager.save();
                if (notifyConfiguration) {
                    playerEntity.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.itemProtection.added", (Object[])new Object[]{heldItem.method_7964()})), false);
                }
            } else {
                protectedItems.remove((Object)itemUuid);
                SkyblockerConfigManager.save();
                if (notifyConfiguration) {
                    playerEntity.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.itemProtection.removed", (Object[])new Object[]{heldItem.method_7964()})), false);
                }
            }
        } else {
            playerEntity.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.itemProtection.noItemUuid")), false);
        }
    }

    public static void handleHotbarKeyPressed(class_746 player) {
        while (itemProtection.method_1436()) {
            class_1799 heldItem = player.method_6047();
            ItemProtection.handleKeyPressed(heldItem);
        }
    }

    private static class_1269 onEntityInteract(class_1657 playerEntity, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        class_1533 itemFrame;
        if (!Utils.isOnSkyblock() || !world.field_9236) {
            return class_1269.field_5811;
        }
        Location location = Utils.getLocation();
        if (location != Location.PRIVATE_ISLAND && location != Location.GARDEN) {
            return class_1269.field_5811;
        }
        if (entity instanceof class_1533 && (itemFrame = (class_1533)entity).method_6940().method_7960() && (ItemProtection.isItemProtected(playerEntity.method_5998(hand)) || HotbarSlotLock.isLocked(playerEntity.method_31548().method_67532()))) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }
}

