/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.OkLabColor;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.command.argumenttypes.color.ColorArgumentType;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_7157;
import org.jetbrains.annotations.VisibleForTesting;

public class CustomArmorAnimatedDyes {
    private static final Object2ObjectOpenHashMap<AnimatedDye, AnimatedDyeStateTracker> STATE_TRACKER_MAP = new Object2ObjectOpenHashMap();
    private static final float DEFAULT_DELAY = 0.0f;
    private static int frames;

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(CustomArmorAnimatedDyes::registerCommands);
        WorldRenderExtractionCallback.EVENT.register(ignored -> ++frames);
        SkyblockEvents.LOCATION_CHANGE.register(ignored -> CustomArmorAnimatedDyes.cleanTrackers());
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"custom").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"animatedDye").executes(context -> CustomArmorAnimatedDyes.customizeAnimatedDye((FabricClientCommandSource)context.getSource(), Integer.MIN_VALUE, Integer.MIN_VALUE, 0.0f, false, 0.0f))).then(ClientCommandManager.argument((String)"hex1", (ArgumentType)ColorArgumentType.hex()).then(ClientCommandManager.argument((String)"hex2", (ArgumentType)ColorArgumentType.hex()).then(ClientCommandManager.argument((String)"duration", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)10.0f)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"cycleBack", (ArgumentType)BoolArgumentType.bool()).executes(context -> CustomArmorAnimatedDyes.customizeAnimatedDye((FabricClientCommandSource)context.getSource(), ColorArgumentType.getIntFromHex((CommandContext<FabricClientCommandSource>)context, "hex1"), ColorArgumentType.getIntFromHex((CommandContext<FabricClientCommandSource>)context, "hex2"), FloatArgumentType.getFloat((CommandContext)context, (String)"duration"), BoolArgumentType.getBool((CommandContext)context, (String)"cycleBack"), 0.0f))).then(ClientCommandManager.argument((String)"delay", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> CustomArmorAnimatedDyes.customizeAnimatedDye((FabricClientCommandSource)context.getSource(), ColorArgumentType.getIntFromHex((CommandContext<FabricClientCommandSource>)context, "hex1"), ColorArgumentType.getIntFromHex((CommandContext<FabricClientCommandSource>)context, "hex2"), FloatArgumentType.getFloat((CommandContext)context, (String)"duration"), BoolArgumentType.getBool((CommandContext)context, (String)"cycleBack"), FloatArgumentType.getFloat((CommandContext)context, (String)"delay")))))))))));
    }

    private static int customizeAnimatedDye(FabricClientCommandSource source, int color1, int color2, float duration, boolean cycleBack, float delay) {
        class_1799 heldItem = source.getPlayer().method_6047();
        if (Utils.isOnSkyblock() && heldItem != null && !heldItem.method_7960()) {
            if (heldItem.method_31573(class_3489.field_48803)) {
                String itemUuid = heldItem.getUuid();
                if (!itemUuid.isEmpty()) {
                    Object2ObjectOpenHashMap<String, AnimatedDye> customAnimatedDyes = SkyblockerConfigManager.get().general.customAnimatedDyes;
                    if (color1 == Integer.MIN_VALUE && color2 == Integer.MIN_VALUE) {
                        if (customAnimatedDyes.containsKey((Object)itemUuid)) {
                            SkyblockerConfigManager.update(config -> config.general.customAnimatedDyes.remove((Object)itemUuid));
                            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customAnimatedDyes.removed")));
                        } else {
                            source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customAnimatedDyes.neverHad")));
                        }
                    } else {
                        AnimatedDye animatedDye = new AnimatedDye(List.of(new Keyframe(color1, 0.0f), new Keyframe(color2, 1.0f)), cycleBack, delay, duration);
                        SkyblockerConfigManager.update(config -> config.general.customAnimatedDyes.put((Object)itemUuid, (Object)animatedDye));
                        source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customAnimatedDyes.added")));
                    }
                } else {
                    source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customAnimatedDyes.noItemUuid")));
                }
            } else {
                source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customAnimatedDyes.notDyeable")));
            }
        } else {
            source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customAnimatedDyes.unableToSetDye")));
        }
        return 1;
    }

    public static int animateColorTransition(AnimatedDye animatedDye) {
        AnimatedDyeStateTracker trackedState = (AnimatedDyeStateTracker)STATE_TRACKER_MAP.computeIfAbsent((Object)animatedDye, AnimatedDyeStateTracker::new);
        if (trackedState.lastRecordedFrame == frames) {
            return trackedState.lastColor;
        }
        trackedState.lastRecordedFrame = frames;
        return trackedState.interpolate(animatedDye, class_310.method_1551().method_61966().method_60636());
    }

    public static void cleanTrackers() {
        STATE_TRACKER_MAP.clear();
    }

    public record AnimatedDye(@SerialEntry List<Keyframe> keyframes, @SerialEntry boolean cycleBack, @SerialEntry float delay, @SerialEntry float duration) {
    }

    public record Keyframe(@SerialEntry int color, @SerialEntry float time) {
    }

    @VisibleForTesting
    static class AnimatedDyeStateTracker {
        private float progress = 0.0f;
        private boolean onBackCycle = false;
        private int lastColor = 0;
        private int lastRecordedFrame = 0;

        @VisibleForTesting
        AnimatedDyeStateTracker(AnimatedDye animatedDye) {
            if (animatedDye.delay() > 0.0f) {
                if (animatedDye.cycleBack()) {
                    this.onBackCycle = true;
                    this.progress = animatedDye.delay() / animatedDye.duration();
                } else {
                    this.progress = 1.0f - animatedDye.delay() / animatedDye.duration();
                }
                this.progress = AnimatedDyeStateTracker.clamp(this.progress);
            }
        }

        @VisibleForTesting
        int interpolate(AnimatedDye animatedDye, float deltaTicks) {
            int keyframe;
            this.update(animatedDye, deltaTicks);
            for (keyframe = 0; keyframe < animatedDye.keyframes.size() - 2 && animatedDye.keyframes.get((int)(keyframe + 1)).time < this.progress; ++keyframe) {
            }
            Keyframe current = this.onBackCycle ? animatedDye.keyframes.get(keyframe + 1) : animatedDye.keyframes.get(keyframe);
            Keyframe next = this.onBackCycle ? animatedDye.keyframes.get(keyframe) : animatedDye.keyframes.get(keyframe + 1);
            float colorProgress = (this.progress - current.time) / (next.time - current.time);
            colorProgress = AnimatedDyeStateTracker.clamp(colorProgress);
            this.lastColor = OkLabColor.interpolate(current.color, next.color, colorProgress);
            return this.lastColor;
        }

        private void update(AnimatedDye animatedDye, float deltaTicks) {
            float v = deltaTicks * 0.05f / animatedDye.duration;
            if (this.onBackCycle) {
                this.progress -= v;
                if (this.progress <= 0.0f) {
                    this.onBackCycle = false;
                    this.progress = Math.abs(this.progress);
                }
            } else {
                this.progress += v;
                if (this.progress >= 1.0f) {
                    if (animatedDye.cycleBack) {
                        this.onBackCycle = true;
                        this.progress = 2.0f - this.progress;
                    } else {
                        this.progress %= 1.0f;
                    }
                }
            }
            this.progress = AnimatedDyeStateTracker.clamp(this.progress);
        }

        private static float clamp(float progress) {
            return Math.clamp(progress, 0.0f, 1.0f);
        }
    }
}

