/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.custom.screen.name.CustomizeNameScreen;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1799;
import net.minecraft.class_2178;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CustomItemNames {
    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(CustomItemNames::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"custom").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"renameItem").executes(context -> CustomItemNames.openScreen((FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"textComponent", (ArgumentType)class_2178.method_9281((class_7157)registryAccess)).executes(context -> CustomItemNames.renameItem((FabricClientCommandSource)context.getSource(), (class_2561)context.getArgument("textComponent", class_2561.class))))).then(ClientCommandManager.argument((String)"basicText", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CustomItemNames.renameItem((FabricClientCommandSource)context.getSource(), class_2561.method_30163((String)((String)context.getArgument("basicText", String.class)))))))));
    }

    private static int openScreen(FabricClientCommandSource source) {
        if (!Utils.isOnSkyblock()) {
            source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.notOnSkyblock")));
            return 0;
        }
        class_1799 handStack = source.getPlayer().method_6047();
        if (handStack.method_7960()) {
            source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.noItem")));
            return 0;
        }
        if (handStack.getUuid().isEmpty()) {
            source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.noItemUuid")));
            return 0;
        }
        Scheduler.queueOpenScreen(new CustomizeNameScreen(handStack));
        return 1;
    }

    private static int renameItem(FabricClientCommandSource source, class_2561 text) {
        if (Utils.isOnSkyblock()) {
            String itemUuid = source.getPlayer().method_6047().getUuid();
            if (!itemUuid.isEmpty()) {
                SkyblockerConfigManager.update(config -> {
                    Object2ObjectOpenHashMap<String, class_2561> customItemNames = config.general.customItemNames;
                    class_2583 currentStyle = text.method_10866();
                    ((class_5250)text).method_10862(currentStyle.method_10978(Boolean.valueOf(currentStyle.method_10966())));
                    customItemNames.put((Object)itemUuid, (Object)text);
                });
                source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.added")));
            } else {
                source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.noItemUuid")));
            }
        } else {
            source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.notOnSkyblock")));
        }
        return 1;
    }
}

