/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom.screen;

import com.google.common.collect.ImmutableList;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.custom.CustomArmorAnimatedDyes;
import de.hysky.skyblocker.skyblock.item.custom.screen.CustomizeArmorScreen;
import de.hysky.skyblocker.utils.OkLabColor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import net.minecraft.class_9017;
import org.jetbrains.annotations.Nullable;

public class AnimatedDyeTimelineWidget
extends class_9017
implements Closeable {
    private static final class_2960 GRADIENT_TEXTURE = SkyblockerMod.id("generated/dye_gradient");
    private static final int HORIZONTAL_MARGIN = 3;
    private static final int VERTICAL_MARGIN = 1;
    private final class_1043 gradientTexture;
    private final int textureWidth;
    private final int textureHeight;
    private final FrameCallback frameCallback;
    private String uuid = "";
    private final ArrayList<KeyframeWidget> keyframes = new ArrayList();
    @Nullable
    private KeyframeWidget focusedFrame = null;
    private int deletedIndex = -1;

    public AnimatedDyeTimelineWidget(int x, int y, int width, int height, FrameCallback frameCallback) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Animated Dye Timeline"));
        this.gradientTexture = new class_1043("TimelineGradient", width - 6, height - 2, true);
        assert (this.gradientTexture.method_4525() != null);
        this.textureWidth = this.gradientTexture.method_4525().method_4307();
        this.textureHeight = this.gradientTexture.method_4525().method_4323();
        class_310.method_1551().method_1531().method_4616(GRADIENT_TEXTURE, (class_1044)this.gradientTexture);
        this.frameCallback = frameCallback;
    }

    public List<? extends class_364> method_25396() {
        return this.keyframes;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25302(class_10799.field_56883, GRADIENT_TEXTURE, this.method_46426() + 3, this.method_46427() + 1, 0.0f, 0.0f, this.method_25368() - 6, this.method_25364() - 2, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
        for (KeyframeWidget frame : this.keyframes) {
            frame.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        if (focused instanceof KeyframeWidget) {
            KeyframeWidget keyframe = (KeyframeWidget)focused;
            this.frameCallback.onFrameSelected(keyframe.color, keyframe.time);
            this.focusedFrame = keyframe;
        }
    }

    public void setAnimatedDye(String uuid) {
        this.uuid = uuid;
        CustomArmorAnimatedDyes.AnimatedDye dye = (CustomArmorAnimatedDyes.AnimatedDye)SkyblockerConfigManager.get().general.customAnimatedDyes.get((Object)uuid);
        this.keyframes.clear();
        this.keyframes.ensureCapacity(dye.keyframes().size());
        for (int i = 0; i < dye.keyframes().size(); ++i) {
            CustomArmorAnimatedDyes.Keyframe keyframe = dye.keyframes().get(i);
            this.keyframes.add(new KeyframeWidget(keyframe.color(), keyframe.time(), i != 0 && i != dye.keyframes().size() - 1));
        }
        this.method_25395((class_364)this.keyframes.getFirst());
        this.createGradientTexture();
    }

    private void createGradientTexture() {
        class_1011 image = this.gradientTexture.method_4525();
        assert (image != null);
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.keyframes.size() - 1; ++i) {
            KeyframeWidget frame = this.keyframes.get(i);
            KeyframeWidget nextFrame = this.keyframes.get(i + 1);
            int startX = (int)((float)(image.method_4307() - 1) * frame.time);
            int endX = (int)((float)(image.method_4307() - 1) * nextFrame.time);
            int size = endX - startX;
            for (int x = 0; x <= size; ++x) {
                int color = OkLabColor.interpolate(frame.color, nextFrame.color, (float)x / (float)size);
                for (int y = 0; y < image.method_4323(); ++y) {
                    image.method_61941(x + startX, y, color | 0xFF000000);
                }
            }
        }
        double v = (double)(System.currentTimeMillis() - l) / 1000.0;
        CustomizeArmorScreen.LOGGER.debug("Time taken to generate gradient texture: {}s", (Object)v);
        this.gradientTexture.method_4524();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean b = super.method_25402(mouseX, mouseY, button);
        if (b) {
            if (this.deletedIndex != -1) {
                this.method_25395((class_364)this.keyframes.get(this.deletedIndex));
                this.deletedIndex = -1;
            }
            return true;
        }
        if (this.method_25405(mouseX, mouseY)) {
            KeyframeWidget e = new KeyframeWidget(-65536, (float)((mouseX -= (double)(this.method_46426() + 3)) / (double)(this.method_25368() - 6 - 1)), true);
            this.keyframes.add(e);
            this.method_25395((class_364)e);
            this.dataChanged();
            return true;
        }
        return false;
    }

    public void setColor(int argb) {
        if (this.focusedFrame == null) {
            CustomizeArmorScreen.LOGGER.warn("Tried to set color when no frame was focused");
            return;
        }
        this.focusedFrame.color = argb;
        this.dataChanged();
    }

    private void dataChanged() {
        this.keyframes.sort(Comparator.comparingDouble(f -> f.time));
        this.createGradientTexture();
        ImmutableList configFrames = ImmutableList.copyOf(this.keyframes.stream().map(keyframe -> new CustomArmorAnimatedDyes.Keyframe(keyframe.color, keyframe.time)).toList());
        CustomArmorAnimatedDyes.AnimatedDye dye = (CustomArmorAnimatedDyes.AnimatedDye)SkyblockerConfigManager.get().general.customAnimatedDyes.get((Object)this.uuid);
        CustomArmorAnimatedDyes.AnimatedDye newDye = new CustomArmorAnimatedDyes.AnimatedDye((List<CustomArmorAnimatedDyes.Keyframe>)configFrames, dye.cycleBack(), dye.delay(), dye.duration());
        SkyblockerConfigManager.get().general.customAnimatedDyes.put((Object)this.uuid, (Object)newDye);
    }

    protected void method_47399(class_6382 builder) {
    }

    protected int method_44395() {
        return this.method_25364();
    }

    protected double method_44393() {
        return 0.0;
    }

    @Override
    public void close() {
        this.gradientTexture.close();
    }

    private class KeyframeWidget
    extends class_339 {
        int color;
        float time;
        private final boolean draggable;
        private boolean dragging;

        private KeyframeWidget(int color, float time, boolean draggable) {
            super(0, AnimatedDyeTimelineWidget.this.method_46427(), 7, AnimatedDyeTimelineWidget.this.method_25364(), (class_2561)class_2561.method_43470((String)"Keyframe"));
            this.dragging = false;
            this.draggable = draggable;
            this.color = color;
            this.time = time;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), this.color);
            context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.method_25370() ? -1 : -8355712);
        }

        public int method_46426() {
            AnimatedDyeTimelineWidget parent = AnimatedDyeTimelineWidget.this;
            return (int)((float)(parent.method_46426() + 3) + this.time * (float)(parent.method_25368() - 6 - 1)) - 3;
        }

        protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
            super.method_25349(mouseX, mouseY, deltaX, deltaY);
            if (!this.draggable) {
                return;
            }
            AnimatedDyeTimelineWidget parent = AnimatedDyeTimelineWidget.this;
            float v = (float)((mouseX -= (double)(parent.method_46426() + 3)) / (double)(parent.method_25368() - 6 - 1));
            this.time = Math.clamp(v, 0.0f, 1.0f);
            this.dragging = true;
        }

        public void method_25357(double mouseX, double mouseY) {
            super.method_25357(mouseX, mouseY);
            if (this.dragging) {
                AnimatedDyeTimelineWidget.this.dataChanged();
            }
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 261) {
                this.deleteThis(false);
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 1 && this.method_25405(mouseX, mouseY)) {
                this.deleteThis(true);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        private void deleteThis(boolean mouse) {
            if (!this.draggable) {
                return;
            }
            int i = AnimatedDyeTimelineWidget.this.keyframes.indexOf((Object)this);
            AnimatedDyeTimelineWidget.this.method_25395((class_364)AnimatedDyeTimelineWidget.this.keyframes.get(i + 1));
            if (mouse) {
                AnimatedDyeTimelineWidget.this.deletedIndex = i;
            }
            AnimatedDyeTimelineWidget.this.keyframes.remove((Object)this);
            AnimatedDyeTimelineWidget.this.dataChanged();
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    public static interface FrameCallback {
        public void onFrameSelected(int var1, float var2);
    }
}

