/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom.screen;

import com.demonwav.mcdev.annotations.Translatable;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.mixins.accessors.CheckboxWidgetAccessor;
import de.hysky.skyblocker.skyblock.item.custom.CustomArmorAnimatedDyes;
import de.hysky.skyblocker.skyblock.item.custom.screen.AnimatedDyeTimelineWidget;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.render.gui.ARGBTextInput;
import de.hysky.skyblocker.utils.render.gui.ColorPickerWidget;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.io.Closeable;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3489;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_9017;
import net.minecraft.class_9282;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class ColorSelectionWidget
extends class_9017
implements Closeable {
    private static final class_2960 INNER_SPACE_TEXTURE = SkyblockerMod.id("menu_inner_space");
    private static final class_2561 RESET_COLOR_TEXT = class_2561.method_43471((String)"skyblocker.armorCustomization.resetColor");
    private static final class_2561 CANNOT_CUSTOMIZE_COLOR_TEXT = class_2561.method_43471((String)"skyblocker.armorCustomization.cannotCustomizeColor");
    private static final class_2561 ANIMATED_TEXT = class_2561.method_43471((String)"skyblocker.armorCustomization.animated");
    private static final class_2561 CYCLE_BACK_TEXT = class_2561.method_43471((String)"skyblocker.armorCustomization.cycleBack");
    private static final class_2561 DURATION_TOOLTIP_TEXT = class_2561.method_43471((String)"skyblocker.armorCustomization.durationTooltip");
    private static final class_2561 DELAY_TOOLTIP_TEXT = class_2561.method_43471((String)"skyblocker.armorCustomization.delayTooltip");
    private static final String DURATION_TEXT = "skyblocker.armorCustomization.duration";
    private static final String DELAY_TEXT = "skyblocker.armorCustomization.delay";
    private final ColorPickerWidget colorPicker;
    private final ARGBTextInput argbTextInput;
    private final AnimatedDyeTimelineWidget timelineWidget;
    private final class_4286 cycleBackCheckbox;
    private final Slider delaySlider;
    private final Slider durationSlider;
    private final class_4185 resetColorButton;
    private final class_4286 animatedCheckbox;
    private final class_7842 notCustomizableText;
    private class_1799 currentItem;
    private boolean animated;
    private boolean customizable = false;
    private final List<class_339> children;

    public ColorSelectionWidget(int x, int y, int width, int height, class_327 textRenderer) {
        super(x, y, width, height, class_2561.method_30163((String)"ColorSelectionWidget"));
        int durationY;
        int durationX;
        int height1 = Math.min(Math.min(2 * height / 3, width / 5), height - 40);
        this.colorPicker = new ColorPickerWidget(x + 3, y + 3, height1 * 2, height1);
        this.colorPicker.setOnColorChange(this::onPickerColorChanged);
        this.argbTextInput = new ARGBTextInput(0, y + 3, textRenderer, true);
        this.argbTextInput.method_46421(this.colorPicker.method_55442() + 5);
        this.argbTextInput.setOnChange(this::onTextInputColorChanged);
        this.timelineWidget = new AnimatedDyeTimelineWidget(this.method_46426() + 3, this.method_55443() - 18, this.method_25368() - 6, 15, this::onTimelineFrameSelected);
        this.resetColorButton = class_4185.method_46430((class_2561)RESET_COLOR_TEXT, this::onRemoveCustomColor).method_46432(Math.min(150, x + width - this.argbTextInput.method_55442() - 5)).method_46431();
        this.resetColorButton.method_48229(this.method_55442() - this.resetColorButton.method_25368() - 3, this.method_46427() + 3);
        this.notCustomizableText = new class_7842(CANNOT_CUSTOMIZE_COLOR_TEXT, textRenderer);
        class_7843.method_46442((class_8021)this.notCustomizableText, (int)this.method_46426(), (int)this.method_46427(), (int)this.method_25368(), (int)this.method_25364());
        this.animatedCheckbox = class_4286.method_54787((class_2561)ANIMATED_TEXT, (class_327)textRenderer).method_54789(this.colorPicker.method_55442() + 5, this.resetColorButton.method_55443()).method_61131(80).method_54791(this::onAnimatedCheckbox).method_54788();
        this.cycleBackCheckbox = class_4286.method_54787((class_2561)CYCLE_BACK_TEXT, (class_327)textRenderer).method_54789(this.colorPicker.method_55442() + 5, this.animatedCheckbox.method_55443() + 3).method_61131(80).method_54791(this::onCycleBackCheckbox).method_54788();
        int sliderWidth = (int)((float)width * 0.35f);
        boolean vertical = this.method_55442() - sliderWidth - 3 > Math.max(this.animatedCheckbox.method_55442(), this.cycleBackCheckbox.method_55442());
        int sliderY = vertical ? this.resetColorButton.method_55443() + 3 : this.timelineWidget.method_46427() - 17;
        this.delaySlider = new Slider(this.method_55442() - sliderWidth - 3, sliderY, sliderWidth, 0.0f, 2.0f, 0.02f, true, DELAY_TEXT, f -> {
            String itemUuid = this.currentItem.getUuid();
            CustomArmorAnimatedDyes.AnimatedDye dye = (CustomArmorAnimatedDyes.AnimatedDye)SkyblockerConfigManager.get().general.customAnimatedDyes.get((Object)itemUuid);
            CustomArmorAnimatedDyes.AnimatedDye newDye = new CustomArmorAnimatedDyes.AnimatedDye(dye.keyframes(), dye.cycleBack(), f, dye.duration());
            SkyblockerConfigManager.get().general.customAnimatedDyes.put((Object)itemUuid, (Object)newDye);
        });
        this.delaySlider.method_47400(class_7919.method_47407((class_2561)DELAY_TOOLTIP_TEXT));
        if (vertical) {
            durationX = this.delaySlider.method_46426();
            durationY = this.delaySlider.method_55443() + 3;
        } else {
            durationX = this.delaySlider.method_46426() - sliderWidth - 3;
            durationY = this.delaySlider.method_46427();
        }
        this.durationSlider = new Slider(durationX, durationY, sliderWidth, 0.1f, 10.0f, 0.1f, true, DURATION_TEXT, f -> {
            String itemUuid = this.currentItem.getUuid();
            CustomArmorAnimatedDyes.AnimatedDye dye = (CustomArmorAnimatedDyes.AnimatedDye)SkyblockerConfigManager.get().general.customAnimatedDyes.get((Object)itemUuid);
            CustomArmorAnimatedDyes.AnimatedDye newDye = new CustomArmorAnimatedDyes.AnimatedDye(dye.keyframes(), dye.cycleBack(), dye.delay(), f);
            SkyblockerConfigManager.get().general.customAnimatedDyes.put((Object)itemUuid, (Object)newDye);
        });
        this.durationSlider.method_47400(class_7919.method_47407((class_2561)DURATION_TOOLTIP_TEXT));
        this.children = List.of(this.colorPicker, this.argbTextInput, this.timelineWidget, this.resetColorButton, this.animatedCheckbox, this.notCustomizableText, this.cycleBackCheckbox, this.delaySlider, this.durationSlider);
    }

    private void onPickerColorChanged(int argb, boolean release) {
        this.argbTextInput.setARGBColor(argb);
        if (!this.animated) {
            SkyblockerConfigManager.get().general.customDyeColors.put((Object)this.currentItem.getUuid(), class_9848.method_61334((int)argb));
        } else if (release) {
            this.timelineWidget.setColor(argb);
        }
    }

    private void onTextInputColorChanged(int argb) {
        this.colorPicker.setRGBColor(argb);
        if (this.animated) {
            this.timelineWidget.setColor(argb);
        } else {
            SkyblockerConfigManager.get().general.customDyeColors.put((Object)this.currentItem.getUuid(), class_9848.method_61334((int)argb));
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.method_19355(mouseX, mouseY).filter(element -> element.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)).isPresent() || super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void onTimelineFrameSelected(int color, float time) {
        this.argbTextInput.setARGBColor(color);
        this.colorPicker.setRGBColor(color);
    }

    private void onRemoveCustomColor(class_4185 button) {
        this.animated = false;
        ((CheckboxWidgetAccessor)this.animatedCheckbox).setChecked(false);
        this.changeVisibilities();
        String itemUuid = this.currentItem.getUuid();
        SkyblockerConfigManager.get().general.customDyeColors.removeInt((Object)itemUuid);
        SkyblockerConfigManager.get().general.customAnimatedDyes.remove((Object)itemUuid);
        int color = class_9282.method_57470((class_1799)this.currentItem, (int)-1);
        this.argbTextInput.setARGBColor(color);
        this.colorPicker.setRGBColor(color);
    }

    private void onAnimatedCheckbox(class_4286 checkbox, boolean checked) {
        this.animated = checked;
        this.changeVisibilities();
        String itemUuid = this.currentItem.getUuid();
        if (this.animated) {
            SkyblockerConfigManager.get().general.customAnimatedDyes.put((Object)itemUuid, (Object)new CustomArmorAnimatedDyes.AnimatedDye(List.of(new CustomArmorAnimatedDyes.Keyframe(-65536, 0.0f), new CustomArmorAnimatedDyes.Keyframe(-16776961, 1.0f)), true, 0.0f, 1.0f));
            this.timelineWidget.setAnimatedDye(itemUuid);
            this.delaySlider.setValue(0.0f);
            this.durationSlider.setValue(1.0f);
            ((CheckboxWidgetAccessor)this.cycleBackCheckbox).setChecked(true);
        } else {
            int color = SkyblockerConfigManager.get().general.customDyeColors.getOrDefault((Object)itemUuid, class_9282.method_57470((class_1799)this.currentItem, (int)-1));
            this.colorPicker.setRGBColor(color);
            this.argbTextInput.setARGBColor(color);
            SkyblockerConfigManager.get().general.customAnimatedDyes.remove((Object)itemUuid);
        }
    }

    private void onCycleBackCheckbox(class_4286 checkbox, boolean checked) {
        String itemUuid = this.currentItem.getUuid();
        CustomArmorAnimatedDyes.AnimatedDye dye = (CustomArmorAnimatedDyes.AnimatedDye)SkyblockerConfigManager.get().general.customAnimatedDyes.get((Object)itemUuid);
        CustomArmorAnimatedDyes.AnimatedDye newDye = new CustomArmorAnimatedDyes.AnimatedDye(dye.keyframes(), checked, dye.delay(), dye.duration());
        SkyblockerConfigManager.get().general.customAnimatedDyes.put((Object)itemUuid, (Object)newDye);
    }

    private void changeVisibilities() {
        this.colorPicker.field_22764 = this.customizable;
        this.argbTextInput.field_22764 = this.customizable;
        this.timelineWidget.field_22764 = this.customizable && this.animated;
        this.cycleBackCheckbox.field_22764 = this.customizable && this.animated;
        this.delaySlider.field_22764 = this.customizable && this.animated;
        this.durationSlider.field_22764 = this.customizable && this.animated;
        this.resetColorButton.field_22764 = this.customizable;
        this.animatedCheckbox.field_22764 = this.customizable;
        this.notCustomizableText.field_22764 = !this.customizable;
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    protected int method_44395() {
        return 0;
    }

    protected double method_44393() {
        return 0.0;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_52706(class_10799.field_56883, INNER_SPACE_TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        for (class_339 child : this.children) {
            child.method_25394(context, mouseX, mouseY, delta);
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!super.method_25402(mouseX, mouseY, button)) {
            this.method_25395(null);
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.timelineWidget.close();
    }

    public void setCurrentItem(@NotNull class_1799 currentItem) {
        this.currentItem = currentItem;
        String itemUuid = currentItem.getUuid();
        this.customizable = currentItem.method_31573(class_3489.field_48803);
        if (!this.customizable) {
            this.animated = false;
            ((CheckboxWidgetAccessor)this.animatedCheckbox).setChecked(false);
            this.changeVisibilities();
            return;
        }
        if (SkyblockerConfigManager.get().general.customAnimatedDyes.containsKey((Object)itemUuid)) {
            this.animated = true;
            CustomArmorAnimatedDyes.AnimatedDye animatedDye = (CustomArmorAnimatedDyes.AnimatedDye)SkyblockerConfigManager.get().general.customAnimatedDyes.get((Object)itemUuid);
            ((CheckboxWidgetAccessor)this.cycleBackCheckbox).setChecked(animatedDye.cycleBack());
            this.delaySlider.setValue(animatedDye.delay());
            this.durationSlider.setValue(animatedDye.duration());
            this.timelineWidget.setAnimatedDye(itemUuid);
        } else if (SkyblockerConfigManager.get().general.customDyeColors.containsKey((Object)itemUuid)) {
            this.animated = false;
            int color = SkyblockerConfigManager.get().general.customDyeColors.getInt((Object)itemUuid);
            this.argbTextInput.setARGBColor(color);
            this.colorPicker.setRGBColor(color);
        } else {
            this.animated = false;
            int color = class_9282.method_57470((class_1799)currentItem, (int)-1);
            this.argbTextInput.setARGBColor(color);
            this.colorPicker.setRGBColor(color);
        }
        this.changeVisibilities();
        ((CheckboxWidgetAccessor)this.animatedCheckbox).setChecked(this.animated);
    }

    private static class Slider
    extends class_357 {
        private final float minValue;
        private final float maxValue;
        private final float step;
        private final boolean linear;
        private final String translatable;
        private final FloatConsumer onValueChanged;
        private boolean clicked = false;

        private Slider(int x, int y, int width, float min, float max, float step, boolean linear, @Translatable String translatable, FloatConsumer onValueChanged) {
            super(x, y, width, 15, (class_2561)class_2561.method_43473(), 0.0);
            if (min >= max || step <= 0.0f || step > max - min) {
                throw new IllegalArgumentException("Invalid slider parameters: min=" + min + ", max=" + max + ", step=" + step);
            }
            this.minValue = min;
            this.maxValue = max;
            this.step = step;
            this.linear = linear;
            this.translatable = translatable;
            this.onValueChanged = onValueChanged;
            this.method_25346();
        }

        private float trueValue() {
            double v = this.linear ? this.field_22753 : this.field_22753 * this.field_22753;
            return this.roundToStep(v * (double)(this.maxValue - this.minValue));
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43469((String)this.translatable, (Object[])new Object[]{Formatters.DOUBLE_NUMBERS.format(this.trueValue())}));
        }

        private void setValue(float val) {
            float v = (val - this.minValue) / (this.maxValue - this.minValue);
            this.field_22753 = this.linear ? (double)v : Math.sqrt(v);
            this.method_25346();
        }

        public void method_25348(double mouseX, double mouseY) {
            super.method_25348(mouseX, mouseY);
            this.clicked = true;
        }

        public void method_25357(double mouseX, double mouseY) {
            super.method_25357(mouseX, mouseY);
            if (this.clicked) {
                this.onValueChanged.accept(this.trueValue());
                this.clicked = false;
            }
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (super.method_25404(keyCode, scanCode, modifiers)) {
                this.onValueChanged.accept(this.trueValue());
                return true;
            }
            return false;
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (verticalAmount == 0.0) {
                return false;
            }
            float offset = verticalAmount > 0.0 ? this.step : -this.step;
            this.setValue(Math.clamp(this.trueValue() + offset, this.minValue, this.maxValue));
            this.onValueChanged.accept(this.trueValue());
            return true;
        }

        protected void method_25344() {
        }

        private float roundToStep(double value) {
            return Math.clamp(this.minValue + this.step * (float)Math.round(value / (double)this.step), this.minValue, this.maxValue);
        }
    }
}

