/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom.screen;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.injected.RecipeBookHolder;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.skyblock.item.custom.CustomArmorAnimatedDyes;
import de.hysky.skyblocker.skyblock.item.custom.CustomArmorTrims;
import de.hysky.skyblocker.skyblock.item.custom.screen.ColorSelectionWidget;
import de.hysky.skyblocker.skyblock.item.custom.screen.HeadSelectionWidget;
import de.hysky.skyblocker.skyblock.item.custom.screen.PlayerWidget;
import de.hysky.skyblocker.skyblock.item.custom.screen.TrimSelectionWidget;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_10799;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3489;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_6382;
import net.minecraft.class_742;
import net.minecraft.class_745;
import org.slf4j.Logger;

public class CustomizeArmorScreen
extends class_437 {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_1304[] ARMOR_SLOTS = (class_1304[])class_1304.field_54086.stream().filter(slot -> slot.method_5925() == class_1304.class_1305.field_6178).toArray(class_1304[]::new);
    private static final class_1799 BARRIER = new class_1799((class_1935)class_1802.field_8077);
    private final class_745 player;
    private final class_1799[] armor;
    private int selectedSlot;
    private TrimSelectionWidget trimSelectionWidget;
    private ColorSelectionWidget colorSelectionWidget;
    private HeadSelectionWidget headSelectionWidget;
    private final class_437 previousScreen;
    private final Map<String, PreviousConfig> previousConfigs;
    private final boolean nothingCustomizable;

    @Init
    public static void initThings() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"custom").executes(Scheduler.queueOpenScreenCommand(() -> new CustomizeArmorScreen(null))))));
        ScreenEvents.AFTER_INIT.register((client1, screen, scaledWidth, scaledHeight) -> {
            if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().uiAndVisuals.showCustomizeButton && screen instanceof class_490) {
                class_490 inventoryScreen = (class_490)screen;
                CustomizeButton button = new CustomizeButton(((HandledScreenAccessor)inventoryScreen).getX() + 63, ((HandledScreenAccessor)inventoryScreen).getY() + 10);
                Screens.getButtons((class_437)inventoryScreen).add(button);
                ((RecipeBookHolder)inventoryScreen).registerRecipeBookToggleCallback(() -> button.method_48229(((HandledScreenAccessor)inventoryScreen).getX() + 63, ((HandledScreenAccessor)inventoryScreen).getY() + 10));
            }
        });
    }

    static boolean canEdit(class_1799 stack) {
        boolean hasUuid;
        boolean bl = hasUuid = !stack.getUuid().isEmpty();
        if (stack.method_31574(class_1802.field_8575)) {
            return hasUuid;
        }
        return stack.method_31573(class_3489.field_41890) && hasUuid;
    }

    protected CustomizeArmorScreen(class_437 previousScreen) {
        super((class_2561)(Math.random() < 0.01 ? class_2561.method_43471((String)"skyblocker.armorCustomization.titleSecret") : class_2561.method_43471((String)"skyblocker.armorCustomization.title")));
        this.player = new class_745(this, CustomizeArmorScreen.CLIENT.field_1687, CLIENT.method_53462()){

            public boolean method_5756(class_1657 player) {
                return true;
            }

            public void method_6116(class_1304 slot, class_1799 oldStack, class_1799 newStack) {
            }
        };
        this.armor = new class_1799[4];
        this.selectedSlot = 0;
        List<class_1799> list = ItemUtils.getArmor((class_1309)CustomizeArmorScreen.CLIENT.field_1724);
        for (int i = 0; i < list.size(); ++i) {
            class_1799 copy;
            this.armor[3 - i] = copy = list.get(i).method_7972();
            this.player.method_5673(ARMOR_SLOTS[i], copy);
        }
        while (this.selectedSlot < this.armor.length - 1 && !CustomizeArmorScreen.canEdit(this.armor[this.selectedSlot])) {
            ++this.selectedSlot;
        }
        this.previousScreen = previousScreen;
        this.nothingCustomizable = !CustomizeArmorScreen.canEdit(this.armor[this.selectedSlot]);
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)4);
        for (class_1799 stack : this.armor) {
            String uuid;
            if (!CustomizeArmorScreen.canEdit(stack)) continue;
            builder.put((Object)uuid, (Object)new PreviousConfig(SkyblockerConfigManager.get().general.customArmorTrims.containsKey((Object)(uuid = stack.getUuid())) ? Optional.of((CustomArmorTrims.ArmorTrimId)SkyblockerConfigManager.get().general.customArmorTrims.get((Object)uuid)) : Optional.empty(), SkyblockerConfigManager.get().general.customDyeColors.containsKey((Object)uuid) ? OptionalInt.of(SkyblockerConfigManager.get().general.customDyeColors.getInt((Object)uuid)) : OptionalInt.empty(), SkyblockerConfigManager.get().general.customAnimatedDyes.containsKey((Object)uuid) ? Optional.of((CustomArmorAnimatedDyes.AnimatedDye)SkyblockerConfigManager.get().general.customAnimatedDyes.get((Object)uuid)) : Optional.empty(), SkyblockerConfigManager.get().general.customHelmetTextures.containsKey((Object)uuid) ? Optional.of((String)SkyblockerConfigManager.get().general.customHelmetTextures.get((Object)uuid)) : Optional.empty()));
        }
        this.previousConfigs = builder.build();
    }

    public void method_25393() {
        ++this.player.field_6012;
    }

    protected void method_25426() {
        super.method_25426();
        int w = Math.min(460, this.field_22789);
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - 190) / 2;
        PlayerWidget playerWidget = new PlayerWidget(x + 8, y, 84, 165, (class_742)this.player);
        this.method_37063((class_364)playerWidget);
        PieceSelectionWidget pieceSelectionWidget = new PieceSelectionWidget(playerWidget.method_46426(), playerWidget.method_55443() + 1);
        this.method_37063((class_364)pieceSelectionWidget);
        if (!this.nothingCustomizable) {
            this.headSelectionWidget = new HeadSelectionWidget(x + 105, y, w - 105 - 5, 165);
            this.method_37063((class_364)this.headSelectionWidget);
            this.trimSelectionWidget = new TrimSelectionWidget(x + 105, y, w - 105 - 5, 80);
            this.method_37063((class_364)this.trimSelectionWidget);
            if (this.colorSelectionWidget != null) {
                this.colorSelectionWidget.close();
            }
            this.colorSelectionWidget = new ColorSelectionWidget(this.trimSelectionWidget.method_46426(), this.trimSelectionWidget.method_55443() + 10, this.trimSelectionWidget.method_25368(), 100, this.field_22793);
            this.method_37063((class_364)this.colorSelectionWidget);
            this.updateWidgets();
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), b -> this.cancel()).method_46433(this.field_22789 / 2 - 155, this.field_22790 - 25).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.method_25419()).method_46433(this.field_22789 / 2 + 5, this.field_22790 - 25).method_46431());
    }

    private void cancel() {
        this.previousConfigs.forEach((uuid, previousConfig) -> {
            previousConfig.armorTrimId().ifPresentOrElse(trim -> SkyblockerConfigManager.get().general.customArmorTrims.put(uuid, trim), () -> SkyblockerConfigManager.get().general.customArmorTrims.remove(uuid));
            previousConfig.color().ifPresentOrElse(i -> SkyblockerConfigManager.get().general.customDyeColors.put(uuid, i), () -> SkyblockerConfigManager.get().general.customDyeColors.removeInt(uuid));
            previousConfig.animatedDye().ifPresentOrElse(animatedDye -> SkyblockerConfigManager.get().general.customAnimatedDyes.put(uuid, animatedDye), () -> SkyblockerConfigManager.get().general.customAnimatedDyes.remove(uuid));
            previousConfig.helmetTexture().ifPresentOrElse(tex -> SkyblockerConfigManager.get().general.customHelmetTextures.put(uuid, tex), () -> SkyblockerConfigManager.get().general.customHelmetTextures.remove(uuid));
        });
        this.method_25419();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, 5, -1);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25432() {
        super.method_25432();
        SkyblockerConfigManager.update(config -> {});
        if (this.colorSelectionWidget != null) {
            this.colorSelectionWidget.close();
        }
        CustomArmorAnimatedDyes.cleanTrackers();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.previousScreen);
    }

    private void updateWidgets() {
        if (this.nothingCustomizable) {
            return;
        }
        class_1799 item = this.armor[this.selectedSlot];
        boolean isPlayerHead = item.method_31574(class_1802.field_8575);
        this.headSelectionWidget.setCurrentItem(item);
        this.trimSelectionWidget.setCurrentItem(item);
        this.colorSelectionWidget.setCurrentItem(item);
        this.headSelectionWidget.field_22764 = isPlayerHead;
        this.trimSelectionWidget.field_22764 = !isPlayerHead;
        this.colorSelectionWidget.field_22764 = !isPlayerHead;
    }

    private record PreviousConfig(Optional<CustomArmorTrims.ArmorTrimId> armorTrimId, OptionalInt color, Optional<CustomArmorAnimatedDyes.AnimatedDye> animatedDye, Optional<String> helmetTexture) {
    }

    private class PieceSelectionWidget
    extends class_339 {
        private static final class_2960 HOTBAR_TEXTURE = SkyblockerMod.id("armor_customization_screen/mini_hotbar");
        private static final class_2960 HOTBAR_SELECTION_TEXTURE = SkyblockerMod.id("hotbar_selection_full");
        private final boolean[] selectable;

        private PieceSelectionWidget(int x, int y) {
            super(x, y, 84, 24, class_2561.method_30163((String)""));
            this.selectable = new boolean[CustomizeArmorScreen.this.armor.length];
            for (int i = 0; i < CustomizeArmorScreen.this.armor.length; ++i) {
                this.selectable[i] = CustomizeArmorScreen.canEdit(CustomizeArmorScreen.this.armor[i]);
            }
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int i;
            context.method_52706(class_10799.field_56883, HOTBAR_TEXTURE, this.method_46426() + 1, this.method_46427() + 1, 82, 22);
            int hoveredSlot = -1;
            int localX = mouseX - this.method_46426() - 2;
            int localY = mouseY - this.method_46427() - 2;
            if (localY >= 0 && localY < 20) {
                int n = hoveredSlot = localX / 20 >= CustomizeArmorScreen.this.armor.length ? -1 : localX / 20;
            }
            if (hoveredSlot >= 0 && this.selectable[hoveredSlot]) {
                i = this.method_46426() + 2 + hoveredSlot * 20;
                context.method_25294(i, this.method_46427() + 2, i + 20, this.method_46427() + 22, 0x20FFFFFF);
            }
            for (i = 0; i < CustomizeArmorScreen.this.armor.length; ++i) {
                context.method_51427(CustomizeArmorScreen.this.armor[i], this.method_46426() + 4 + i * 20, this.method_46427() + 4);
                if (this.selectable[i]) continue;
                context.method_51427(BARRIER, this.method_46426() + 4 + i * 20, this.method_46427() + 4);
            }
            context.method_52706(class_10799.field_56883, HOTBAR_SELECTION_TEXTURE, this.method_46426() + CustomizeArmorScreen.this.selectedSlot * 20, this.method_46427(), 24, 24);
        }

        public void method_25348(double mouseX, double mouseY) {
            double localX = mouseX - (double)this.method_46426() - 2.0;
            double localY = mouseY - (double)this.method_46427() - 2.0;
            if (localY < 0.0 || localY >= 20.0) {
                return;
            }
            int i = (int)(localX / 20.0);
            if (i < 0 || i >= CustomizeArmorScreen.this.armor.length || !this.selectable[i]) {
                return;
            }
            if (i != CustomizeArmorScreen.this.selectedSlot) {
                CustomizeArmorScreen.this.selectedSlot = i;
                CustomizeArmorScreen.this.updateWidgets();
            }
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return this.field_22763 && this.field_22764 && mouseX >= (double)(this.method_46426() + 2) && mouseY >= (double)(this.method_46427() + 2) && mouseX < (double)(this.method_55442() - 2) && mouseY < (double)(this.method_55443() - 2);
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    private static class CustomizeButton
    extends class_339 {
        private static final class_2960 TEXTURE = SkyblockerMod.id("armor_customization_screen/button");

        private CustomizeButton(int x, int y) {
            super(x, y, 10, 10, (class_2561)class_2561.method_43473());
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_52707(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.method_49606() ? -329066 : -2130706433);
        }

        public void method_25348(double mouseX, double mouseY) {
            CLIENT.method_1507((class_437)new CustomizeArmorScreen(CustomizeArmorScreen.CLIENT.field_1755));
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

