/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom.screen;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.custom.CustomHelmetTextures;
import de.hysky.skyblocker.skyblock.profileviewer.utils.ProfileViewerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import net.minecraft.class_9017;
import org.jetbrains.annotations.NotNull;

public class HeadSelectionWidget
extends class_9017 {
    private static final class_2960 INNER_SPACE_TEXTURE = SkyblockerMod.id("menu_inner_space");
    private final List<HeadButton> allButtons = new ArrayList<HeadButton>();
    private final List<HeadButton> visibleButtons = new ArrayList<HeadButton>();
    private final class_342 searchField;
    private final HeadButton noneButton;
    private int buttonsPerRow = 1;
    private class_1799 currentItem;
    private String selectedTexture;

    public HeadSelectionWidget(int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_30163((String)"HeadSelection"));
        this.searchField = new class_342(class_310.method_1551().field_1772, x + 3, y + 3, width - 6, 12, (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"));
        this.searchField.method_1863(this::filterButtons);
        for (CustomHelmetTextures.NamedTexture tex : CustomHelmetTextures.getTextures()) {
            class_1799 head = ProfileViewerUtils.createSkull(tex.texture());
            HeadButton button = new HeadButton(tex.name(), tex.texture(), head, () -> this.onClick(tex.texture()));
            this.allButtons.add(button);
        }
        this.noneButton = new HeadButton("", null, new class_1799((class_1935)class_1802.field_8077), () -> this.onClick(null));
        this.filterButtons("");
    }

    private void layoutButtons() {
        this.buttonsPerRow = Math.max(1, (this.method_25368() - 6) / 20);
        int startY = this.searchField.method_55443() + 3;
        for (int i = 0; i < this.visibleButtons.size(); ++i) {
            HeadButton button = this.visibleButtons.get(i);
            button.method_48229(this.method_46426() + 3 + i % this.buttonsPerRow * 20, startY + i / this.buttonsPerRow * 20);
        }
    }

    private void onClick(String texture) {
        this.selectedTexture = texture;
        this.updateConfig();
        this.updateButtons();
    }

    private void updateConfig() {
        if (this.currentItem == null) {
            return;
        }
        String uuid = this.currentItem.getUuid();
        if (this.selectedTexture == null) {
            SkyblockerConfigManager.get().general.customHelmetTextures.remove((Object)uuid);
        } else {
            SkyblockerConfigManager.get().general.customHelmetTextures.put((Object)uuid, (Object)this.selectedTexture);
        }
    }

    private void updateButtons() {
        for (HeadButton b : this.allButtons) {
            b.selected = Objects.equals(b.texture, this.selectedTexture);
        }
        this.noneButton.selected = this.selectedTexture == null;
    }

    private void filterButtons(String search) {
        this.method_44382(0.0);
        String s = search.toLowerCase(Locale.ENGLISH);
        this.visibleButtons.clear();
        this.visibleButtons.add(this.noneButton);
        for (HeadButton b : this.allButtons) {
            if (!b.name.toLowerCase(Locale.ENGLISH).contains(s)) continue;
            this.visibleButtons.add(b);
        }
        this.layoutButtons();
        this.updateButtons();
    }

    public List<? extends class_364> method_25396() {
        int startY = this.searchField.method_55443() + 3;
        int endY = this.method_46427() + this.method_25364() - 2;
        int scrollY = (int)this.method_44387();
        ArrayList<HeadButton> list = new ArrayList<HeadButton>();
        for (HeadButton b : this.visibleButtons) {
            int y = b.method_46427() - scrollY;
            if (y + b.method_25364() <= startY || y >= endY) continue;
            list.add(b);
        }
        list.add((HeadButton)this.searchField);
        return list;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_52706(class_10799.field_56883, INNER_SPACE_TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        int startY = this.searchField.method_55443() + 3;
        int startX = this.method_46426() + 2;
        int endX = this.method_46426() + this.method_25368() - 2;
        int endY = this.method_46427() + this.method_25364() - 2;
        context.method_44379(startX, startY, endX, endY);
        int scrollY = (int)this.method_44387();
        HeadButton hovered = null;
        for (HeadButton b : this.visibleButtons) {
            int originalY = b.method_46427();
            int y = originalY - scrollY;
            if (y + b.method_25364() <= startY || y >= endY) continue;
            b.method_46419(y);
            b.method_25394(context, mouseX, mouseY, delta);
            if (b.method_25405(mouseX, mouseY) && mouseX >= startX && mouseX < endX && mouseY >= startY && mouseY < endY) {
                hovered = b;
            }
            b.method_46419(originalY);
        }
        this.method_44396(context);
        context.method_44380();
        if (hovered != null && !hovered.name.isEmpty()) {
            context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)hovered.name), mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int scrollbarX;
        if (this.searchField.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.searchField);
            return true;
        }
        double adjustedMouseY = mouseY + this.method_44387();
        if (this.method_44392() && mouseX >= (double)(scrollbarX = this.method_65507()) && mouseX < (double)(scrollbarX + 6)) {
            int thumbY = this.method_65508();
            int thumbHeight = this.method_44394();
            if (mouseY >= (double)thumbY && mouseY < (double)(thumbY + thumbHeight)) {
                adjustedMouseY = mouseY;
            }
        }
        return super.method_25402(mouseX, adjustedMouseY, button);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchField.method_25370() && this.searchField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.method_25370() && this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected int method_44395() {
        int rows = Math.ceilDiv(this.visibleButtons.size(), this.buttonsPerRow);
        return rows * 20 + this.searchField.method_25364() + 9;
    }

    protected double method_44393() {
        return 10.0;
    }

    protected void method_47399(class_6382 builder) {
    }

    public void setCurrentItem(@NotNull class_1799 item) {
        this.currentItem = item;
        String uuid = item.getUuid();
        this.selectedTexture = (String)SkyblockerConfigManager.get().general.customHelmetTextures.get((Object)uuid);
        this.updateButtons();
        this.filterButtons(this.searchField.method_1882());
    }

    private static class HeadButton
    extends class_339 {
        private final String name;
        private final String texture;
        private final class_1799 head;
        private boolean selected = false;
        private final Runnable onPress;

        HeadButton(String name, String texture, class_1799 head, Runnable onPress) {
            super(0, 0, 20, 20, (class_2561)class_2561.method_43473());
            this.name = name;
            this.texture = texture;
            this.head = head;
            this.onPress = onPress;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_51427(this.head, this.method_46426() + 2, this.method_46427() + 2);
            if (this.selected) {
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0x3000FF00);
            }
            if (this.method_49606()) {
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0x20FFFFFF);
            }
        }

        public void method_25348(double mouseX, double mouseY) {
            this.onPress.run();
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

