/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom.screen;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.custom.CustomArmorTrims;
import de.hysky.skyblocker.skyblock.item.custom.screen.TrimElementButton;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9017;
import org.jetbrains.annotations.NotNull;

public class TrimSelectionWidget
extends class_9017 {
    private static final class_2960 INNER_SPACE_TEXTURE = SkyblockerMod.id("menu_inner_space");
    private static final int MAX_BUTTONS_PER_ROW_PATTERN = 7;
    private static final int MAX_BUTTONS_PER_ROW_MATERIAL = 6;
    private final List<TrimElementButton.Pattern> patternButtons = new ArrayList<TrimElementButton.Pattern>();
    private final List<TrimElementButton> materialButtons = new ArrayList<TrimElementButton>();
    private final List<class_339> children = new ArrayList<class_339>();
    private class_1799 currentItem = null;
    private class_2960 selectedPattern = null;
    private class_2960 selectedMaterial = null;
    private int patternButtonsPerRow;
    private int materialButtonsPerRow;

    public TrimSelectionWidget(int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_30163((String)"Trim Selection"));
        TrimElementButton button;
        int i;
        TrimElementButton.Pattern patternNoneButton = new TrimElementButton.Pattern(null, null, this::onClickPattern);
        patternNoneButton.method_25355((class_2561)class_2561.method_43471((String)"gui.none"));
        this.patternButtons.add(patternNoneButton);
        Utils.getRegistryWrapperLookup().method_46762(class_7924.field_42082).method_42017().sorted(Comparator.comparing(reference -> ((class_8056)reference.comp_349()).comp_1215().getString())).map(reference -> new TrimElementButton.Pattern(reference.method_40237().method_29177(), (class_8056)reference.comp_349(), this::onClickPattern)).forEachOrdered(this.patternButtons::add);
        this.children.addAll(this.patternButtons);
        Utils.getRegistryWrapperLookup().method_46762(class_7924.field_42083).method_42017().sorted(Comparator.comparing(reference -> ((class_8054)reference.comp_349()).comp_1212().getString())).map(reference -> new TrimElementButton.Material(reference.method_40237().method_29177(), (class_8054)reference.comp_349(), this::onClickMaterial)).forEachOrdered(this.materialButtons::add);
        this.children.addAll(this.materialButtons);
        int buttonsPerRow = (width - 9) / 20;
        this.patternButtonsPerRow = Math.min(Math.ceilDiv(buttonsPerRow, 2), 7);
        this.materialButtonsPerRow = Math.min(Math.floorDiv(buttonsPerRow, 2), 6);
        if (this.method_44392()) {
            buttonsPerRow = (width - 15) / 20;
            this.patternButtonsPerRow = Math.min(Math.ceilDiv(buttonsPerRow, 2), 7);
            this.materialButtonsPerRow = Math.min(Math.floorDiv(buttonsPerRow, 2), 6);
        }
        for (i = 0; i < this.patternButtons.size(); ++i) {
            button = this.patternButtons.get(i);
            button.method_48229(x + 3 + i % this.patternButtonsPerRow * 20, y + 3 + i / this.patternButtonsPerRow * 20);
        }
        for (i = 0; i < this.materialButtons.size(); ++i) {
            button = this.materialButtons.get(i);
            int margin = this.method_44392() ? 9 : 3;
            button.method_48229(x + this.method_25368() - margin - this.materialButtonsPerRow * 20 + i % this.materialButtonsPerRow * 20, y + 3 + i / this.materialButtonsPerRow * 20);
        }
    }

    private void onClickPattern(TrimElementButton button) {
        for (TrimElementButton trimElementButton : this.patternButtons) {
            trimElementButton.field_22763 = true;
        }
        button.field_22763 = false;
        this.selectedPattern = button.getElement();
        this.updateConfig();
    }

    private void onClickMaterial(TrimElementButton button) {
        for (TrimElementButton materialButton : this.materialButtons) {
            materialButton.field_22763 = true;
        }
        button.field_22763 = false;
        this.selectedMaterial = button.getElement();
        this.updateConfig();
    }

    private void updateConfig() {
        if (this.currentItem == null) {
            return;
        }
        Object2ObjectOpenHashMap<String, CustomArmorTrims.ArmorTrimId> trims = SkyblockerConfigManager.get().general.customArmorTrims;
        String itemUuid = this.currentItem.getUuid();
        if (this.selectedPattern == null) {
            trims.remove(itemUuid);
        } else {
            trims.put(itemUuid, new CustomArmorTrims.ArmorTrimId(this.selectedMaterial, this.selectedPattern));
        }
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    protected int method_44395() {
        return (Math.max(this.patternButtons.size() / this.patternButtonsPerRow, this.materialButtons.size() / this.materialButtonsPerRow) + 1) * 20 + 6;
    }

    protected double method_44393() {
        return 10.0;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY + this.method_44387(), button);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_52706(class_10799.field_56883, INNER_SPACE_TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        context.method_44379(this.method_46426() + 2, this.method_46427() + 2, this.method_46426() + this.method_25368() - 2, this.method_46427() + this.method_25364() - 2);
        int scrollY = (int)this.method_44387();
        for (class_339 widget : this.children) {
            widget.method_46419(widget.method_46427() - scrollY);
            widget.method_25394(context, mouseX, mouseY, delta);
            widget.method_46419(widget.method_46427() + scrollY);
        }
        this.method_44396(context);
        context.method_44380();
    }

    protected void method_47399(class_6382 builder) {
    }

    public void setCurrentItem(@NotNull class_1799 currentItem) {
        this.currentItem = currentItem;
        Object2ObjectOpenHashMap<String, CustomArmorTrims.ArmorTrimId> trims = SkyblockerConfigManager.get().general.customArmorTrims;
        String itemUuid = currentItem.getUuid();
        for (TrimElementButton.Pattern button : this.patternButtons) {
            button.setStack(currentItem);
        }
        if (!trims.containsKey(itemUuid)) {
            int i;
            this.selectedPattern = null;
            this.selectedMaterial = this.materialButtons.getFirst().getElement();
            for (i = 0; i < this.materialButtons.size(); ++i) {
                this.materialButtons.get((int)i).field_22763 = i != 0;
            }
            for (i = 0; i < this.patternButtons.size(); ++i) {
                this.patternButtons.get((int)i).field_22763 = i != 0;
            }
        } else {
            CustomArmorTrims.ArmorTrimId id = (CustomArmorTrims.ArmorTrimId)trims.get(itemUuid);
            this.selectedMaterial = id.material();
            this.selectedPattern = id.pattern();
            for (TrimElementButton trimElementButton : this.materialButtons) {
                trimElementButton.field_22763 = !this.selectedMaterial.equals((Object)trimElementButton.getElement());
            }
            for (TrimElementButton trimElementButton : this.patternButtons) {
                trimElementButton.field_22763 = !this.selectedPattern.equals((Object)trimElementButton.getElement());
            }
        }
    }
}

