/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RomanNumerals;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommunityShopAdder
extends SimpleSlotTextAdder {
    private static final byte CATEGORIES_START = 10;
    private static final byte CATEGORIES_END = 14;
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("community_shop", "skyblocker.config.uiAndVisuals.slotText.communityShop", "skyblocker.config.uiAndVisuals.slotText.communityShop.@Tooltip");
    private static byte currentScreen = (byte)-1;

    public CommunityShopAdder() {
        super("^Community Shop", CONFIG_INFORMATION);
    }

    @Override
    @NotNull
    public List<SlotText> getText(@Nullable class_1735 slot, @NotNull class_1799 stack, int slotId) {
        if (slotId >= 10 && slotId <= 14 && stack.method_31574(class_1802.field_8581)) {
            currentScreen = (byte)(slotId - 10);
            return List.of();
        }
        return switch (currentScreen) {
            case 1 -> CommunityShopAdder.getTextForUpgradesScreen(stack, slotId);
            default -> List.of();
        };
    }

    private static List<SlotText> getTextForUpgradesScreen(class_1799 stack, int slotId) {
        return switch (slotId) {
            case 30, 31, 32, 33, 34, 38, 39, 40, 41, 42, 43, 44 -> {
                String lastLine;
                String name = stack.method_7964().getString();
                int lastIndex = name.lastIndexOf(32);
                String roman = name.substring(lastIndex + 1);
                if (!RomanNumerals.isValidRomanNumeral(roman)) {
                    yield List.of();
                }
                List<class_2561> lore = ItemUtils.getLore(stack);
                if (lore.isEmpty()) {
                    yield List.of();
                }
                class_5250 v1 = switch (lastLine = lore.getLast().getString()) {
                    case "Maxed out!" -> class_2561.method_43470((String)"Max").method_54663(16429959);
                    case "Currently upgrading!", "Click to instantly upgrade!" -> class_2561.method_43470((String)"\u23f0").method_54663(16376495).method_27692(class_124.field_1067);
                    case "Click to claim!" -> class_2561.method_43470((String)"\u2705").method_54663(10937249).method_27692(class_124.field_1067);
                    default -> class_2561.method_43470((String)String.valueOf(RomanNumerals.romanToDecimal(roman))).method_54663(13346551);
                };
                yield SlotText.bottomLeftList((class_2561)v1);
            }
            default -> List.of();
        };
    }
}

