/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.GeneralConfig;
import de.hysky.skyblocker.skyblock.item.tooltip.ItemTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.NEURepoManager;
import io.github.moulberry.repo.data.NEUIngredient;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.data.NEUKatUpgradeRecipe;
import io.github.moulberry.repo.data.NEURecipe;
import io.github.moulberry.repo.data.NEUTradeRecipe;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftPriceTooltip
extends SimpleTooltipAdder {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)CraftPriceTooltip.class.getName());
    private static final Map<String, Double> cachedCraftCosts = new ConcurrentHashMap<String, Double>();
    private static final int MAX_RECURSION_DEPTH = 15;

    public CraftPriceTooltip(int priority) {
        super(priority);
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSloFt, class_1799 stack, List<class_2561> lines) {
        if (TooltipInfoType.LOWEST_BINS.getData() == null || TooltipInfoType.BAZAAR.getData() == null) {
            ItemTooltip.nullWarning();
            return;
        }
        NEUItem neuItem = NEURepoManager.getItemByNeuId(stack.getNeuName());
        if (neuItem == null) {
            return;
        }
        List neuRecipes = neuItem.getRecipes();
        if (neuRecipes.isEmpty()) {
            return;
        }
        NEURecipe recipe = (NEURecipe)neuRecipes.getFirst();
        try {
            double totalCraftCost = CraftPriceTooltip.getItemCost(recipe, 0);
            if (totalCraftCost <= 0.0) {
                return;
            }
            int count = Math.max(ItemUtils.getItemCountInSack(stack, lines).orElse(ItemUtils.getItemCountInStash(lines.getFirst()).orElse(stack.method_7947())), 1);
            recipe.getAllOutputs().stream().findFirst().ifPresent(outputIngredient -> lines.add((class_2561)class_2561.method_43470((String)String.format("%-20s", "Crafting Price:")).method_27692(class_124.field_1065).method_10852(ItemTooltip.getCoinsMessage(totalCraftCost / outputIngredient.getAmount(), count))));
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Craft Price] Error calculating craftprice tooltip for: {}", (Object)stack.getNeuName(), (Object)e);
        }
    }

    public static double getItemCost(NEURecipe recipe, int depth) {
        if (depth >= 15 || recipe instanceof NEUKatUpgradeRecipe || recipe instanceof NEUTradeRecipe) {
            return -1.0;
        }
        double totalCraftCost = 0.0;
        for (NEUIngredient input : recipe.getAllInputs()) {
            List neuRecipes;
            NEUItem neuItem;
            String inputItemName = input.getItemId();
            double inputItemCount = input.getAmount();
            if (cachedCraftCosts.containsKey(inputItemName)) {
                totalCraftCost += cachedCraftCosts.get(inputItemName) * inputItemCount;
                continue;
            }
            double itemCost = 0.0;
            Object2ObjectMap<String, BazaarProduct> bazaarData = TooltipInfoType.BAZAAR.getData();
            Object2DoubleMap<String> lowestBinsData = TooltipInfoType.LOWEST_BINS.getData();
            if (bazaarData != null && bazaarData.containsKey((Object)inputItemName)) {
                BazaarProduct product = (BazaarProduct)bazaarData.get((Object)inputItemName);
                itemCost = SkyblockerConfigManager.get().general.itemTooltip.enableCraftingCost == GeneralConfig.Craft.BUY_ORDER ? product.buyPrice().orElse(0.0) : product.sellPrice().orElse(0.0);
            } else if (lowestBinsData != null && lowestBinsData.containsKey((Object)inputItemName)) {
                itemCost = lowestBinsData.getDouble((Object)inputItemName);
            }
            if (itemCost > 0.0) {
                cachedCraftCosts.put(inputItemName, itemCost);
            }
            if ((neuItem = NEURepoManager.getItemByNeuId(inputItemName)) != null && !(neuRecipes = neuItem.getRecipes()).isEmpty()) {
                double craftCost = CraftPriceTooltip.getItemCost((NEURecipe)neuRecipes.getFirst(), depth + 1);
                if (craftCost != -1.0) {
                    itemCost = Math.min(itemCost, craftCost);
                }
                cachedCraftCosts.put(inputItemName, itemCost);
            }
            totalCraftCost += itemCost * inputItemCount;
        }
        return totalCraftCost;
    }

    public static void clearCache() {
        cachedCraftCosts.clear();
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().general.itemTooltip.enableCraftingCost != GeneralConfig.Craft.OFF;
    }
}

