/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.wikilookup;

import com.mojang.datafixers.util.Either;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookupManager;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WikiLookup {
    public static final Map<String, String> CHARACTER_ENCODER = Map.ofEntries(Map.entry(" ", "_"), Map.entry("'", WikiLookup.encodeChar("'")), Map.entry("?", WikiLookup.encodeChar("?")));
    public static final Function<String, String> REPLACING_FUNCTION = CHARACTER_ENCODER.entrySet().stream().map(entryToReplace -> s -> s.replace((CharSequence)entryToReplace.getKey(), (CharSequence)entryToReplace.getValue())).reduce(Function.identity(), Function::andThen);

    public void open(@NotNull class_1799 var1, @NotNull class_1657 var2, boolean var3);

    default public boolean canSearch(@Nullable String title, @NotNull Either<class_1735, class_1799> either) {
        class_1799 itemStack = WikiLookupManager.mapEitherToItemStack(either);
        return !itemStack.method_7960();
    }

    private static String encodeChar(String character) {
        return URLEncoder.encode(character, StandardCharsets.UTF_8);
    }
}

