/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3542;

public enum SlayerType implements class_3542
{
    REVENANT("revenant", (class_1299<? extends class_1297>)class_1299.field_6051, "Revenant Horror", new class_1799((class_1935)class_1802.field_8511), new int[]{5, 25, 100, 500, 1500}, new int[]{5, 15, 200, 1000, 5000, 20000, 100000, 400000, 1000000}, List.of("Revenant Sycophant", "Revenant Champion", "Deformed Revenant", "Atoned Champion", "Atoned Revenant")),
    TARANTULA("tarantula", (class_1299<? extends class_1297>)class_1299.field_6079, "Tarantula Broodfather", new class_1799((class_1935)class_1802.field_8276), new int[]{5, 25, 100, 500, 1500}, new int[]{5, 25, 200, 1000, 5000, 20000, 100000, 400000, 1000000}, List.of("Tarantula Vermin", "Tarantula Beast", "Mutant Tarantula")),
    SVEN("sven", (class_1299<? extends class_1297>)class_1299.field_6055, "Sven Packmaster", new class_1799((class_1935)class_1802.field_8748), new int[]{5, 25, 100, 500, 1500}, new int[]{10, 30, 250, 1500, 5000, 20000, 100000, 400000, 1000000}, List.of("Pack Enforcer", "Sven Follower", "Sven Alpha")),
    VOIDGLOOM("voidgloom", (class_1299<? extends class_1297>)class_1299.field_6091, "Voidgloom Seraph", new class_1799((class_1935)class_1802.field_8634), new int[]{5, 25, 100, 500, 1500}, new int[]{10, 30, 250, 1500, 5000, 20000, 100000, 400000, 1000000}, List.of("Voidling Devotee", "Voidling Radical", "Voidcrazed Maniac")),
    VAMPIRE("vampire", (class_1299<? extends class_1297>)class_1299.field_6097, "Riftstalker Bloodfiend", new class_1799((class_1935)class_1802.field_8725), new int[]{5, 25, 100, 500, 1500}, new int[]{20, 75, 240, 840, 2400}, List.of()),
    DEMONLORD("demonlord", (class_1299<? extends class_1297>)class_1299.field_6099, "Inferno Demonlord", new class_1799((class_1935)class_1802.field_8183), new int[]{5, 25, 100, 500, 1500}, new int[]{10, 30, 250, 1500, 5000, 20000, 100000, 400000, 1000000}, List.of("Flare Demon", "Kindleheart Demon", "Burningsoul Demon")),
    UNKNOWN("unknown", null, "Unknown", new class_1799((class_1935)class_1802.field_8077), new int[0], new int[0], List.of());

    public static final Codec<SlayerType> CODEC;
    public final String name;
    public final class_1299<? extends class_1297> mobType;
    public final String bossName;
    public final class_1799 icon;
    public final int maxLevel;
    public final int[] xpPerTier;
    public final int[] levelMilestones;
    public final List<String> minibossNames;
    private static final Map<String, SlayerType> BOSS_NAME_TO_TYPE;

    private SlayerType(String name, class_1299<? extends class_1297> mobType, String bossName, class_1799 icon, int[] xpPerTier, int[] levelMilestones, List<String> minibossNames) {
        this.name = name;
        this.mobType = mobType;
        this.bossName = bossName;
        this.icon = icon;
        this.maxLevel = levelMilestones.length;
        this.xpPerTier = xpPerTier;
        this.levelMilestones = levelMilestones;
        this.minibossNames = minibossNames;
    }

    public static SlayerType fromBossName(String bossName) {
        return BOSS_NAME_TO_TYPE.getOrDefault(bossName.toLowerCase(Locale.ENGLISH), UNKNOWN);
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public String method_15434() {
        return this.name;
    }

    static {
        CODEC = class_3542.method_28140(SlayerType::values);
        BOSS_NAME_TO_TYPE = new HashMap<String, SlayerType>();
        for (SlayerType type : SlayerType.values()) {
            BOSS_NAME_TO_TYPE.put(type.bossName.toLowerCase(Locale.ENGLISH), type);
        }
    }
}

