/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers.boss.voidgloom;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.WorldEvents;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class BeaconHighlighter {
    private static final ObjectOpenHashSet<class_2338> beaconPositions = new ObjectOpenHashSet();
    private static final float[] RED_COLOR_COMPONENTS = new float[]{1.0f, 0.0f, 0.0f};

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(BeaconHighlighter::extractRendering);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> BeaconHighlighter.reset());
        ClientReceiveMessageEvents.ALLOW_GAME.register(BeaconHighlighter::onMessage);
        WorldEvents.BLOCK_STATE_UPDATE.register(BeaconHighlighter::onBlockStateUpdate);
    }

    private static void reset() {
        beaconPositions.clear();
    }

    private static void onBlockStateUpdate(class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (Utils.isInTheEnd() && SlayerManager.isBossSpawned()) {
            beaconPositions.remove((Object)pos);
            if (newState.method_27852(class_2246.field_10327)) {
                beaconPositions.add((Object)pos.method_10062());
            }
        }
    }

    private static boolean onMessage(class_2561 text, boolean overlay) {
        String message;
        if (Utils.isInTheEnd() && !overlay && ((message = text.getString()).contains("SLAYER QUEST COMPLETE!") || message.contains("NICE! SLAYER BOSS SLAIN!"))) {
            BeaconHighlighter.reset();
        }
        return true;
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (Utils.isInTheEnd() && SkyblockerConfigManager.get().slayers.endermanSlayer.highlightBeacons && SlayerManager.isInSlayerType(SlayerType.VOIDGLOOM)) {
            for (class_2338 pos : beaconPositions) {
                collector.submitFilledBox(pos, RED_COLOR_COMPONENTS, 0.5f, true);
            }
        }
    }
}

