/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline;

import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.WidgetPositioner;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import it.unimi.dsi.fastutil.objects.ObjectIntMutablePair;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.List;

public class CenteredWidgetPositioner
extends WidgetPositioner {
    int totalWidth = 0;
    final int maxY;
    List<ObjectIntPair<List<HudWidget>>> columns = new ArrayList<ObjectIntPair<List<HudWidget>>>();
    private final List<HudWidget> widgets = new ArrayList<HudWidget>();
    int currentY = 0;
    int currentWidth = 0;

    public CenteredWidgetPositioner(int screenWidth, int screenHeight) {
        super(screenWidth, screenHeight);
        this.columns.add((ObjectIntPair<List<HudWidget>>)new ObjectIntMutablePair(new ArrayList(), 0));
        this.maxY = Math.min(400, (int)((float)screenHeight * 0.9f));
    }

    @Override
    public void positionWidget(HudWidget hudWidget) {
        this.widgets.add(hudWidget);
        if (this.currentY + hudWidget.method_25364() > this.maxY) {
            this.currentY = 0;
            this.currentWidth = 0;
            this.columns.add((ObjectIntPair<List<HudWidget>>)new ObjectIntMutablePair(new ArrayList(), 0));
        }
        hudWidget.method_46419(this.currentY);
        this.currentY += hudWidget.method_25364() + 5;
        this.currentWidth = Math.max(this.currentWidth, hudWidget.method_25368());
        this.columns.getLast().right(this.currentWidth);
        ((List)this.columns.getLast().left()).add(hudWidget);
    }

    @Override
    public void finalizePositioning() {
        for (int i = 0; i < this.columns.size(); ++i) {
            ObjectIntPair<List<HudWidget>> listObjectIntPair = this.columns.get(i);
            int columnWidth = listObjectIntPair.rightInt();
            List column = (List)listObjectIntPair.left();
            int height = (column.size() - 1) * 5;
            for (HudWidget tabHudWidget : column) {
                height += tabHudWidget.method_25364();
            }
            int offset = (this.screenHeight - height) / 2;
            for (HudWidget tabHudWidget : column) {
                tabHudWidget.method_46419(tabHudWidget.method_46427() + offset);
                if (i < this.columns.size() / 2) {
                    tabHudWidget.method_46421(this.totalWidth + columnWidth - tabHudWidget.method_25368());
                    continue;
                }
                tabHudWidget.method_46421(this.totalWidth);
            }
            this.totalWidth += columnWidth + 5;
        }
        int off = (this.screenWidth - this.totalWidth) / 2;
        for (HudWidget tabHudWidget : this.widgets) {
            tabHudWidget.method_46421(tabHudWidget.method_46426() + off);
        }
    }
}

