/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@RegisterWidget
public class JacobsContestWidget
extends TabHudWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Jacob's Contest").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
    private static final Pattern CROP_PATTERN = Pattern.compile("(?<fortune>[\u2618\u25cb]) (?<crop>.+?)(?: \u25c6 )?(?<percentage>Top [\\d.]+%)?");
    public static final Map<String, class_1799> FARM_DATA = Map.ofEntries(Map.entry("Wheat", new class_1799((class_1935)class_1802.field_8861)), Map.entry("Carrot", new class_1799((class_1935)class_1802.field_8179)), Map.entry("Potato", new class_1799((class_1935)class_1802.field_8567)), Map.entry("Pumpkin", new class_1799((class_1935)class_1802.field_17518)), Map.entry("Melon Slice", new class_1799((class_1935)class_1802.field_8497)), Map.entry("Mushroom", new class_1799((class_1935)class_1802.field_17517)), Map.entry("Cactus", new class_1799((class_1935)class_1802.field_17520)), Map.entry("Sugar Cane", new class_1799((class_1935)class_1802.field_17531)), Map.entry("Nether Wart", new class_1799((class_1935)class_1802.field_8790)), Map.entry("Cocoa Beans", new class_1799((class_1935)class_1802.field_8116)));

    public JacobsContestWidget() {
        super("Jacob's Contest", TITLE, class_124.field_1054.method_532());
    }

    @Override
    public void updateContent(List<class_2561> lines) {
        for (class_2561 line : lines) {
            String string = line.getString();
            if (string.endsWith("left") || string.contains("Starts")) {
                this.addComponent(Components.iconTextComponent(Ico.CLOCK, line));
                continue;
            }
            Matcher matcher = CROP_PATTERN.matcher(string);
            if (matcher.matches()) {
                String crop = matcher.group("crop");
                String percentage = matcher.group("percentage");
                class_5250 cropText = class_2561.method_43473().method_27693(crop);
                if (matcher.group("fortune").equals("\u2618")) {
                    cropText.method_10852((class_2561)class_2561.method_43470((String)" \u2618").method_27692(class_124.field_1065));
                }
                this.addComponent(Components.iconTextComponent(FARM_DATA.get(crop), (class_2561)cropText));
                if (percentage == null) continue;
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)percentage)));
                continue;
            }
            this.addComponent(new PlainTextComponent(line));
        }
    }
}

