/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget.component;

import de.hysky.skyblocker.skyblock.tabhud.widget.component.Component;
import net.minecraft.class_332;

public class TableComponent
extends Component {
    private final Component[][] comps;
    private final int color;
    private final int cols;
    private final int rows;
    private final int[] colWidths;
    private final int[] rowBorders;
    private final int[] rowBaseHeights;
    private final int[] rowHeights;
    private final boolean drawLines;
    private static final int EXTRA_PAD = 2;

    public TableComponent(int w, int h, int col, boolean drawLines) {
        this.comps = new Component[w][h];
        this.color = drawLines && col != 0 ? 0xFF000000 | col : 0;
        this.drawLines = drawLines && col != 0;
        this.cols = w;
        this.rows = h;
        this.colWidths = new int[w];
        this.rowBorders = new int[h];
        this.rowBaseHeights = new int[h];
        this.rowHeights = new int[h];
    }

    public void addToCell(int x, int y, Component c) {
        this.comps[x][y] = c;
        int pad = x == 0 ? 4 : 2;
        this.colWidths[x] = Math.max(this.colWidths[x], c.width + pad);
        int baseH = c.height + 2;
        if (baseH > this.rowBaseHeights[y]) {
            this.rowBaseHeights[y] = baseH;
            this.rowHeights[y] = baseH + (this.rowBorders[y] != 0 ? 2 : 0);
        } else {
            this.rowHeights[y] = this.rowBorders[y] != 0 ? Math.max(this.rowHeights[y], this.rowBaseHeights[y] + 2) : Math.max(this.rowHeights[y], this.rowBaseHeights[y]);
        }
        this.recalcDimensions();
    }

    public void setRowBorder(int row, int borderColor) {
        if (row >= 0 && row < this.rowBorders.length) {
            boolean hasBorder;
            boolean hadBorder = this.rowBorders[row] != 0;
            this.rowBorders[row] = borderColor == 0 ? 0 : 0xFF000000 | borderColor;
            boolean bl = hasBorder = this.rowBorders[row] != 0;
            if (hasBorder && !hadBorder) {
                this.rowHeights[row] = Math.max(this.rowHeights[row], this.rowBaseHeights[row] + 2);
            } else if (!hasBorder && hadBorder) {
                this.rowHeights[row] = this.rowBaseHeights[row];
            }
            this.recalcDimensions();
        }
    }

    @Override
    public void render(class_332 context, int xpos, int ypos) {
        int yOff = 0;
        for (int y = 0; y < this.rows; ++y) {
            int col = this.rowBorders[y];
            if (col != 0) {
                context.method_49601(xpos, ypos + yOff, this.width + 2, this.rowHeights[y], col);
            }
            yOff += this.rowHeights[y];
        }
        int xOff = 0;
        for (int x = 0; x < this.cols; ++x) {
            if (this.drawLines && x != 0) {
                int lineX1 = xpos + xOff - 2 - 1;
                int lineX2 = xpos + xOff - 2;
                int lineY1 = ypos + 1;
                int lineY2 = ypos + this.height - 2 - 1;
                context.method_25294(lineX1, lineY1, lineX2, lineY2, this.color);
            }
            yOff = 0;
            for (int y = 0; y < this.rows; ++y) {
                Component comp = this.comps[x][y];
                if (comp != null) {
                    int pad = x == 0 && this.rowBorders[y] != 0 ? 1 : 0;
                    comp.render(context, xpos + xOff + pad, ypos + yOff + (this.rowHeights[y] / 2 - comp.height / 2 + 1));
                }
                yOff += this.rowHeights[y];
            }
            xOff += this.colWidths[x];
        }
    }

    private void recalcDimensions() {
        int totalW = 0;
        for (int w : this.colWidths) {
            totalW += w;
        }
        this.width = totalW;
        int totalH = -1;
        for (int h : this.rowHeights) {
            totalH += h;
        }
        this.height = totalH;
    }
}

