/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import com.demonwav.mcdev.annotations.Translatable;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_3542;

public class Calculator {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+\\.?\\d*)([sekmbt]?)");
    private static final Object2LongMap<String> MAGNITUDE_VALUES = Object2LongMaps.unmodifiable((Object2LongMap)new Object2LongOpenHashMap(Map.of("s", 64L, "e", 160L, "k", 1000L, "m", 1000000L, "b", 1000000000L, "t", 1000000000000L)));

    private static List<AbstractToken<?>> lex(String input) throws CalculatorException {
        ArrayList tokens = new ArrayList();
        input = input.replace(" ", "").toLowerCase(Locale.ENGLISH).replace("x", "*");
        for (int i = 0; i < input.length(); ++i) {
            tokens.add(switch (input.charAt(i)) {
                case '%', '*', '+', '-', '/', '^' -> {
                    String op = String.valueOf(input.charAt(i));
                    Operator operator = Operator.OPERATOR_MAP.apply(op);
                    if (operator == null) {
                        throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidOperatorError", op);
                    }
                    if (!tokens.isEmpty() && ((AbstractToken)tokens.getLast()).type == TokenType.OPERATOR) {
                        throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.duplicateOperatorError", new Object[0]);
                    }
                    yield new OperatorToken(operator);
                }
                case '(' -> {
                    TokenType lastType;
                    if (!(tokens.isEmpty() || (lastType = ((AbstractToken)tokens.getLast()).type) != TokenType.R_PARENTHESIS && lastType != TokenType.NUMBER)) {
                        tokens.add(new OperatorToken(Operator.MULT));
                    }
                    yield new Token(TokenType.L_PARENTHESIS, "(");
                }
                case ')' -> new Token(TokenType.R_PARENTHESIS, ")");
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> {
                    Matcher numberMatcher = NUMBER_PATTERN.matcher(input.substring(i));
                    if (!numberMatcher.find()) {
                        throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidCharacterError", input.substring(i));
                    }
                    int end = numberMatcher.end();
                    String number = input.substring(i, i + end);
                    i += end - 1;
                    yield new Token(TokenType.NUMBER, number);
                }
                default -> {
                    TokenType lastType;
                    String func = input.substring(i).split("[ (]", 2)[0];
                    Function function = Function.FUNCTION_MAP.apply(func);
                    if (function == null) {
                        throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidOperatorError", func);
                    }
                    if (!(tokens.isEmpty() || (lastType = ((AbstractToken)tokens.getLast()).type) != TokenType.R_PARENTHESIS && lastType != TokenType.NUMBER)) {
                        tokens.add(new OperatorToken(Operator.MULT));
                    }
                    i += func.length() - 1;
                    yield new FunctionToken(function);
                }
            });
        }
        return tokens;
    }

    private static List<AbstractToken<?>> shunt(List<AbstractToken<?>> tokens) throws CalculatorException {
        ArrayDeque operatorStack = new ArrayDeque();
        ArrayList<AbstractToken> outputQueue = new ArrayList<AbstractToken>();
        for (AbstractToken<?> shuntingToken : tokens) {
            switch (shuntingToken.type.ordinal()) {
                case 0: {
                    outputQueue.add(shuntingToken);
                    break;
                }
                case 1: {
                    Operator op = (Operator)((Object)shuntingToken.value);
                    int precedence = Calculator.getPrecedence(op);
                    while (!operatorStack.isEmpty()) {
                        AbstractToken leftToken = (AbstractToken)operatorStack.peek();
                        if (leftToken.type == TokenType.L_PARENTHESIS) break;
                        assert (leftToken.type == TokenType.OPERATOR);
                        int leftPrecedence = Calculator.getPrecedence((Operator)((Object)leftToken.value));
                        if (leftPrecedence <= precedence && (leftPrecedence != precedence || op.rightAssociative)) break;
                        outputQueue.add((AbstractToken)operatorStack.pop());
                    }
                    operatorStack.push(shuntingToken);
                    break;
                }
                case 2: 
                case 3: {
                    operatorStack.push(shuntingToken);
                    break;
                }
                case 4: {
                    while (true) {
                        if (operatorStack.isEmpty()) {
                            throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.unbalancedParenthesisError", new Object[0]);
                        }
                        AbstractToken leftToken = (AbstractToken)operatorStack.pop();
                        if (leftToken.type == TokenType.L_PARENTHESIS) break;
                        outputQueue.add(leftToken);
                    }
                    if (operatorStack.isEmpty() || ((AbstractToken)operatorStack.peek()).type != TokenType.FUNCTION) break;
                    outputQueue.add((AbstractToken)operatorStack.pop());
                }
            }
        }
        while (!operatorStack.isEmpty()) {
            AbstractToken leftToken = (AbstractToken)operatorStack.pop();
            if (leftToken.type == TokenType.L_PARENTHESIS) continue;
            outputQueue.add(leftToken);
        }
        return outputQueue.stream().toList();
    }

    private static int getPrecedence(Operator operator) {
        return switch (operator.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> 0;
            case 2, 3, 4 -> 1;
            case 5 -> 2;
        };
    }

    private static double evaluate(List<AbstractToken<?>> tokens) throws CalculatorException {
        ArrayDeque<Double> values = new ArrayDeque<Double>();
        for (AbstractToken<?> token : tokens) {
            switch (token.type.ordinal()) {
                case 0: {
                    values.push(Calculator.calculateValue((String)token.value));
                    break;
                }
                case 1: {
                    if (values.size() < 2) {
                        throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.missingValueError", new Object[0]);
                    }
                    double right = (Double)values.pollFirst();
                    double left = (Double)values.pollFirst();
                    values.push(switch (((Operator)((Object)token.value)).ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> left + right;
                        case 1 -> left - right;
                        case 2 -> left * right;
                        case 3 -> {
                            if (right == 0.0) {
                                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.divisionByZeroError", left);
                            }
                            yield left / right;
                        }
                        case 4 -> {
                            if (right == 0.0) {
                                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.moduloByZeroError", left);
                            }
                            yield left % right;
                        }
                        case 5 -> Math.pow(left, right);
                    });
                    break;
                }
                case 2: {
                    if (values.isEmpty()) {
                        throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.missingValueError", new Object[0]);
                    }
                    values.push(((Function)((Object)token.value)).function.apply((Double)values.pollFirst()));
                    break;
                }
                case 3: 
                case 4: {
                    throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.unbalancedParenthesisError", new Object[0]);
                }
            }
        }
        if (values.isEmpty()) {
            throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.emptyEquationError", new Object[0]);
        }
        return (Double)values.pop();
    }

    private static double calculateValue(String value) throws CalculatorException {
        Matcher numberMatcher = NUMBER_PATTERN.matcher(value.toLowerCase(Locale.ENGLISH));
        if (!numberMatcher.matches()) {
            throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidNumberError", value.toLowerCase(Locale.ENGLISH));
        }
        double number = Double.parseDouble(numberMatcher.group(1));
        String magnitude = numberMatcher.group(2);
        if (!magnitude.isEmpty()) {
            if (!MAGNITUDE_VALUES.containsKey((Object)magnitude)) {
                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidMagnitudeError", magnitude);
            }
            number *= (double)MAGNITUDE_VALUES.getLong((Object)magnitude);
        }
        return number;
    }

    public static double calculate(String equation) throws CalculatorException {
        equation = equation.toLowerCase(Locale.ENGLISH).replaceAll("p(urse)?", String.valueOf((long)Utils.getPurse()));
        return Calculator.evaluate(Calculator.shunt(Calculator.lex(equation)));
    }

    public static enum Operator implements class_3542
    {
        ADD("+"),
        SUB("-"),
        MULT("*"),
        DIV("/"),
        MOD("%"),
        POW("^", true);

        private static final java.util.function.Function<String, Operator> OPERATOR_MAP;
        private final String op;
        private final boolean rightAssociative;

        private Operator(String op) {
            this(op, false);
        }

        private Operator(String op, boolean rightAssociative) {
            this.op = op;
            this.rightAssociative = rightAssociative;
        }

        public String method_15434() {
            return this.op;
        }

        static {
            OPERATOR_MAP = class_3542.method_53953((class_3542[])Operator.values(), java.util.function.Function.identity());
        }
    }

    public static class CalculatorException
    extends Exception {
        public final Object[] args;

        public CalculatorException(@Translatable String message, Object ... args) {
            super(message);
            this.args = args;
        }
    }

    public static abstract class AbstractToken<T> {
        public final TokenType type;
        private final T value;

        public AbstractToken(TokenType type, T value) {
            this.type = type;
            this.value = value;
        }
    }

    public static enum TokenType {
        NUMBER,
        OPERATOR,
        FUNCTION,
        L_PARENTHESIS,
        R_PARENTHESIS;

    }

    public static class OperatorToken
    extends AbstractToken<Operator> {
        public OperatorToken(Operator operator) {
            super(TokenType.OPERATOR, operator);
        }
    }

    public static class Token
    extends AbstractToken<String> {
        public Token(TokenType type, String value) {
            super(type, value);
        }
    }

    public static enum Function implements class_3542
    {
        SQRT("sqrt", val -> {
            if (val < 0.0) {
                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidFunctionInputError", val, "sqrt");
            }
            return Math.sqrt(val);
        }),
        LOG("log", val -> {
            if (val <= 0.0) {
                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidFunctionInputError", val, "log");
            }
            return Math.log10(val);
        }),
        LG("lg", val -> {
            if (val <= 0.0) {
                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidFunctionInputError", val, "lg");
            }
            return Math.log(val) / Math.log(2.0);
        }),
        LN("ln", val -> {
            if (val <= 0.0) {
                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidFunctionInputError", val, "ln");
            }
            return Math.log(val);
        }),
        FACTORIAL("factorial", val -> {
            if (val < 0.0 || val > 170.0) {
                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidFunctionInputError", val, "factorial");
            }
            double result = 1.0;
            for (int i = 2; i <= (int)val; ++i) {
                result *= (double)i;
            }
            return result;
        }),
        SIN("sin", val -> Math.sin(Math.toRadians(val))),
        COS("cos", val -> Math.cos(Math.toRadians(val))),
        TAN("tan", val -> Math.tan(Math.toRadians(val))),
        ASIN("asin", val -> {
            if (val < -1.0 || val > 1.0) {
                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidFunctionInputError", val, "asin");
            }
            return Math.toDegrees(Math.asin(val));
        }),
        ACOS("acos", val -> {
            if (val < -1.0 || val > 1.0) {
                throw new CalculatorException("skyblocker.config.uiAndVisuals.inputCalculator.invalidFunctionInputError", val, "acos");
            }
            return Math.toDegrees(Math.acos(val));
        }),
        ATAN("atan", val -> Math.toDegrees(Math.atan(val))),
        SINH("sinh", Math::sinh),
        COSH("cosh", Math::cosh),
        TANH("tanh", val -> {
            if (val > 20.0) {
                return 1.0;
            }
            if (val < -20.0) {
                return -1.0;
            }
            return Math.tanh(val);
        }),
        ABS("abs", Math::abs),
        FLOOR("floor", Math::floor),
        CEIL("ceil", Math::ceil),
        ROUND("round", Math::round);

        private static final java.util.function.Function<String, Function> FUNCTION_MAP;
        private final String name;
        private final CalculatorFunction function;

        private Function(String name, CalculatorFunction function) {
            this.name = name;
            this.function = function;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            FUNCTION_MAP = class_3542.method_53953((class_3542[])Function.values(), java.util.function.Function.identity());
        }

        @FunctionalInterface
        private static interface CalculatorFunction {
            public double apply(double var1) throws CalculatorException;
        }
    }

    public static class FunctionToken
    extends AbstractToken<Function> {
        public FunctionToken(Function value) {
            super(TokenType.FUNCTION, value);
        }
    }
}

