/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.hunting.Attribute;
import de.hysky.skyblocker.skyblock.hunting.Attributes;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.CraftPriceTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.ObtainedDateTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.RegexUtils;
import de.hysky.skyblocker.utils.TextUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.networth.NetworthCalculator;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.data.NEURecipe;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azureaaron.networth.Calculation;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9322;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemUtils {
    public static final String ID = "id";
    public static final String UUID = "uuid";
    public static final Pattern NOT_DURABILITY = Pattern.compile("[^0-9 /]");
    public static final Predicate<String> FUEL_PREDICATE = line -> line.contains("Fuel: ");
    private static final Codec<class_6880<class_1792>> EMPTY_ALLOWING_ITEM_CODEC = class_7923.field_41178.method_40294();
    public static final Codec<class_1799> EMPTY_ALLOWING_ITEMSTACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)EMPTY_ALLOWING_ITEM_CODEC.fieldOf(ID).forGetter(class_1799::method_41409), (App)Codec.INT.orElse((Object)1).fieldOf("count").forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)instance, class_1799::new)));
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemUtils.class);
    private static final Pattern STORED_PATTERN = Pattern.compile("Stored: ([\\d,]+)/\\S+");
    private static final Pattern GEMSTONES_SACK_AMOUNT_PATTERN = Pattern.compile(" Amount: ([\\d,]+)");
    private static final Pattern STASH_COUNT_PATTERN = Pattern.compile("x([\\d,]+)$");
    private static final Pattern HUNTING_BOX_COUNT_PATTERN = Pattern.compile("Owned: (?<shards>\\d+) Shards?");
    private static final short LOG_INTERVAL = 1000;
    private static long lastLog = class_156.method_658();

    private ItemUtils() {
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> dumpHeldItemCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpHeldItem").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("[Skyblocker Debug] Held Item: " + SkyblockerMod.GSON_COMPACT.toJson((JsonElement)class_1799.field_24671.encodeStart((DynamicOps)Utils.getRegistryWrapperLookup().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)((FabricClientCommandSource)context.getSource()).getPlayer().method_6047()).getOrThrow()))));
            return 1;
        });
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> dumpHeldItemNetworthCalculationsCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpHeldItemNetworthCalcs").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("[Skyblocker Debug] Held Item NW Calcs: " + SkyblockerMod.GSON_COMPACT.toJson((JsonElement)Calculation.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)NetworthCalculator.getItemNetworth(((FabricClientCommandSource)context.getSource()).getPlayer().method_6047()).calculations()).getOrThrow()))));
            return 1;
        });
    }

    @NotNull
    public static class_2487 getCustomData(@NotNull class_9322 stack) {
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
    }

    @NotNull
    public static Optional<String> getItemIdOptional(@NotNull class_9322 stack) {
        class_2487 customData = ItemUtils.getCustomData(stack);
        return customData.method_10558(ID);
    }

    @Deprecated(since="5.8.0")
    @NotNull
    public static String getItemId(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564(ID, "");
    }

    @NotNull
    public static Optional<String> getItemUuidOptional(@NotNull class_9322 stack) {
        class_2487 customData = ItemUtils.getCustomData(stack);
        return customData.method_10558(UUID);
    }

    @Deprecated(since="5.8.0")
    @NotNull
    public static String getItemUuid(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564(UUID, "");
    }

    @Deprecated(since="5.8.0")
    @NotNull
    public static String getSkyblockApiId(@NotNull class_9322 itemStack) {
        class_2487 customData = ItemUtils.getCustomData(itemStack);
        String id = customData.method_68564(ID, "");
        if (customData.method_10545("is_shiny")) {
            return "SHINY_" + id;
        }
        switch (id) {
            case "ENCHANTED_BOOK": {
                if (!customData.method_10545("enchantments")) break;
                class_2487 enchants = customData.method_68568("enchantments");
                Optional firstEnchant = enchants.method_10541().stream().findFirst();
                String enchant = firstEnchant.orElse("");
                return "ENCHANTMENT_" + enchant.toUpperCase(Locale.ENGLISH) + "_" + enchants.method_68083(enchant, 0);
            }
            case "PET": {
                if (!customData.method_10545("petInfo")) break;
                PetInfo petInfo = (PetInfo)PetInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)customData.method_68564("petInfo", ""))).getOrThrow();
                return "LVL_1_" + String.valueOf((Object)petInfo.tier()) + "_" + petInfo.type();
            }
            case "POTION": {
                String splash;
                String enhanced = customData.method_10545("enhanced") ? "_ENHANCED" : "";
                String extended = customData.method_10545("extended") ? "_EXTENDED" : "";
                String string = splash = customData.method_10545("splash") ? "_SPLASH" : "";
                if (!customData.method_10545("potion") || !customData.method_10545("potion_level")) break;
                return (customData.method_68564("potion", "") + "_" + id + "_" + customData.method_68083("potion_level", 0) + enhanced + extended + splash).toUpperCase(Locale.ENGLISH);
            }
            case "RUNE": {
                if (!customData.method_10545("runes")) break;
                class_2487 runes = customData.method_68568("runes");
                String rune = runes.method_10541().stream().findFirst().orElse("");
                return rune.toUpperCase(Locale.ENGLISH) + "_RUNE_" + runes.method_68083(rune, 0);
            }
            case "ATTRIBUTE_SHARD": {
                Attribute attribute = Attributes.getAttributeFromItemName(itemStack);
                if (attribute == null) break;
                return attribute.apiId();
            }
            case "NEW_YEAR_CAKE": {
                return id + "_" + customData.method_68083("new_years_cake", 0);
            }
            case "PARTY_HAT_CRAB": 
            case "PARTY_HAT_CRAB_ANIMATED": 
            case "BALLOON_HAT_2024": 
            case "BALLOON_HAT_2025": {
                return id + "_" + customData.method_68564("party_hat_color", "").toUpperCase(Locale.ENGLISH);
            }
            case "PARTY_HAT_SLOTH": {
                return id + "_" + customData.method_68564("party_hat_emoji", "").toUpperCase(Locale.ENGLISH);
            }
            case "MIDAS_SWORD": {
                if (customData.method_68083("winning_bid", 0) < 50000000) break;
                return id + "_50M";
            }
            case "MIDAS_STAFF": {
                if (customData.method_68083("winning_bid", 0) < 100000000) break;
                return id + "_100M";
            }
        }
        return id;
    }

    @Deprecated(since="5.8.0")
    @NotNull
    public static String getNeuId(class_1799 stack) {
        if (stack == null) {
            return "";
        }
        String id = stack.getSkyblockId();
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        return switch (id) {
            case "ENCHANTED_BOOK" -> {
                class_2487 enchantments = customData.method_68568("enchantments");
                String enchant = enchantments.method_10541().stream().findFirst().orElse("");
                yield enchant.toUpperCase(Locale.ENGLISH) + ";" + enchantments.method_68083(enchant, 0);
            }
            case "PET" -> {
                if (!customData.method_10545("petInfo")) {
                    yield id;
                }
                PetInfo petInfo = (PetInfo)PetInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)customData.method_68564("petInfo", ""))).getOrThrow();
                yield petInfo.type() + ";" + petInfo.tierIndex();
            }
            case "RUNE" -> {
                class_2487 runes = customData.method_68568("runes");
                String rune = runes.method_10541().stream().findFirst().orElse("");
                yield rune.toUpperCase(Locale.ENGLISH) + "_RUNE;" + runes.method_68083(rune, 0);
            }
            case "POTION" -> "POTION_" + customData.method_68564("potion", "").toUpperCase(Locale.ENGLISH) + ";" + customData.method_68083("potion_level", 0);
            case "ATTRIBUTE_SHARD" -> {
                Attribute attribute = Attributes.getAttributeFromItemName((class_9322)stack);
                if (attribute == null) {
                    yield id;
                }
                yield ItemRepository.getBazaarStocks().getOrDefault(attribute.apiId(), id);
            }
            case "PARTY_HAT_CRAB", "BALLOON_HAT_2024", "BALLOON_HAT_2025" -> id + "_" + customData.method_68564("party_hat_color", "").toUpperCase(Locale.ENGLISH);
            case "PARTY_HAT_CRAB_ANIMATED" -> "PARTY_HAT_CRAB_" + customData.method_68564("party_hat_color", "").toUpperCase(Locale.ENGLISH) + "_ANIMATED";
            case "PARTY_HAT_SLOTH" -> id + "_" + customData.method_68564("party_hat_emoji", "").toUpperCase(Locale.ENGLISH);
            default -> id.replace(":", "-");
        };
    }

    @Deprecated(since="5.8.0")
    @NotNull
    public static PetInfo getPetInfo(class_1799 stack) {
        if (!stack.getSkyblockId().equals("PET")) {
            return PetInfo.EMPTY;
        }
        String petInfo = ItemUtils.getCustomData((class_9322)stack).method_68564("petInfo", "");
        if (!petInfo.isEmpty()) {
            try {
                JsonElement jsonElement = JsonParser.parseString((String)petInfo);
                jsonElement.getAsJsonObject().addProperty("name", stack.method_7964().getString());
                return (PetInfo)PetInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).setPartial((Object)PetInfo.EMPTY).getPartialOrThrow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PetInfo.EMPTY;
    }

    @NotNull
    public static DoubleBooleanPair getItemPrice(@NotNull class_1799 stack) {
        return ItemUtils.getItemPrice(stack.getSkyblockApiId(), false);
    }

    @NotNull
    public static DoubleBooleanPair getItemPrice(@Nullable String skyblockApiId) {
        return ItemUtils.getItemPrice(skyblockApiId, false);
    }

    @NotNull
    public static DoubleBooleanPair getItemPrice(@Nullable String skyblockApiId, boolean useBazaarBuyPrice) {
        Object2ObjectMap<String, BazaarProduct> bazaarPrices = TooltipInfoType.BAZAAR.getData();
        Object2DoubleMap<String> lowestBinPrices = TooltipInfoType.LOWEST_BINS.getData();
        if (skyblockApiId == null || skyblockApiId.isEmpty() || bazaarPrices == null || lowestBinPrices == null) {
            return DoubleBooleanPair.of((double)0.0, (boolean)false);
        }
        if (bazaarPrices.containsKey((Object)skyblockApiId)) {
            BazaarProduct product = (BazaarProduct)bazaarPrices.get((Object)skyblockApiId);
            OptionalDouble price = useBazaarBuyPrice ? product.buyPrice() : product.sellPrice();
            return DoubleBooleanPair.of((double)price.orElse(0.0), (boolean)price.isPresent());
        }
        if (lowestBinPrices.containsKey((Object)skyblockApiId)) {
            return DoubleBooleanPair.of((double)lowestBinPrices.getDouble((Object)skyblockApiId), (boolean)true);
        }
        return DoubleBooleanPair.of((double)0.0, (boolean)false);
    }

    public static double getCraftCost(String skyblockApiId) {
        NEUItem neuItem = NEURepoManager.getItemByNeuId(skyblockApiId);
        if (neuItem != null && !neuItem.getRecipes().isEmpty()) {
            return CraftPriceTooltip.getItemCost((NEURecipe)neuItem.getRecipes().getFirst(), 0);
        }
        return 0.0;
    }

    @Deprecated(since="1.21.0")
    public static String getTimestamp(class_1799 stack) {
        return ObtainedDateTooltip.getTimestamp(stack);
    }

    public static boolean hasCustomDurability(@NotNull class_1799 stack) {
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        return !customData.method_33133() && (customData.method_10545("drill_fuel") || customData.method_68564(ID, "").equals("PICKONIMBUS"));
    }

    @Nullable
    public static IntIntPair getDurability(@NotNull class_1799 stack) {
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        if (customData.method_33133()) {
            return null;
        }
        if (stack.getSkyblockId().equals("PICKONIMBUS")) {
            int pickonimbusDurability = customData.method_68083("pickonimbus_durability", 0);
            return IntIntPair.of((int)(customData.method_10545("pickonimbus_durability") ? pickonimbusDurability : 2000), (int)2000);
        }
        String drillFuel = class_124.method_539((String)ItemUtils.getLoreLineIf(stack, FUEL_PREDICATE));
        if (drillFuel != null) {
            String[] drillFuelStrings = NOT_DURABILITY.matcher(drillFuel).replaceAll("").trim().split("/");
            return IntIntPair.of((int)Integer.parseInt(drillFuelStrings[0]), (int)(Integer.parseInt(drillFuelStrings[1]) * 1000));
        }
        return null;
    }

    @Nullable
    public static String getLoreLineIf(class_1799 stack, Predicate<String> predicate) {
        for (class_2561 line : ItemUtils.getLore(stack)) {
            String string = line.getString();
            if (!predicate.test(string)) continue;
            return string;
        }
        return null;
    }

    @Nullable
    public static Matcher getLoreLineIfMatch(class_1799 stack, Pattern pattern) {
        return TextUtils.matchInList(ItemUtils.getLore(stack), pattern);
    }

    public static List<Matcher> getLoreLineIfMatch(class_1799 stack, Pattern ... patterns) {
        return TextUtils.matchInList(ItemUtils.getLore(stack), patterns);
    }

    @Nullable
    public static Matcher getLoreLineIfContainsMatch(class_1799 stack, Pattern pattern) {
        return TextUtils.findInList(ItemUtils.getLore(stack), pattern);
    }

    @NotNull
    public static List<class_2561> getLore(class_1799 stack) {
        return ((class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2401();
    }

    @NotNull
    public static PropertyMap propertyMapWithTexture(String textureValue) {
        return (PropertyMap)class_5699.field_40725.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)("[{\"name\":\"textures\",\"value\":\"" + textureValue + "\"}]"))).getOrThrow();
    }

    @NotNull
    public static String getHeadTexture(@NotNull class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8575) || !stack.method_57826(class_9334.field_49617)) {
            return "";
        }
        class_9296 profile = (class_9296)stack.method_58694(class_9334.field_49617);
        if (profile == null) {
            return "";
        }
        return profile.comp_2412().get((Object)"textures").stream().map(Property::value).findFirst().orElse("");
    }

    @NotNull
    public static Optional<String> getHeadTextureOptional(class_1799 stack) {
        String texture = ItemUtils.getHeadTexture(stack);
        if (texture.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(texture);
    }

    @NotNull
    public static String toTextureBase64(String textureUUID) {
        String str = "{textures:{SKIN:{url:\"http://textures.minecraft.net/texture/" + textureUUID + "\"}}}";
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    @NotNull
    public static class_1799 createSkull(String textureBase64) {
        GameProfile profile = new GameProfile(java.util.UUID.randomUUID(), "a");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", textureBase64));
        return ItemUtils.createSkull(profile);
    }

    @NotNull
    public static class_1799 createSkull(GameProfile profile) {
        try {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
            stack.method_57379(class_9334.field_49617, (Object)new class_9296(profile));
            return stack;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static class_1799 getSkyblockerStack() {
        return ItemUtils.createSkull("e3RleHR1cmVzOntTS0lOOnt1cmw6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDdjYzY2ODc0MjNkMDU3MGQ1NTZhYzUzZTA2NzZjYjU2M2JiZGQ5NzE3Y2Q4MjY5YmRlYmVkNmY2ZDRlN2JmOCJ9fX0=");
    }

    @NotNull
    public static class_1799 getSkyblockerForgeStack() {
        return ItemUtils.createSkull("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHBzOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzJkZGQ4OWE2YWU5NTdmNzY2ZDMwMDAxMWZmNDQ3MTQ4MWMzYmI2MWI2NzYwNzhhOGM2YzNjNDA4MzIwMWI1YzIifX19");
    }

    @NotNull
    public static String getConcatenatedLore(@NotNull class_1799 item) {
        return ItemUtils.concatenateLore(ItemUtils.getLore(item));
    }

    @NotNull
    public static String concatenateLore(@NotNull List<class_2561> lore) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < lore.size(); ++i) {
            stringBuilder.append(lore.get(i).getString());
            if (i == lore.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static boolean isSoulbound(class_1799 stack) {
        return ItemUtils.getLore(stack).stream().anyMatch(lore -> lore.getString().toLowerCase(Locale.ENGLISH).contains("soulbound"));
    }

    public static List<class_1799> getArmor(class_1309 entity) {
        return class_9274.field_49224.method_66665().stream().filter(es -> es.method_5925() == class_1304.class_1305.field_6178).map(arg_0 -> ((class_1309)entity).method_6118(arg_0)).toList();
    }

    @NotNull
    public static OptionalInt getItemCountInSack(@NotNull class_1799 itemStack, @NotNull List<class_2561> lines) {
        return ItemUtils.getItemCountInSack(itemStack, lines, false);
    }

    @NotNull
    public static OptionalInt getItemCountInSack(@NotNull class_1799 itemStack, @NotNull List<class_2561> lines, boolean isLore) {
        Matcher matcher;
        if (lines.size() < 2 || !StringUtils.endsWithAny((CharSequence)lines.get(isLore ? 0 : 1).getString(), (CharSequence[])new CharSequence[]{"Sack", "Gemstones"})) {
            return OptionalInt.empty();
        }
        if (itemStack.method_7964().getString().endsWith("Gemstone") && (matcher = TextUtils.matchInList(lines, GEMSTONES_SACK_AMOUNT_PATTERN)) != null) {
            return RegexUtils.parseOptionalIntFromMatcher(matcher, 1);
        }
        matcher = TextUtils.matchInList(lines, STORED_PATTERN);
        if (matcher != null) {
            return RegexUtils.parseOptionalIntFromMatcher(matcher, 1);
        }
        if (class_156.method_658() - lastLog > 1000L) {
            LOGGER.warn("Failed to find stored amount in sack tooltip for item `{}`", (Object)Debug.DumpFormat.JSON.format(itemStack).getString());
            lastLog = class_156.method_658();
        }
        return OptionalInt.empty();
    }

    @NotNull
    public static OptionalInt getItemCountInStash(@NotNull class_1799 itemStack) {
        return ItemUtils.getItemCountInStash(itemStack.method_7964());
    }

    @NotNull
    public static OptionalInt getItemCountInStash(@NotNull class_2561 itemName) {
        return RegexUtils.findIntFromMatcher(STASH_COUNT_PATTERN.matcher(itemName.getString()));
    }

    @NotNull
    public static OptionalInt getItemCountInHuntingBox(@NotNull class_1799 stack) {
        Matcher matcher = ItemUtils.getLoreLineIfContainsMatch(stack, HUNTING_BOX_COUNT_PATTERN);
        return matcher != null ? RegexUtils.parseOptionalIntFromMatcher((MatchResult)matcher, "shards") : OptionalInt.empty();
    }

    @Deprecated(since="5.8.0")
    @NotNull
    public static SkyblockItemRarity getItemRarity(@NotNull class_1799 stack) {
        if (stack.method_7960()) {
            return SkyblockItemRarity.UNKNOWN;
        }
        if (!stack.getSkyblockId().equals("PET")) {
            return ItemUtils.getLore(stack).reversed().stream().map(class_2561::getString).map(SkyblockItemRarity::containsName).flatMap(Optional::stream).findFirst().orElse(SkyblockItemRarity.UNKNOWN);
        }
        PetInfo info = stack.getPetInfo();
        if (info.isEmpty()) {
            return SkyblockItemRarity.UNKNOWN;
        }
        return info.item().isPresent() && info.item().get().equals("PET_ITEM_TIER_BOOST") ? info.rarity().next() : info.rarity();
    }
}

