/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.networth;

import com.google.gson.JsonArray;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import net.azureaaron.networth.data.SkyblockItemData;
import org.slf4j.Logger;

public class NetworthDataSuppliers {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Object2ObjectMap<String, SkyblockItemData> itemData = Object2ObjectMaps.emptyMap();

    public static void updateSkyblockItemData(JsonArray items) {
        try {
            itemData = (Object2ObjectMap)SkyblockItemData.MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)items).getOrThrow();
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Networth Data Supplier] Failed to parse items data!", (Throwable)e);
        }
    }

    static Object2ObjectMap<String, SkyblockItemData> getSkyblockItemData() {
        return itemData;
    }

    static double getPrice(String id) {
        return ItemUtils.getItemPrice(id, true).leftDouble();
    }
}

