/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.primitive;

import de.hysky.skyblocker.utils.render.Renderer;
import de.hysky.skyblocker.utils.render.SkyblockerRenderPipelines;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveRenderer;
import de.hysky.skyblocker.utils.render.state.CameraRenderState;
import de.hysky.skyblocker.utils.render.state.CylinderRenderState;
import net.minecraft.class_287;
import org.joml.Matrix4f;

public final class CylinderRenderer
implements PrimitiveRenderer<CylinderRenderState> {
    protected static final CylinderRenderer INSTANCE = new CylinderRenderer();

    private CylinderRenderer() {
    }

    @Override
    public void submitPrimitives(CylinderRenderState state, CameraRenderState cameraState) {
        class_287 buffer = Renderer.getBuffer(SkyblockerRenderPipelines.CYLINDER);
        Matrix4f positionMatrix = new Matrix4f().translate((float)(-cameraState.pos.field_1352), (float)(-cameraState.pos.field_1351), (float)(-cameraState.pos.field_1350));
        float halfHeight = state.height / 2.0f;
        for (int i = 0; i <= state.segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)state.segments;
            float dx = (float)Math.cos(angle) * state.radius;
            float dz = (float)Math.sin(angle) * state.radius;
            buffer.method_22918(positionMatrix, (float)state.centre.method_10216() + dx, (float)state.centre.method_10214() + halfHeight, (float)state.centre.method_10215() + dz).method_39415(state.colour);
            buffer.method_22918(positionMatrix, (float)state.centre.method_10216() + dx, (float)state.centre.method_10214() - halfHeight, (float)state.centre.method_10215() + dz).method_39415(state.colour);
        }
    }
}

