/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.primitive;

import de.hysky.skyblocker.utils.render.FrustumUtils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.primitive.BeaconBeamRenderer;
import de.hysky.skyblocker.utils.render.primitive.BlockHologramRenderer;
import de.hysky.skyblocker.utils.render.primitive.CursorLineRenderer;
import de.hysky.skyblocker.utils.render.primitive.CylinderRenderer;
import de.hysky.skyblocker.utils.render.primitive.FilledBoxRenderer;
import de.hysky.skyblocker.utils.render.primitive.FilledCircleRenderer;
import de.hysky.skyblocker.utils.render.primitive.LinesRenderer;
import de.hysky.skyblocker.utils.render.primitive.OutlinedBoxRenderer;
import de.hysky.skyblocker.utils.render.primitive.OutlinedCircleRenderer;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.render.primitive.QuadRenderer;
import de.hysky.skyblocker.utils.render.primitive.SphereRenderer;
import de.hysky.skyblocker.utils.render.primitive.TextPrimitiveRenderer;
import de.hysky.skyblocker.utils.render.primitive.TexturedQuadRenderer;
import de.hysky.skyblocker.utils.render.state.BeaconBeamRenderState;
import de.hysky.skyblocker.utils.render.state.BlockHologramRenderState;
import de.hysky.skyblocker.utils.render.state.CameraRenderState;
import de.hysky.skyblocker.utils.render.state.CursorLineRenderState;
import de.hysky.skyblocker.utils.render.state.CylinderRenderState;
import de.hysky.skyblocker.utils.render.state.FilledBoxRenderState;
import de.hysky.skyblocker.utils.render.state.FilledCircleRenderState;
import de.hysky.skyblocker.utils.render.state.LinesRenderState;
import de.hysky.skyblocker.utils.render.state.OutlinedBoxRenderState;
import de.hysky.skyblocker.utils.render.state.OutlinedCircleRenderState;
import de.hysky.skyblocker.utils.render.state.QuadRenderState;
import de.hysky.skyblocker.utils.render.state.SphereRenderState;
import de.hysky.skyblocker.utils.render.state.TextRenderState;
import de.hysky.skyblocker.utils.render.state.TexturedQuadRenderState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5481;
import net.minecraft.class_9848;

public final class PrimitiveCollectorImpl
implements PrimitiveCollector {
    private static final class_310 CLIENT = class_310.method_1551();
    protected static final int MAX_OVERWORLD_BUILD_HEIGHT = 319;
    private List<FilledBoxRenderState> filledBoxStates = null;
    private List<BeaconBeamRenderState> beaconBeamStates = null;
    private List<OutlinedBoxRenderState> outlinedBoxStates = null;
    private List<LinesRenderState> linesStates = null;
    private List<CursorLineRenderState> cursorLineStates = null;
    private List<QuadRenderState> quadStates = null;
    private List<TexturedQuadRenderState> texturedQuadStates = null;
    private List<BlockHologramRenderState> blockHologramStates = null;
    private List<TextRenderState> textStates = null;
    private List<CylinderRenderState> cylinderStates = null;
    private List<FilledCircleRenderState> filledCircleStates = null;
    private List<SphereRenderState> sphereStates = null;
    private List<OutlinedCircleRenderState> outlinedCircleStates = null;
    private boolean frozen = false;

    @Override
    public void submitFilledBoxWithBeaconBeam(class_2338 pos, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(pos, colourComponents, alpha, throughWalls);
        this.submitBeaconBeam(pos, colourComponents);
    }

    @Override
    public void submitFilledBox(class_2338 pos, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colourComponents, alpha, throughWalls);
    }

    @Override
    public void submitFilledBox(class_243 pos, class_243 dimensions, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(pos.field_1352, pos.field_1351, pos.field_1350, pos.field_1352 + dimensions.field_1352, pos.field_1351 + dimensions.field_1351, pos.field_1350 + dimensions.field_1350, colourComponents, alpha, throughWalls);
    }

    @Override
    public void submitFilledBox(class_238 box, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colourComponents, alpha, throughWalls);
    }

    private void submitFilledBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colourComponents, float alpha, boolean throughWalls) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(minX, minY, minZ, maxX, maxY, maxZ)) {
            return;
        }
        if (this.filledBoxStates == null) {
            this.filledBoxStates = new ArrayList<FilledBoxRenderState>();
        }
        FilledBoxRenderState state = new FilledBoxRenderState();
        state.minX = minX;
        state.minY = minY;
        state.minZ = minZ;
        state.maxX = maxX;
        state.maxY = maxY;
        state.maxZ = maxZ;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.throughWalls = throughWalls;
        this.filledBoxStates.add(state);
    }

    private void submitBeaconBeam(class_2338 pos, float[] colourComponents) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, 319.0, pos.method_10260() + 1)) {
            return;
        }
        if (this.beaconBeamStates == null) {
            this.beaconBeamStates = new ArrayList<BeaconBeamRenderState>();
        }
        float length = (float)RenderHelper.getCamera().method_19326().method_1020(pos.method_46558()).method_37267();
        float scale = PrimitiveCollectorImpl.CLIENT.field_1724 != null && PrimitiveCollectorImpl.CLIENT.field_1724.method_31550() ? 1.0f : Math.max(1.0f, length / 96.0f);
        BeaconBeamRenderState state = new BeaconBeamRenderState();
        state.pos = pos;
        state.colour = class_9848.method_61318((float)1.0f, (float)colourComponents[0], (float)colourComponents[1], (float)colourComponents[2]);
        state.scale = scale;
        state.tickProgress = RenderHelper.getTickCounter().method_60637(true);
        state.worldTime = Objects.requireNonNull(PrimitiveCollectorImpl.CLIENT.field_1687).method_8510();
        this.beaconBeamStates.add(state);
    }

    @Override
    public void submitOutlinedBox(class_2338 pos, float[] colourComponents, float lineWidth, boolean throughWalls) {
        this.submitOutlinedBox(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colourComponents, 1.0f, lineWidth, throughWalls);
    }

    @Override
    public void submitOutlinedBox(class_238 box, float[] colourComponents, float lineWidth, boolean throughWalls) {
        this.submitOutlinedBox(box, colourComponents, 1.0f, lineWidth, throughWalls);
    }

    @Override
    public void submitOutlinedBox(class_238 box, float[] colourComponents, float alpha, float lineWidth, boolean throughWalls) {
        this.submitOutlinedBox(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colourComponents, alpha, lineWidth, throughWalls);
    }

    private void submitOutlinedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colourComponents, float alpha, float lineWidth, boolean throughWalls) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(minX, minY, minZ, maxX, maxY, maxZ)) {
            return;
        }
        if (this.outlinedBoxStates == null) {
            this.outlinedBoxStates = new ArrayList<OutlinedBoxRenderState>();
        }
        OutlinedBoxRenderState state = new OutlinedBoxRenderState();
        state.minX = minX;
        state.minY = minY;
        state.minZ = minZ;
        state.maxX = maxX;
        state.maxY = maxY;
        state.maxZ = maxZ;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.lineWidth = lineWidth;
        state.throughWalls = throughWalls;
        this.outlinedBoxStates.add(state);
    }

    @Override
    public void submitLinesFromPoints(class_243[] points, float[] colourComponents, float alpha, float lineWidth, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.linesStates == null) {
            this.linesStates = new ArrayList<LinesRenderState>();
        }
        LinesRenderState state = new LinesRenderState();
        state.points = points;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.lineWidth = lineWidth;
        state.throughWalls = throughWalls;
        this.linesStates.add(state);
    }

    @Override
    public void submitLineFromCursor(class_243 point, float[] colourComponents, float alpha, float lineWidth) {
        this.ensureNotFrozen();
        if (this.cursorLineStates == null) {
            this.cursorLineStates = new ArrayList<CursorLineRenderState>();
        }
        CursorLineRenderState state = new CursorLineRenderState();
        state.point = point;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.lineWidth = lineWidth;
        this.cursorLineStates.add(state);
    }

    @Override
    public void submitQuad(class_243[] points, float[] colourComponents, float alpha, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.quadStates == null) {
            this.quadStates = new ArrayList<QuadRenderState>();
        }
        QuadRenderState state = new QuadRenderState();
        state.points = points;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.throughWalls = throughWalls;
        this.quadStates.add(state);
    }

    @Override
    public void submitTexturedQuad(class_243 pos, float width, float height, float textureWidth, float textureHeight, class_243 renderOffset, class_2960 texture, float[] shaderColour, float alpha, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.texturedQuadStates == null) {
            this.texturedQuadStates = new ArrayList<TexturedQuadRenderState>();
        }
        TexturedQuadRenderState state = new TexturedQuadRenderState();
        state.pos = pos;
        state.width = width;
        state.height = height;
        state.textureWidth = textureWidth;
        state.textureHeight = textureHeight;
        state.renderOffset = renderOffset;
        state.texture = texture;
        state.shaderColour = shaderColour;
        state.alpha = alpha;
        state.throughWalls = throughWalls;
        this.texturedQuadStates.add(state);
    }

    @Override
    public void submitBlockHologram(class_2338 pos, class_2680 state) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1)) {
            return;
        }
        if (this.blockHologramStates == null) {
            this.blockHologramStates = new ArrayList<BlockHologramRenderState>();
        }
        BlockHologramRenderState renderState = new BlockHologramRenderState();
        renderState.pos = pos;
        renderState.state = state;
        this.blockHologramStates.add(renderState);
    }

    @Override
    public void submitText(class_2561 text, class_243 pos, boolean throughWalls) {
        this.submitText(text, pos, 1.0f, throughWalls);
    }

    @Override
    public void submitText(class_2561 text, class_243 pos, float scale, boolean throughWalls) {
        this.submitText(text, pos, scale, 0.0f, throughWalls);
    }

    @Override
    public void submitText(class_2561 text, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        this.submitText(text.method_30937(), pos, scale, yOffset, throughWalls);
    }

    private void submitText(class_5481 text, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.textStates == null) {
            this.textStates = new ArrayList<TextRenderState>();
        }
        class_327 textRenderer = PrimitiveCollectorImpl.CLIENT.field_1772;
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        class_327.class_11465 glyphs = textRenderer.method_71795(text, xOffset, yOffset, -1, false, 0);
        TextRenderState state = new TextRenderState();
        state.glyphs = glyphs;
        state.pos = pos;
        state.scale = scale * 0.025f;
        state.yOffset = yOffset;
        state.throughWalls = throughWalls;
        this.textStates.add(state);
    }

    @Override
    public void submitCylinder(class_243 centre, float radius, float height, int segments, int colour) {
        this.ensureNotFrozen();
        if (this.cylinderStates == null) {
            this.cylinderStates = new ArrayList<CylinderRenderState>();
        }
        CylinderRenderState state = new CylinderRenderState();
        state.centre = centre;
        state.radius = radius;
        state.height = height;
        state.segments = segments;
        state.colour = colour;
        this.cylinderStates.add(state);
    }

    @Override
    public void submitFilledCircle(class_243 centre, float radius, int segments, int colour) {
        this.ensureNotFrozen();
        if (this.filledCircleStates == null) {
            this.filledCircleStates = new ArrayList<FilledCircleRenderState>();
        }
        FilledCircleRenderState state = new FilledCircleRenderState();
        state.centre = centre;
        state.radius = radius;
        state.segments = segments;
        state.colour = colour;
        this.filledCircleStates.add(state);
    }

    @Override
    public void submitSphere(class_243 centre, float radius, int segments, int rings, int colour) {
        this.ensureNotFrozen();
        if (this.sphereStates == null) {
            this.sphereStates = new ArrayList<SphereRenderState>();
        }
        SphereRenderState state = new SphereRenderState();
        state.centre = centre;
        state.radius = radius;
        state.segments = segments;
        state.rings = rings;
        state.colour = colour;
        this.sphereStates.add(state);
    }

    @Override
    public void submitOutlinedCircle(class_243 centre, float radius, float thickness, int segments, int colour) {
        this.ensureNotFrozen();
        if (this.outlinedCircleStates == null) {
            this.outlinedCircleStates = new ArrayList<OutlinedCircleRenderState>();
        }
        OutlinedCircleRenderState state = new OutlinedCircleRenderState();
        state.centre = centre;
        state.radius = radius;
        state.thickness = thickness;
        state.segments = segments;
        state.colour = colour;
        this.outlinedCircleStates.add(state);
    }

    public void endCollection() {
        this.frozen = true;
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot submit primitives once the collection phase has ended!");
        }
    }

    public void dispatchPrimitivesToRenderers(CameraRenderState cameraState) {
        if (!this.frozen) {
            throw new IllegalStateException("Cannot dispatch primitives until the collection phase has ended!");
        }
        if (this.filledBoxStates != null) {
            for (FilledBoxRenderState filledBoxRenderState : this.filledBoxStates) {
                FilledBoxRenderer.INSTANCE.submitPrimitives(filledBoxRenderState, cameraState);
            }
        }
        if (this.beaconBeamStates != null) {
            for (BeaconBeamRenderState beaconBeamRenderState : this.beaconBeamStates) {
                BeaconBeamRenderer.INSTANCE.submitPrimitives(beaconBeamRenderState, cameraState);
            }
        }
        if (this.outlinedBoxStates != null) {
            for (OutlinedBoxRenderState outlinedBoxRenderState : this.outlinedBoxStates) {
                OutlinedBoxRenderer.INSTANCE.submitPrimitives(outlinedBoxRenderState, cameraState);
            }
        }
        if (this.linesStates != null) {
            for (LinesRenderState linesRenderState : this.linesStates) {
                LinesRenderer.INSTANCE.submitPrimitives(linesRenderState, cameraState);
            }
        }
        if (this.cursorLineStates != null) {
            for (CursorLineRenderState cursorLineRenderState : this.cursorLineStates) {
                CursorLineRenderer.INSTANCE.submitPrimitives(cursorLineRenderState, cameraState);
            }
        }
        if (this.quadStates != null) {
            for (QuadRenderState quadRenderState : this.quadStates) {
                QuadRenderer.INSTANCE.submitPrimitives(quadRenderState, cameraState);
            }
        }
        if (this.texturedQuadStates != null) {
            for (TexturedQuadRenderState texturedQuadRenderState : this.texturedQuadStates) {
                TexturedQuadRenderer.INSTANCE.submitPrimitives(texturedQuadRenderState, cameraState);
            }
        }
        if (this.blockHologramStates != null) {
            for (BlockHologramRenderState blockHologramRenderState : this.blockHologramStates) {
                BlockHologramRenderer.INSTANCE.submitPrimitives(blockHologramRenderState, cameraState);
            }
        }
        if (this.textStates != null) {
            for (TextRenderState textRenderState : this.textStates) {
                TextPrimitiveRenderer.INSTANCE.submitPrimitives(textRenderState, cameraState);
            }
        }
        if (this.cylinderStates != null) {
            for (CylinderRenderState cylinderRenderState : this.cylinderStates) {
                CylinderRenderer.INSTANCE.submitPrimitives(cylinderRenderState, cameraState);
            }
        }
        if (this.filledCircleStates != null) {
            for (FilledCircleRenderState filledCircleRenderState : this.filledCircleStates) {
                FilledCircleRenderer.INSTANCE.submitPrimitives(filledCircleRenderState, cameraState);
            }
        }
        if (this.sphereStates != null) {
            for (SphereRenderState sphereRenderState : this.sphereStates) {
                SphereRenderer.INSTANCE.submitPrimitives(sphereRenderState, cameraState);
            }
        }
        if (this.outlinedCircleStates != null) {
            for (OutlinedCircleRenderState outlinedCircleRenderState : this.outlinedCircleStates) {
                OutlinedCircleRenderer.INSTANCE.submitPrimitives(outlinedCircleRenderState, cameraState);
            }
        }
    }
}

