/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.waypoint;

import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2338;

public class ProfileAwareWaypoint
extends Waypoint {
    public final Set<String> foundProfiles = new HashSet<String>();
    private final float[] missingColor;
    private final float[] foundColor;

    public ProfileAwareWaypoint(class_2338 pos, Supplier<Waypoint.Type> typeSupplier, float[] missingColor, float[] foundColor) {
        super(pos, typeSupplier, null);
        this.missingColor = missingColor;
        this.foundColor = foundColor;
    }

    @Override
    public boolean shouldRender() {
        return !this.foundProfiles.contains(Utils.getProfile());
    }

    @Override
    public void setFound() {
        this.foundProfiles.add(Utils.getProfile());
    }

    public void setFound(String profile) {
        this.foundProfiles.add(profile);
    }

    @Override
    public void setMissing() {
        this.foundProfiles.remove(Utils.getProfile());
    }

    @Override
    public float[] getRenderColorComponents() {
        return this.foundProfiles.contains(Utils.getProfile()) ? this.foundColor : this.missingColor;
    }
}

