/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7677;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ResourcePackCompatibility {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ResourcePackOptions options = ResourcePackOptions.EMPTY;

    @Init(priority=-1)
    public static void init() {
        ResourceLoader.get((class_3264)class_3264.field_14188).registerReloader(SkyblockerMod.id("pack_compatibility_listener"), (class_3302)new ReloadListener());
    }

    public static ResourcePackOptions merge(@Nullable ResourcePackOptions a, List<ResourcePackOptions> b) {
        ResourcePackOptions above = b.removeFirst();
        if (a == null) {
            return b.isEmpty() ? above : ResourcePackCompatibility.merge(above, b);
        }
        ResourcePackOptions merged = new ResourcePackOptions(above.renameAuctionBrowser().isPresent() ? above.renameAuctionBrowser() : a.renameAuctionBrowser(), above.renameInventoryScreen().isPresent() ? above.renameInventoryScreen() : a.renameInventoryScreen(), above.renameCraftingTable().isPresent() ? above.renameCraftingTable() : a.renameCraftingTable());
        if (b.isEmpty()) {
            return merged;
        }
        return ResourcePackCompatibility.merge(merged, b);
    }

    private static final class ReloadListener
    extends class_4080<List<Pair<String, ResourcePackOptions>>> {
        private static final class_7677<String> ID_SERIALIZER = new class_7677("resource_pack_id", (Codec)Codec.STRING);
        private static final class_7677<ResourcePackOptions> SKYBLOCKER_SERIALIZER = new class_7677("skyblocker", ResourcePackOptions.CODEC);

        private ReloadListener() {
        }

        protected List<Pair<String, ResourcePackOptions>> prepare(class_3300 manager, class_3695 profiler) {
            return manager.method_29213().map(resourcePack -> {
                try {
                    return Pair.of((Object)((String)resourcePack.method_14407(ID_SERIALIZER)), (Object)((ResourcePackOptions)resourcePack.method_14407(SKYBLOCKER_SERIALIZER)));
                }
                catch (IOException e) {
                    LOGGER.error("[Skyblocker ResourcePack Compat] Failed to parse resource pack metadata", (Throwable)e);
                    return null;
                }
            }).toList();
        }

        protected void apply(List<Pair<String, ResourcePackOptions>> prepared, class_3300 manager, class_3695 profiler) {
            if (prepared.stream().anyMatch(p -> "FURFSKY_GUI".equals(p.first()))) {
                options = new ResourcePackOptions(Optional.of(true), Optional.of(true), Optional.of(false));
                LOGGER.info("[Skyblocker ResourcePack Compat] FURFSKY_GUI detected. Enabling compatibility names.");
                return;
            }
            ArrayList<ResourcePackOptions> list = new ArrayList<ResourcePackOptions>(prepared.stream().map(Pair::right).filter(Objects::nonNull).toList());
            options = !list.isEmpty() ? ResourcePackCompatibility.merge(null, list) : ResourcePackOptions.EMPTY;
            LOGGER.info("[Skyblocker ResourcePack Compat] " + options.toString());
        }
    }

    public record ResourcePackOptions(Optional<Boolean> renameAuctionBrowser, Optional<Boolean> renameInventoryScreen, Optional<Boolean> renameCraftingTable) {
        public static final ResourcePackOptions EMPTY = new ResourcePackOptions(Optional.empty(), Optional.empty(), Optional.empty());
        public static final Codec<ResourcePackOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("rename_auction_browser").forGetter(ResourcePackOptions::renameAuctionBrowser), (App)Codec.BOOL.optionalFieldOf("rename_inventory_screen").forGetter(ResourcePackOptions::renameInventoryScreen), (App)Codec.BOOL.optionalFieldOf("rename_crafting_table").forGetter(ResourcePackOptions::renameCraftingTable)).apply((Applicative)instance, ResourcePackOptions::new));
    }
}

