/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility.jei;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.compatibility.jei.SkyblockCraftingRecipeCategory;
import de.hysky.skyblocker.compatibility.jei.SkyblockForgeRecipeCategory;
import de.hysky.skyblocker.compatibility.jei.SkyblockNpcShopRecipeCategory;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.skyblock.garden.visitor.VisitorHelper;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockCraftingRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockForgeRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockNpcShopRecipe;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.datafixer.ItemStackComponentizationFixer;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.fabric.events.JeiLifecycleEvents;
import mezz.jei.library.ingredients.subtypes.SubtypeInterpreters;
import mezz.jei.library.load.registration.SubtypeRegistration;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_476;
import net.minecraft.class_490;
import net.minecraft.class_768;

@JeiPlugin
public class SkyblockerJEIPlugin
implements IModPlugin {
    private SkyblockCraftingRecipeCategory skyblockCraftingRecipeCategory;
    private SkyblockForgeRecipeCategory skyblockForgeRecipeCategory;
    private SkyblockNpcShopRecipeCategory skyblockNpcShopRecipeCategory;

    public static void trickJEIIntoLoadingRecipes() {
        ((Runnable)JeiLifecycleEvents.AFTER_RECIPE_SYNC.invoker()).run();
    }

    public class_2960 getPluginUid() {
        return SkyblockerMod.id("skyblock");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        SubtypeInterpreters interpreters = ((SubtypeRegistration)registration).getInterpreters();
        ItemRepository.getItemsStream().filter(stack -> !interpreters.contains(VanillaTypes.ITEM_STACK, stack)).map(class_1799::method_7909).distinct().forEach(item -> registration.registerSubtypeInterpreter(item, (stack, context) -> ItemStackComponentizationFixer.componentsAsString(stack)));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.skyblockCraftingRecipeCategory = new SkyblockCraftingRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.skyblockCraftingRecipeCategory});
        this.skyblockForgeRecipeCategory = new SkyblockForgeRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.skyblockForgeRecipeCategory});
        this.skyblockNpcShopRecipeCategory = new SkyblockNpcShopRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.skyblockNpcShopRecipeCategory});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(class_476.class, (IGuiContainerHandler)new GenericContainerHandler());
        registration.addGuiContainerHandler(class_490.class, (IGuiContainerHandler)new InventoryContainerHandler());
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new GlobalHandler());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, ItemRepository.getItems());
        registration.addRecipes(this.skyblockCraftingRecipeCategory.getRecipeType(), ItemRepository.getRecipesStream().filter(SkyblockCraftingRecipe.class::isInstance).map(SkyblockCraftingRecipe.class::cast).toList());
        registration.addRecipes(this.skyblockForgeRecipeCategory.getRecipeType(), ItemRepository.getRecipesStream().filter(SkyblockForgeRecipe.class::isInstance).map(SkyblockForgeRecipe.class::cast).toList());
        registration.addRecipes(this.skyblockNpcShopRecipeCategory.getRecipeType(), ItemRepository.getRecipesStream().filter(SkyblockNpcShopRecipe.class::isInstance).map(SkyblockNpcShopRecipe.class::cast).toList());
    }

    private static class GenericContainerHandler
    implements IGuiContainerHandler<class_476> {
        private GenericContainerHandler() {
        }

        public List<class_768> getGuiExtraAreas(class_476 containerScreen) {
            if (!(Utils.isOnSkyblock() && SkyblockerConfigManager.get().uiAndVisuals.museumOverlay && containerScreen.method_25440().getString().contains("Museum"))) {
                return List.of();
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)containerScreen;
            return List.of(new class_768(accessor.getX() + accessor.getBackgroundWidth() + 4, accessor.getY(), 147, 160));
        }
    }

    private static class InventoryContainerHandler
    implements IGuiContainerHandler<class_490> {
        private InventoryContainerHandler() {
        }

        public List<class_768> getGuiExtraAreas(class_490 containerScreen) {
            if (!(Utils.isOnSkyblock() && SkyblockerConfigManager.get().farming.garden.gardenPlotsWidget && Utils.isInGarden())) {
                return List.of();
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)containerScreen;
            return List.of(new class_768(accessor.getX() + accessor.getBackgroundWidth() + 4, accessor.getY(), 104, 127));
        }
    }

    private static class GlobalHandler
    implements IGlobalGuiHandler {
        private GlobalHandler() {
        }

        public List<class_768> getGuiExtraAreas() {
            if (!Utils.isOnSkyblock() || !VisitorHelper.shouldRender()) {
                return List.of();
            }
            return VisitorHelper.getExclusionZones().stream().map(rect -> new class_768(rect.comp_1195().comp_1193(), rect.comp_1195().comp_1194(), rect.comp_1196(), rect.comp_1197())).toList();
        }
    }
}

