/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config;

import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.render.gui.AbstractWidget;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public abstract class HudConfigScreen
extends class_437 {
    protected final class_437 parent;
    protected final List<AbstractWidget> widgets;
    private AbstractWidget draggingWidget;
    private double mouseClickRelativeX;
    private double mouseClickRelativeY;

    public HudConfigScreen(class_2561 title, class_437 parent, AbstractWidget widget) {
        this(title, parent, List.of(widget));
    }

    public HudConfigScreen(class_2561 title, class_437 parent, List<AbstractWidget> widgets) {
        super(title);
        this.parent = parent;
        this.widgets = widgets;
    }

    protected void method_25426() {
        super.method_25426();
        this.resetPos();
    }

    public final void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderWidget(context, this.widgets, delta);
        context.method_25300(this.field_22793, "Right Click To Reset Position", this.field_22789 / 2, this.field_22790 / 2, Color.GRAY.getRGB());
    }

    protected void renderWidget(class_332 context, List<AbstractWidget> widgets, float delta) {
        for (AbstractWidget widget : widgets) {
            widget.method_25394(context, -1, -1, delta);
        }
    }

    public final boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (click.method_74245() == 0 && this.draggingWidget != null) {
            this.draggingWidget.method_46421((int)Math.clamp(click.comp_4798() - this.mouseClickRelativeX, 0.0, (double)(this.field_22789 - this.draggingWidget.method_25368())) - this.getWidgetXOffset(this.draggingWidget));
            this.draggingWidget.method_46419((int)Math.clamp(click.comp_4799() - this.mouseClickRelativeY, 0.0, (double)(this.field_22790 - this.draggingWidget.method_25364())));
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public final boolean method_25402(class_11909 click, boolean doubled) {
        if (click.method_74245() == 0) {
            for (AbstractWidget widget : this.widgets) {
                if (!HudHelper.pointIsInArea(click.comp_4798(), click.comp_4799(), widget.method_46426() + this.getWidgetXOffset(widget), widget.method_46427(), widget.method_46426() + this.getWidgetXOffset(widget) + widget.method_25368(), widget.method_46427() + widget.method_25364())) continue;
                this.draggingWidget = widget;
                this.mouseClickRelativeX = click.comp_4798() - (double)widget.method_46426() - (double)this.getWidgetXOffset(widget);
                this.mouseClickRelativeY = click.comp_4799() - (double)widget.method_46427();
                break;
            }
        } else if (click.method_74245() == 1) {
            this.resetPos();
        }
        return super.method_25402(click, doubled);
    }

    public final boolean method_25406(class_11909 click) {
        this.draggingWidget = null;
        return super.method_25406(click);
    }

    protected int getWidgetXOffset(AbstractWidget widget) {
        return 0;
    }

    protected void resetPos() {
        List<IntIntMutablePair> configPositions = this.getConfigPos(SkyblockerConfigManager.get());
        if (configPositions.size() != this.widgets.size()) {
            throw new IllegalStateException("The number of positions (" + configPositions.size() + ") does not match the number of widgets (" + this.widgets.size() + ")");
        }
        for (int i = 0; i < this.widgets.size(); ++i) {
            AbstractWidget widget = this.widgets.get(i);
            IntIntMutablePair configPos = configPositions.get(i);
            widget.method_46421(configPos.leftInt());
            widget.method_46419(configPos.rightInt());
        }
    }

    protected abstract List<IntIntMutablePair> getConfigPos(SkyblockerConfig var1);

    public final void method_25419() {
        SkyblockerConfigManager.update(config -> this.savePos((SkyblockerConfig)config, this.widgets));
        this.field_22787.method_1507(this.parent);
    }

    protected abstract void savePos(SkyblockerConfig var1, List<AbstractWidget> var2);
}

