/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config.datafixer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.datafixer.ConfigFix1;
import de.hysky.skyblocker.config.datafixer.ConfigFix2QuickNav;
import de.hysky.skyblocker.config.datafixer.ConfigFix3AnimatedDyeAndItemBackground;
import de.hysky.skyblocker.config.datafixer.ConfigSchema;
import de.hysky.skyblocker.utils.datafixer.JsonHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class ConfigDataFixer {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    public static final DSL.TypeReference CONFIG_TYPE = () -> "config";

    public static void apply() {
        ConfigDataFixer.apply(CONFIG_DIR.resolve("skyblocker.json"), CONFIG_DIR.resolve("skyblocker.json.old"));
    }

    public static void apply(Path configDir, Path backupDir) {
        if (!Files.exists(CONFIG_DIR, new LinkOption[0]) || !Files.exists(configDir, new LinkOption[0])) {
            return;
        }
        JsonObject oldConfig = ConfigDataFixer.loadConfig(configDir);
        if (oldConfig == null || JsonHelper.getInt(oldConfig, "version").orElse(1) == 4) {
            return;
        }
        JsonObject newConfig = ConfigDataFixer.apply(oldConfig);
        if (!ConfigDataFixer.writeConfig(configDir, newConfig)) {
            LOGGER.error(LogUtils.FATAL_MARKER, "[Skyblocker Config Data Fixer] Failed to fix up config file!");
            ConfigDataFixer.writeConfig(backupDir, oldConfig);
        }
    }

    public static JsonObject apply(JsonObject oldConfig) {
        return ConfigDataFixer.apply(oldConfig, 4);
    }

    public static JsonObject apply(JsonObject oldConfig, int newVersion) {
        long start = System.currentTimeMillis();
        JsonObject newConfig = ((JsonElement)ConfigDataFixer.build().update(CONFIG_TYPE, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)oldConfig), JsonHelper.getInt(oldConfig, "version").orElse(1), newVersion).getValue()).getAsJsonObject();
        long end = System.currentTimeMillis();
        LOGGER.info("[Skyblocker Config Data Fixer] Applied datafixers in {} ms!", (Object)(end - start));
        return newConfig;
    }

    private static DataFixer build() {
        DataFixerBuilder builder = new DataFixerBuilder(4);
        builder.addSchema(1, ConfigSchema::new);
        Schema schema2 = builder.addSchema(2, Schema::new);
        builder.addFixer((DataFix)new ConfigFix1(schema2, true));
        Schema schema3 = builder.addSchema(3, Schema::new);
        builder.addFixer((DataFix)new ConfigFix2QuickNav(schema3, true));
        Schema schema4 = builder.addSchema(4, Schema::new);
        builder.addFixer((DataFix)new ConfigFix3AnimatedDyeAndItemBackground(schema4, true));
        return builder.build().fixer();
    }

    private static JsonObject loadConfig(Path path) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("[Skyblocker Config Data Fixer] Failed to load config file!", t);
                    return null;
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    private static boolean writeConfig(Path path, JsonObject config) {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
            try {
                SkyblockerMod.GSON.toJson((JsonElement)config, (Appendable)writer);
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("[Skyblocker Config Data Fixer] Failed to save config file at {}!", (Object)path, (Object)t);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }
}

