/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config.screens.powdertracker;

import de.hysky.skyblocker.mixins.accessors.CheckboxWidgetAccessor;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_6379;

public class ItemTickList<T>
extends class_4265<ItemTickEntry> {
    private final Collection<T> filters;
    private final Collection<T> allItems;
    private final boolean whitelist;

    public ItemTickList(class_310 minecraftClient, int width, int height, int y, int entryHeight, Collection<T> filters, Collection<T> allItems) {
        super(minecraftClient, width, height, y, entryHeight);
        this.filters = filters;
        this.allItems = allItems;
        this.whitelist = false;
    }

    public ItemTickList(class_310 minecraftClient, int width, int height, int y, int entryHeight, Collection<T> filters, Collection<T> allItems, boolean whitelist) {
        super(minecraftClient, width, height, y, entryHeight);
        this.filters = filters;
        this.allItems = allItems;
        this.whitelist = whitelist;
    }

    public void clearAndInit() {
        this.method_25339();
        this.init();
    }

    public ItemTickList<T> init() {
        for (T item : this.allItems) {
            ItemTickEntry entry = new ItemTickEntry(class_4286.method_54787((class_2561)class_2561.method_30163((String)item.toString()), (class_327)this.field_22740.field_1772).method_54794(this.whitelist == this.filters.contains(item)).method_54791((checkbox1, checked) -> {
                if (this.whitelist) {
                    if (checked) {
                        this.filters.add(item);
                    } else {
                        this.filters.remove(item);
                    }
                } else if (checked) {
                    this.filters.remove(item);
                } else {
                    this.filters.add(item);
                }
            }).method_54788());
            this.method_25321((class_350.class_351)entry);
        }
        return this;
    }

    public static class ItemTickEntry
    extends class_4265.class_4266<ItemTickEntry> {
        private final List<class_4286> children;

        ItemTickEntry(class_4286 checkboxWidget) {
            this.children = List.of(checkboxWidget);
        }

        public void setChecked(boolean checked) {
            for (class_4286 child : this.children) {
                ((CheckboxWidgetAccessor)child).setChecked(checked);
            }
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            for (class_4286 child : this.children) {
                child.method_46421(this.method_46426());
                child.method_46419(this.method_46427());
                child.method_25358(this.method_25368());
                child.method_53533(this.method_25364());
                child.method_25394(context, mouseX, mouseY, deltaTicks);
            }
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }
    }
}

