/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.debug;

import com.google.gson.JsonElement;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.SnapshotDebug;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.mixins.accessors.InGameHudInvoker;
import de.hysky.skyblocker.skyblock.events.EventNotifications;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.networth.NetworthCalculator;
import java.util.List;
import net.azureaaron.networth.Calculation;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class Debug {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG_ENABLED = Boolean.parseBoolean(System.getProperty("skyblocker.debug", "false"));
    private static boolean keyDown = false;

    public static boolean debugEnabled() {
        return DEBUG_ENABLED || FabricLoader.getInstance().isDevelopmentEnvironment() || SnapshotDebug.isInSnapshot();
    }

    public static boolean isTestEnvironment() {
        return Boolean.getBoolean("IS_TEST_ENV");
    }

    public static boolean webSocketDebug() {
        return SkyblockerConfigManager.get().debug.webSocketDebug;
    }

    @Init
    public static void init() {
        if (!Debug.debugEnabled()) {
            return;
        }
        SnapshotDebug.init();
        class_304 dumpNearbyEntitiesKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.skyblocker.debug.dumpNearbyEntities", 73, SkyblockerMod.KEYBINDING_CATEGORY));
        class_304 dumpHoveredItemKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.skyblocker.debug.dumpHoveredItem", 85, SkyblockerMod.KEYBINDING_CATEGORY));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debug").then(Debug.dumpPlayersCommand())).then(ItemUtils.dumpHeldItemCommand())).then(ItemUtils.dumpHeldItemNetworthCalculationsCommand())).then(Debug.toggleShowingInvisibleArmorStands())).then(Debug.dumpArmorStandHeadTextures())).then(Debug.toggleWebSocketDebug())).then(EventNotifications.debugToasts())).then(Debug.dumpBiome())).then(Debug.dumpActionBar())).then(Debug.auditMixins()))));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            if (dumpNearbyEntitiesKey.method_1436() && !keyDown) {
                client.field_1687.method_8335((class_1297)client.field_1724, client.field_1724.method_5829().method_1014((double)SkyblockerConfigManager.get().debug.dumpRange)).stream().map(entity -> {
                    class_11362 writeView = class_11362.method_71459((class_8942)new class_8942.class_11340(LOGGER), (class_7225.class_7874)Utils.getRegistryWrapperLookup());
                    entity.method_5647((class_11372)writeView);
                    return writeView.method_71475();
                }).map(class_2512::method_32270).forEach(text -> client.field_1724.method_7353(text, false));
                keyDown = true;
            } else if (!dumpNearbyEntitiesKey.method_1436() && keyDown) {
                keyDown = false;
            }
        });
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!(screen instanceof class_465)) {
                return;
            }
            class_465 handledScreen = (class_465)screen;
            ScreenKeyboardEvents.afterKeyPress((class_437)screen).register((_screen, keyInput) -> {
                class_1735 focusedSlot = ((HandledScreenAccessor)handledScreen).getFocusedSlot();
                if (dumpHoveredItemKey.method_1417(keyInput) && client.field_1724 != null && focusedSlot != null && focusedSlot.method_7681()) {
                    if (!keyInput.method_74239()) {
                        client.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_27693("Hovered Item: ").method_10852(SkyblockerConfigManager.get().debug.dumpFormat.format(focusedSlot.method_7677())), false);
                    } else {
                        client.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_27693("Held Item NW Calcs: ").method_10852((class_2561)class_2561.method_43470((String)SkyblockerMod.GSON_COMPACT.toJson((JsonElement)Calculation.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)NetworthCalculator.getItemNetworth(focusedSlot.method_7677()).calculations()).getOrThrow()))), false);
                    }
                }
            });
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> dumpPlayersCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpPlayers").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getWorld().method_18456().forEach(player -> ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("'" + player.method_5477().getString() + "'"))));
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> toggleShowingInvisibleArmorStands() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggleShowingInvisibleArmorStands").executes(context -> {
            SkyblockerConfigManager.update(config -> {
                config.debug.showInvisibleArmorStands = !config.debug.showInvisibleArmorStands;
            });
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.debug.toggledShowingInvisibleArmorStands", (Object[])new Object[]{SkyblockerConfigManager.get().debug.showInvisibleArmorStands})));
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> toggleWebSocketDebug() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggleWebSocketDebug").executes(context -> {
            SkyblockerConfigManager.update(config -> {
                config.debug.webSocketDebug = !SkyblockerConfigManager.get().debug.webSocketDebug;
            });
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.debug.toggledWebSocketDebug", (Object[])new Object[]{SkyblockerConfigManager.get().debug.webSocketDebug})));
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> dumpArmorStandHeadTextures() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpArmorStandHeadTextures").executes(context -> {
            List armorStands = ((FabricClientCommandSource)context.getSource()).getWorld().method_8390(class_1531.class, ((FabricClientCommandSource)context.getSource()).getPlayer().method_5829().method_1014(8.0), class_1301.field_6153);
            for (class_1531 armorStand : armorStands) {
                List<class_1799> equippedItems = ItemUtils.getArmor((class_1309)armorStand);
                for (class_1799 stack : equippedItems) {
                    ItemUtils.getHeadTextureOptional(stack).ifPresent(texture -> ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)texture)));
                }
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> dumpBiome() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpBiome").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            class_6880 biome = source.getWorld().method_23753(source.getPlayer().method_24515());
            if (biome != null && biome.comp_349() != null) {
                String biomeData = (String)class_1959.field_25819.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((class_1959)biome.comp_349())).map(JsonElement::toString).setPartial((Object)"").getPartialOrThrow();
                source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)String.format("Biome ID: %s, Data: %s", biome.method_55840(), biomeData))));
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> dumpActionBar() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpActionBar").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            class_2561 actionBar = ((InGameHudInvoker)source.getClient().field_1705).getOverlayMessage();
            if (actionBar != null) {
                class_2561 pretty = class_2512.method_32270((class_2520)((class_2520)class_8824.field_46597.encodeStart((DynamicOps)Utils.getRegistryWrapperLookup().method_57093((DynamicOps)class_2509.field_11560), (Object)actionBar).getOrThrow()));
                source.sendFeedback((class_2561)Constants.PREFIX.get().method_27693("Action Bar: ").method_10852(pretty));
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> auditMixins() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"auditMixins").executes(context -> {
            MixinEnvironment.getCurrentEnvironment().audit();
            return 1;
        });
    }

    public static enum DumpFormat {
        JSON{

            @Override
            public class_2561 format(class_1799 stack) {
                return class_2561.method_43470((String)SkyblockerMod.GSON_COMPACT.toJson((JsonElement)ItemUtils.EMPTY_ALLOWING_ITEMSTACK_CODEC.encodeStart((DynamicOps)Utils.getRegistryWrapperLookup().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)stack).getOrThrow()));
            }
        }
        ,
        SNBT{

            @Override
            public class_2561 format(class_1799 stack) {
                return class_2512.method_32270((class_2520)((class_2520)ItemUtils.EMPTY_ALLOWING_ITEMSTACK_CODEC.encodeStart((DynamicOps)class_310.method_1551().field_1724.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)stack).getOrThrow()));
            }
        };


        public abstract class_2561 format(class_1799 var1);
    }
}

