/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.Utils;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CallAutocomplete {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    public static LiteralCommandNode<FabricClientCommandSource> commandNode;

    @Init
    public static void init() {
        NEURepoManager.runAsyncAfterLoad(CallAutocomplete::loadCallNames);
    }

    private static void loadCallNames() {
        try (InputStream stream = NEURepoManager.file("constants/abiphone.json").stream();){
            String data = new String(stream.readAllBytes());
            Map contacts = (Map)AbiphoneContact.MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)data)).getOrThrow();
            List suggestions = contacts.entrySet().stream().map(entry -> CallAutocomplete.computeCallNames((String)entry.getKey(), (AbiphoneContact)entry.getValue())).flatMap(Collection::stream).toList();
            commandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"call").requires(fccs -> Utils.isOnSkyblock())).then((ArgumentBuilder)ClientCommandManager.argument((String)"contact", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265((Iterable)suggestions, (SuggestionsBuilder)builder)))).build();
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Call Autocomplete] Failed to load abiphone contacts list!", (Throwable)e);
        }
    }

    private static List<String> computeCallNames(String npcName, AbiphoneContact contact) {
        return contact.callNames().isPresent() ? contact.callNames().get() : List.of(CallAutocomplete.formatDefaultCallName(npcName));
    }

    private static String formatDefaultCallName(String npcName) {
        return npcName.toLowerCase(Locale.ENGLISH).replaceAll("\\s", "");
    }

    private record AbiphoneContact(Optional<List<String>> callNames) {
        private static final Codec<AbiphoneContact> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("callNames").forGetter(AbiphoneContact::callNames)).apply((Applicative)instance, AbiphoneContact::new));
        private static final Codec<Map<String, AbiphoneContact>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC);
    }
}

