/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import java.util.Locale;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_7842;
import org.jetbrains.annotations.NotNull;

public class InventorySearch {
    private static class_465<?> openedHandledScreen = null;
    private static final Int2BooleanMap slotToMatch = new Int2BooleanArrayMap(64);
    private static String search = "";

    @Init
    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            UIAndVisualsConfig.InventorySearchConfig inventorySearchConfig = SkyblockerConfigManager.get().uiAndVisuals.inventorySearch;
            if (!inventorySearchConfig.enabled.isEnabled() || !(screen instanceof class_465)) {
                return;
            }
            class_465 handledScreen = (class_465)screen;
            if (inventorySearchConfig.clickableText) {
                Screens.getButtons((class_437)handledScreen).add(new SearchTextWidget(handledScreen));
            }
            ScreenKeyboardEvents.allowKeyPress((class_437)handledScreen).register((screen1, input) -> {
                if (input.comp_4795() == (inventorySearchConfig.ctrlK ? 75 : 70) && input.method_74240()) {
                    InventorySearch.showSearchBar(handledScreen);
                    return false;
                }
                return true;
            });
        });
    }

    public static void showSearchBar(class_465<?> handledScreen) {
        if (handledScreen == openedHandledScreen) {
            return;
        }
        openedHandledScreen = handledScreen;
        class_342 textFieldWidget = InventorySearch.getTextFieldWidget(handledScreen);
        Screens.getButtons(handledScreen).add(new class_7842(0, 5, handledScreen.field_22789, 10, (class_2561)class_2561.method_43470((String)"Search Inventory"), handledScreen.method_64506()));
        Screens.getButtons(handledScreen).addFirst(textFieldWidget);
        Screens.getButtons(handledScreen).removeIf(button -> button instanceof SearchTextWidget);
        handledScreen.method_25395((class_364)textFieldWidget);
        ScreenEvents.remove(handledScreen).register(InventorySearch::onScreenClosed);
    }

    @NotNull
    private static class_342 getTextFieldWidget(class_465<?> handledScreen) {
        SearchTextFieldWidget textFieldWidget = new SearchTextFieldWidget(handledScreen);
        textFieldWidget.method_48229((handledScreen.field_22789 - textFieldWidget.method_25368()) / 2, 15);
        textFieldWidget.method_47404((class_2561)class_2561.method_43471((String)"gui.socialInteractions.search_hint"));
        textFieldWidget.method_1852(search);
        textFieldWidget.method_1863(InventorySearch::onSearchTyped);
        return textFieldWidget;
    }

    public static boolean isSearching() {
        return openedHandledScreen != null;
    }

    public static boolean slotMatches(class_1735 slot) {
        return slotToMatch.computeIfAbsent(slot.field_7874, i -> slot.method_7681() && (slot.method_7677().method_7964().getString().toLowerCase(Locale.ENGLISH).contains(search) || ItemUtils.getLoreLineIf(slot.method_7677(), s -> s.toLowerCase(Locale.ENGLISH).contains(search)) != null));
    }

    private static void onSearchTyped(String text) {
        slotToMatch.clear();
        search = text.toLowerCase(Locale.ENGLISH);
    }

    private static void onScreenClosed(class_437 screen) {
        openedHandledScreen = null;
        slotToMatch.clear();
    }

    public static void refreshSlot(int slotId) {
        slotToMatch.remove(slotId);
    }

    public static class SearchTextFieldWidget
    extends class_342 {
        public SearchTextFieldWidget(class_465<?> handledScreen) {
            super(handledScreen.method_64506(), 120, 20, (class_2561)class_2561.method_43470((String)"Search Inventory"));
        }

        public boolean method_25404(class_11908 input) {
            return super.method_25404(input) || input.comp_4795() != 256 && this.method_25370();
        }

        public boolean method_25402(class_11909 click, boolean doubled) {
            if (this.method_25370() && !this.method_25405(click.comp_4798(), click.comp_4799())) {
                this.method_25365(false);
                return false;
            }
            return super.method_25402(click, doubled);
        }
    }

    private static class SearchTextWidget
    extends class_7842 {
        private final class_2561 underlinedText;
        private final class_2561 normalText;
        private final class_465<?> screen;
        private boolean hoveredState = false;

        private SearchTextWidget(class_465<?> handledScreen) {
            super((class_2561)class_2561.method_43471((String)"skyblocker.inventorySearch.clickHereToSearch"), handledScreen.method_64506());
            this.method_48229((handledScreen.field_22789 - this.method_25368()) / 2, 15);
            this.underlinedText = this.method_25369().method_27661().method_27692(class_124.field_1073);
            this.normalText = this.method_25369().method_27661().method_27692(class_124.field_1080);
            this.screen = handledScreen;
            this.method_25355(this.normalText);
        }

        public void method_25348(class_11909 click, boolean doubled) {
            InventorySearch.showSearchBar(this.screen);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            if (this.method_49606() != this.hoveredState) {
                this.hoveredState = this.field_22763 = this.method_49606();
                if (this.hoveredState) {
                    this.method_25355(this.underlinedText);
                } else {
                    this.method_25355(this.normalText);
                }
            }
            super.method_48579(context, mouseX, mouseY, delta);
        }
    }
}

