/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RegexUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azureaaron.networth.utils.PetConstants;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_5481;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class PetCache {
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("pet_cache.json");
    private static final ProfiledData<PetInfo> CACHED_PETS = new ProfiledData<PetInfo>(FILE, PetInfo.CODEC, true, true);
    private static final Pattern AUTOPET_PATTERN = Pattern.compile("^Autopet equipped your \\[Lvl (?<level>\\d+)\\] (?<name>[A-Za-z ]+)(?: \u2726)?! VIEW RULE$");
    private static boolean shouldLook4Pets;

    @Init
    public static void init() {
        CACHED_PETS.load();
        ScreenEvents.BEFORE_INIT.register((_client, screen, _scaledWidth, _scaledHeight) -> {
            class_476 genericContainerScreen;
            if (Utils.isOnSkyblock() && screen instanceof class_476 && (genericContainerScreen = (class_476)screen).method_25440().getString().startsWith("Pets")) {
                shouldLook4Pets = true;
                ScreenEvents.afterTick((class_437)screen).register(screen1 -> {
                    if (shouldLook4Pets) {
                        for (class_1735 slot : ((class_1707)genericContainerScreen.method_17577()).field_7761) {
                            class_1799 stack = slot.method_7677();
                            if (stack.method_7960() || ItemUtils.getLoreLineIf(stack, line -> line.equals("Click to despawn!")) == null) continue;
                            shouldLook4Pets = false;
                            PetCache.parsePet(stack, false);
                            break;
                        }
                    }
                });
            }
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register(PetCache::onMessage);
    }

    public static void handlePetEquip(class_1735 slot, int slotId) {
        class_1799 stack;
        if (slotId >= 0 && slotId <= 53 && !(stack = slot.method_7677()).method_7960()) {
            PetCache.parsePet(stack, true);
        }
    }

    private static void parsePet(class_1799 stack, boolean clicked) {
        String profileId = Utils.getProfileId();
        if (stack.getSkyblockId().equals("PET") && !profileId.isEmpty()) {
            PetInfo petInfo = stack.getPetInfo();
            if (petInfo.isEmpty()) {
                return;
            }
            shouldLook4Pets = false;
            if (clicked && PetCache.getCurrentPet() != null && PetCache.getCurrentPet().uuid().orElse("").equals(petInfo.uuid().orElse(""))) {
                CACHED_PETS.remove();
            } else {
                CACHED_PETS.put(petInfo);
            }
            CACHED_PETS.save();
        }
    }

    private static boolean onMessage(class_2561 text, boolean overlay) {
        if (!Utils.isOnSkyblock() || overlay) {
            return true;
        }
        String stringified = class_124.method_539((String)text.getString());
        Matcher matcher = AUTOPET_PATTERN.matcher(stringified);
        if (matcher.matches()) {
            int level = RegexUtils.parseIntFromMatcher(matcher, "level");
            String name = matcher.group("name");
            class_5481 ordered = text.method_30937();
            int nameIndex = stringified.indexOf(name);
            MutableInt codePointIndex = new MutableInt(0);
            MutableInt color = new MutableInt(-1);
            ordered.accept((index, style, codePoint) -> {
                if (codePointIndex.intValue() == nameIndex) {
                    color.setValue(style.method_10973().method_27716());
                    return false;
                }
                codePointIndex.getAndIncrement();
                return true;
            });
            SkyblockItemRarity rarity = SkyblockItemRarity.fromColor(color.intValue());
            if (rarity != null && rarity != SkyblockItemRarity.UNKNOWN) {
                int petOffset = PetConstants.RARITY_OFFSETS.getOrDefault((Object)rarity.name(), 0);
                IntArrayList petLevels = new IntArrayList(PetConstants.PET_LEVELS.subList(petOffset, petOffset + level - 1));
                double exp = petLevels.intStream().sum();
                class_1799 stack = ItemRepository.getItemsStream().filter(s -> s.method_7964().getString().contains("] " + name)).findFirst().orElse(class_1799.field_8037);
                if (!stack.method_7960()) {
                    class_1799 copied = stack.method_7972();
                    class_2487 customData = ((class_9279)copied.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
                    customData.method_10582("id", "PET");
                    copied.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customData));
                    String type = !copied.getPetInfo().isEmpty() ? copied.getPetInfo().type() : name.toUpperCase(Locale.ENGLISH).replace(" ", "_");
                    PetInfo petInfo = new PetInfo(Optional.of(name), type, exp, rarity, Optional.empty(), Optional.empty(), Optional.empty());
                    CACHED_PETS.put(petInfo);
                    CACHED_PETS.save();
                }
            }
        }
        return true;
    }

    @Nullable
    public static PetInfo getCurrentPet() {
        return CACHED_PETS.get();
    }
}

